<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\admin\controller\bbfxshop;

use app\admin\controller\bbfxshop\Base;
use think\Db;
use think\Cache;

class Index extends Base
{

    public function _initialize(){
        parent::_initialize();
    }
    
    public function getStatisticsdays(){
        $params = $this->param();
        
        $activeIndex = intval($params['activeIndex']);
        
        $days = [];
        $days_list = [];
        for($i = 0;$i < 29;$i++){
            $days[] = date("m-d",strtotime("-".(29-$i)." day"));
            $days_list[] = date("Y-m-d",strtotime("-".(29-$i)." day"));
        }
        $days[] = date("m-d");
        $days_list[] = date("Y-m-d");
        
        
        $list = [];
        if($activeIndex == 1){
            foreach ($days_list as $val) {
                $list[] = Db::name("bbfx_order")->where(['uniacid'=>UNIACID,'status'=>['>',0],'createtime'=>['<=',strtotime($val." 23:59:59")]])->count();
            }
        }
        else if($activeIndex == 2){
            foreach ($days_list as $val) {
                $list[] = Db::name("bbfx_user")->where(['uniacid'=>UNIACID,'createtime'=>['<=',strtotime($val." 23:59:59")]])->count();
            }
        }
        else if($activeIndex == 3){
            foreach ($days_list as $val) {
                $list[] = Db::name("bbfx_user")->where(['uniacid'=>UNIACID,'createtime'=>['>=',strtotime($val." 00:00:00")]])->where(['createtime'=>['<=',strtotime($val." 23:59:59")]])->count();
            }
        }
        else if($activeIndex == 4){
            foreach ($days_list as $val) {
                $list[] = Db::name("bbfx_user")->where(['uniacid'=>UNIACID,'is_distributor'=>1,'become_distributor_time'=>['<=',strtotime($val." 23:59:59")]])->count();
            }
        }
        else if($activeIndex == 5){
            foreach ($days_list as $val) {
                $list[] = Db::name("bbfx_user")->where(['uniacid'=>UNIACID,'is_distributor'=>1,'become_distributor_time'=>['between',[strtotime($val." 00:00:00"),strtotime($val." 23:59:59")]]])->count();
            }
        }
        else if($activeIndex == 6){
            foreach ($days_list as $val) {
                $list[] = Db::name("bbfx_order")->where(['uniacid'=>UNIACID,'createtime'=>['>=',strtotime($val." 00:00:00")]])->where(['createtime'=>['<=',strtotime($val." 23:59:59")]])->count();
            } 
        }
        else if($activeIndex == 7){
            foreach ($days_list as $val) {
                $list[] = Db::name("bbfx_order")->where(['uniacid'=>UNIACID,'status'=>['>',0],'createtime'=>['>=',strtotime($val." 00:00:00")]])->where(['createtime'=>['<=',strtotime($val." 23:59:59")]])->count();
            }
        }
        else{
            foreach ($days_list as $val) {
                $list[] = Db::name("bbfx_order")->where(['uniacid'=>UNIACID,'createtime'=>['<=',strtotime($val." 23:59:59")]])->count();
            }
        }
        
        __success("操作成功",['days'=>$days,'list'=>$list]);
    }
    
    public function statistics(){
        $params = $this->param();
        
        $type = intval($params['type']);
        
        $params1 = ['uniacid'=>UNIACID];
        $params2 = $params1;
        $params2['is_pay'] = 1;
        
        $start_time = 0;
        if($type == 1){
            $start_time = strtotime(date("Y-m-d 00:00:00"));
        }
        else if($type == 2){
            $start_time = strtotime(date("Y-m-d 00:00:00")) - 7*86400;
        }
        else if($type == 3){
            $start_time = strtotime(date("Y-m-d 00:00:00")) - 15*86400;
        }
        else if($type == 4){
            $start_time = strtotime(date("Y-m-d 00:00:00")) - 30*86400;
        }
        else if($type == 5){
            $start_time = strtotime(date("Y-m-d 00:00:00")) - 90*86400;
        }
        
        
        $params1['createtime'] = ['>',$start_time];
        $params2['createtime'] = ['>',$start_time];
      	
        $goods_num = Db::name("bbfx_goods")->where($params1)->count();
        $order_num = Db::name("bbfx_order")->where($params2)->count();
        
        $user_num = Db::name("bbfx_user")->where($params1)->count();
        
        $order_price = Db::name("bbfx_order")->where($params2)->sum('price');
        $refund_price = Db::name("bbfx_order")->where(['uniacid'=>UNIACID,'is_pay'=>1,'refund_status'=>1])->sum('price');
        $order_price -= $refund_price;
        $order_price = max(0,$order_price);
        $order_profit = 0;
        $express_fee = Db::name("bbfx_order")->where($params2)->sum('express_fee');
        $cost_price = Db::name("bbfx_order")->where($params2)->sum('cost_price');
        $order_list = Db::name("bbfx_order")->where($params2)->where(['refund_status'=>['in',[-1,2]]])->field("id,price,cost_price,express_fee")->select();
        if(!empty($order_list)){
            // $oids = array_column($order_list,"id");
            // $order_commission = Db::name("bbfx_fenxiao_order")->where(['uniacid'=>UNIACID,'user_id'=>['>',0],'money_type'=>['in',[1,3]],'order_id'=>['in',$oids],'status'=>['in',[1]]])->sum("money");
            
            // $order_profit = max(0,round($order_price - $cost_price - $express_fee - $order_commission,2));
            $order_commission_data = Cache::get("order_commission_data");
            if(empty($order_commission_data)) $order_commission_data = [];
            foreach ($order_list as $key => $val){
                if(!empty($order_commission_data[$val['id']])){
                    $order_commission = $order_commission_data[$val['id']];
                }
                else{
                    $order_commission = Db::name("bbfx_fenxiao_order")->where(['uniacid'=>UNIACID,'user_id'=>['>',0],'money_type'=>['in',[1,3]],'order_id'=>$val['id']])->sum("money");
                    $order_commission_data[$val['id']] = $order_commission;
                    Cache::set("order_commission_data",$order_commission_data);
                }
                $order_profit1 = $val['price'] - $val['cost_price'] - $val['cost_price'] - $order_commission;
                $order_profit += max(0,round($order_profit1,2));
            }
            
        }
        
        $today_commission = Db::name("bbfx_fenxiao_order")->where(['uniacid'=>UNIACID,'money_type'=>['in',[1,3]],'user_id'=>['>',0],'status'=>1,'createtime'=>['>',strtotime(date("Y-m-d 00:00:00"))]])->sum("money");
        $today_order_price = Db::name("bbfx_order")->where(['uniacid'=>UNIACID,'is_pay'=>1,'createtime'=>['>',strtotime(date("Y-m-d 00:00:00"))]])->sum('price');
        $today_profit = $today_order_price;
        
        $total_commission = Db::name("bbfx_fenxiao_order")->where(['uniacid'=>UNIACID,'money_type'=>['in',[1,3]],'user_id'=>['>',0],'status'=>1])->sum("money");
        $total_order_price = Db::name("bbfx_order")->where(['uniacid'=>UNIACID,'is_pay'=>1])->sum('price');
        
        
        
        
        
        $shop_profit = $total_order_price;
        if($today_profit < 0){
            $today_profit = 0;
        }
        if($shop_profit < 0){
            $shop_profit = 0;
        }
        
        $today_balance_withdrawal_count = Db::name("bbfx_withdrawal_log")->where(['uniacid'=>UNIACID,'withdrawal_type'=>1,'createtime'=>['>',strtotime(date("Y-m-d 00:00:00"))]])->count();
        $today_balance_withdrawal_money = Db::name("bbfx_withdrawal_log")->where(['uniacid'=>UNIACID,'withdrawal_type'=>1,'createtime'=>['>',strtotime(date("Y-m-d 00:00:00"))]])->sum("money");
        
        $today_commission_withdrawal_count = Db::name("bbfx_withdrawal_log")->where(['uniacid'=>UNIACID,'withdrawal_type'=>2,'createtime'=>['>',strtotime(date("Y-m-d 00:00:00"))]])->count();
        $today_commission_withdrawal_money = Db::name("bbfx_withdrawal_log")->where(['uniacid'=>UNIACID,'withdrawal_type'=>2,'createtime'=>['>',strtotime(date("Y-m-d 00:00:00"))]])->sum("money");
        
        $today_score_withdrawal_count = Db::name("bbfx_withdrawal_log")->where(['uniacid'=>UNIACID,'withdrawal_type'=>3,'createtime'=>['>',strtotime(date("Y-m-d 00:00:00"))]])->count();
        $today_score_withdrawal_money = Db::name("bbfx_withdrawal_log")->where(['uniacid'=>UNIACID,'withdrawal_type'=>3,'createtime'=>['>',strtotime(date("Y-m-d 00:00:00"))]])->sum("money");
        
        $cumulative_fanhuan_surplus = Db::name("bbfx_cumulative_fanhuan_user")->where(['uniacid'=>UNIACID])->value("surplus");
        $cumulative_fanhuan_total = Db::name("bbfx_money_log")->where(['uniacid'=>UNIACID,'item_type'=>26])->sum("money");
        
      	$pdata = array(
      	    "goods_num"=>intval($goods_num),
      	    "order_num"=>intval($order_num),
      	    "order_price"=>round($order_price,2),
      	    "user_num"=>intval($user_num),
      	    "today_profit"=>round($today_profit,2),
      	    "shop_profit"=>round($shop_profit,2),
      	    "today_balance_withdrawal_count"=>intval($today_balance_withdrawal_count),
      	    "today_balance_withdrawal_money"=>round($today_balance_withdrawal_money,2),
      	    "today_commission_withdrawal_count"=>intval($today_commission_withdrawal_count),
      	    "today_commission_withdrawal_money"=>round($today_commission_withdrawal_money,2),
      	    "today_score_withdrawal_count"=>intval($today_score_withdrawal_count),
      	    "today_score_withdrawal_money"=>round($today_score_withdrawal_money,2),
      	    "cumulative_fanhuan_surplus"=>round($cumulative_fanhuan_surplus,2),
      	    "cumulative_fanhuan_total"=>round($cumulative_fanhuan_total,2),
      	    "refund_price"=>round($refund_price,2),
      	    "order_profit"=>round($order_profit,2),
      	 );
      	 
      	 __success('操作成功',$pdata);
    }
}