/*
 Bbfxdmin Install SQL
 Date: 2025-11-28 19:08:00
*/

-- ----------------------------
-- Table structure for `fa_admin`
-- ----------------------------

DROP TABLE IF EXISTS `fa_admin`;

CREATE TABLE `fa_admin` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `username` varchar(20) DEFAULT '' COMMENT '用户名',
  `nickname` varchar(50) DEFAULT '' COMMENT '昵称',
  `password` varchar(32) DEFAULT '' COMMENT '密码',
  `salt` varchar(30) DEFAULT '' COMMENT '密码盐',
  `avatar` varchar(255) DEFAULT '' COMMENT '头像',
  `email` varchar(100) DEFAULT '' COMMENT '电子邮箱',
  `mobile` varchar(11) DEFAULT '' COMMENT '手机号码',
  `loginfailure` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '失败次数',
  `logintime` bigint(16) DEFAULT NULL COMMENT '登录时间',
  `loginip` varchar(50) DEFAULT NULL COMMENT '登录IP',
  `createtime` bigint(16) DEFAULT NULL COMMENT '创建时间',
  `updatetime` bigint(16) DEFAULT NULL COMMENT '更新时间',
  `token` varchar(59) DEFAULT '' COMMENT 'Session标识',
  `status` varchar(30) NOT NULL DEFAULT 'normal' COMMENT '状态',
  `role_id` int(10) NOT NULL DEFAULT '0',
  `uniacid` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COMMENT='管理员表';

-- ----------------------------
-- Data for the table `fa_admin`
-- ----------------------------

INSERT INTO `fa_admin` VALUES (1, 'admin', 'Admin', 'c39f4564829e3f86670b99d614293949', 'DAv2fl', '/assets/images/logo.png', 'admin@admin.com', '', 0, 1764322269, '111.85.165.82', 1491635035, 1764322269, '1374e8ec-ae22-4692-9927-b9f10fc755a1', 'normal', 0, 0);

-- ----------------------------
-- Table structure for `fa_admin_log`
-- ----------------------------

DROP TABLE IF EXISTS `fa_admin_log`;

CREATE TABLE `fa_admin_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '1' COMMENT '平台ID',
  `admin_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '管理员ID',
  `username` varchar(30) DEFAULT '' COMMENT '管理员名字',
  `url` varchar(1500) DEFAULT '' COMMENT '操作页面',
  `title` varchar(100) DEFAULT '' COMMENT '日志标题',
  `content` longtext NOT NULL COMMENT '内容',
  `ip` varchar(50) DEFAULT '' COMMENT 'IP',
  `useragent` varchar(255) DEFAULT '' COMMENT 'User-Agent',
  `info` longtext COMMENT '操作相关json数据',
  `createtime` bigint(16) DEFAULT NULL COMMENT '操作时间',
  PRIMARY KEY (`id`),
  KEY `name` (`username`)
) ENGINE=InnoDB AUTO_INCREMENT=3153 DEFAULT CHARSET=utf8mb4 COMMENT='管理员日志表';

-- ----------------------------
-- Table structure for `fa_area`
-- ----------------------------

DROP TABLE IF EXISTS `fa_area`;

CREATE TABLE `fa_area` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `pid` int(10) DEFAULT NULL COMMENT '父id',
  `shortname` varchar(100) DEFAULT NULL COMMENT '简称',
  `name` varchar(100) DEFAULT NULL COMMENT '名称',
  `mergename` varchar(255) DEFAULT NULL COMMENT '全称',
  `level` tinyint(4) DEFAULT NULL COMMENT '层级:1=省,2=市,3=区/县',
  `pinyin` varchar(100) DEFAULT NULL COMMENT '拼音',
  `code` varchar(100) DEFAULT NULL COMMENT '长途区号',
  `zip` varchar(100) DEFAULT NULL COMMENT '邮编',
  `first` varchar(50) DEFAULT NULL COMMENT '首字母',
  `lng` varchar(100) DEFAULT NULL COMMENT '经度',
  `lat` varchar(100) DEFAULT NULL COMMENT '纬度',
  PRIMARY KEY (`id`),
  KEY `pid` (`pid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='地区表';

-- ----------------------------
-- Table structure for `fa_attachment`
-- ----------------------------

DROP TABLE IF EXISTS `fa_attachment`;

CREATE TABLE `fa_attachment` (
  `id` int(20) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `category` varchar(50) DEFAULT '' COMMENT '类别',
  `category_id` int(10) NOT NULL DEFAULT '0',
  `admin_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '管理员ID',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `uniacid` int(10) NOT NULL DEFAULT '0',
  `url` varchar(255) DEFAULT '' COMMENT '物理路径',
  `imagewidth` varchar(30) DEFAULT '' COMMENT '宽度',
  `imageheight` varchar(30) DEFAULT '' COMMENT '高度',
  `imagetype` varchar(30) DEFAULT '' COMMENT '图片类型',
  `imageframes` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '图片帧数',
  `filename` varchar(100) DEFAULT '' COMMENT '文件名称',
  `filesize` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '文件大小',
  `mimetype` varchar(100) DEFAULT '' COMMENT 'mime类型',
  `extparam` varchar(255) DEFAULT '' COMMENT '透传数据',
  `createtime` bigint(16) DEFAULT NULL COMMENT '创建日期',
  `updatetime` bigint(16) DEFAULT NULL COMMENT '更新时间',
  `uploadtime` bigint(16) DEFAULT NULL COMMENT '上传时间',
  `storage` varchar(100) NOT NULL DEFAULT 'local' COMMENT '存储位置',
  `sha1` varchar(40) DEFAULT '' COMMENT '文件 sha1编码',
  `is_user` int(10) NOT NULL DEFAULT '0',
  `oss_domain` varchar(255) NOT NULL DEFAULT '' COMMENT 'OSS域名	',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1004 DEFAULT CHARSET=utf8mb4 COMMENT='附件表';

-- ----------------------------
-- Table structure for `fa_auth_group`
-- ----------------------------

DROP TABLE IF EXISTS `fa_auth_group`;

CREATE TABLE `fa_auth_group` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '父组别',
  `name` varchar(100) DEFAULT '' COMMENT '组名',
  `rules` text NOT NULL COMMENT '规则ID',
  `createtime` bigint(16) DEFAULT NULL COMMENT '创建时间',
  `updatetime` bigint(16) DEFAULT NULL COMMENT '更新时间',
  `status` varchar(30) DEFAULT '' COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COMMENT='分组表';

-- ----------------------------
-- Data for the table `fa_auth_group`
-- ----------------------------

INSERT INTO `fa_auth_group` VALUES (1, 0, 'Admin group', '*', 1491635035, 1491635035, 'normal');
INSERT INTO `fa_auth_group` VALUES (2, 1, '二级管理组', '13,18,23,24,28,29,30,32,34,40,44,45,47,55,93,94,95,96,97,1,6,2,7,8,9,5,10,11,4', 1491635035, 1697441880, 'normal');

-- ----------------------------
-- Table structure for `fa_auth_group_access`
-- ----------------------------

DROP TABLE IF EXISTS `fa_auth_group_access`;

CREATE TABLE `fa_auth_group_access` (
  `uid` int(10) unsigned NOT NULL COMMENT '会员ID',
  `group_id` int(10) unsigned NOT NULL COMMENT '级别ID',
  UNIQUE KEY `uid_group_id` (`uid`,`group_id`),
  KEY `uid` (`uid`),
  KEY `group_id` (`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='权限分组表';

-- ----------------------------
-- Data for the table `fa_auth_group_access`
-- ----------------------------

INSERT INTO `fa_auth_group_access` VALUES (1, 1);
INSERT INTO `fa_auth_group_access` VALUES (2, 2);

-- ----------------------------
-- Table structure for `fa_auth_rule`
-- ----------------------------

DROP TABLE IF EXISTS `fa_auth_rule`;

CREATE TABLE `fa_auth_rule` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` enum('menu','file') NOT NULL DEFAULT 'file' COMMENT 'menu为菜单,file为权限节点',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '父ID',
  `name` varchar(100) DEFAULT '' COMMENT '规则名称',
  `title` varchar(50) DEFAULT '' COMMENT '规则名称',
  `icon` varchar(50) DEFAULT '' COMMENT '图标',
  `url` varchar(255) DEFAULT '' COMMENT '规则URL',
  `condition` varchar(255) DEFAULT '' COMMENT '条件',
  `remark` varchar(255) DEFAULT '' COMMENT '备注',
  `ismenu` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否为菜单',
  `menutype` enum('addtabs','blank','dialog','ajax') DEFAULT NULL COMMENT '菜单类型',
  `extend` varchar(255) DEFAULT '' COMMENT '扩展属性',
  `py` varchar(30) DEFAULT '' COMMENT '拼音首字母',
  `pinyin` varchar(100) DEFAULT '' COMMENT '拼音',
  `createtime` bigint(16) DEFAULT NULL COMMENT '创建时间',
  `updatetime` bigint(16) DEFAULT NULL COMMENT '更新时间',
  `weigh` int(10) NOT NULL DEFAULT '0' COMMENT '权重',
  `status` varchar(30) DEFAULT '' COMMENT '状态',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`) USING BTREE,
  KEY `pid` (`pid`),
  KEY `weigh` (`weigh`)
) ENGINE=InnoDB AUTO_INCREMENT=98 DEFAULT CHARSET=utf8mb4 COMMENT='节点表';

-- ----------------------------
-- Data for the table `fa_auth_rule`
-- ----------------------------

INSERT INTO `fa_auth_rule` VALUES (1, 'file', 0, 'dashboard', 'Dashboard', 'fa fa-dashboard', '', '', 'Dashboard tips', 0, NULL, '', 'kzt', 'kongzhitai', 1491635035, 1703078987, 143, 'normal');
INSERT INTO `fa_auth_rule` VALUES (2, 'file', 0, 'general', 'General', 'fa fa-cogs', '', '', '', 1, NULL, '', 'cggl', 'changguiguanli', 1491635035, 1701701610, 137, 'hidden');
INSERT INTO `fa_auth_rule` VALUES (3, 'file', 0, 'category', 'Category', 'fa fa-leaf', '', '', 'Category tips', 0, NULL, '', 'flgl', 'fenleiguanli', 1491635035, 1700235141, 119, 'normal');
INSERT INTO `fa_auth_rule` VALUES (4, 'file', 0, 'addon', 'Addon', 'fa fa-rocket', '', '', 'Addon tips', 0, NULL, '', 'cjgl', 'chajianguanli', 1491635035, 1699243223, 0, 'normal');
INSERT INTO `fa_auth_rule` VALUES (5, 'file', 0, 'auth', 'Auth', 'fa fa-group', '', '', '', 0, NULL, '', 'qxgl', 'quanxianguanli', 1491635035, 1699243222, 99, 'normal');
INSERT INTO `fa_auth_rule` VALUES (6, 'file', 2, 'general/config', 'Config', 'fa fa-cog', '', '', 'Config tips', 1, NULL, '', 'xtpz', 'xitongpeizhi', 1491635035, 1491635035, 60, 'normal');
INSERT INTO `fa_auth_rule` VALUES (7, 'file', 2, 'general/attachment', 'Attachment', 'fa fa-file-image-o', '', '', 'Attachment tips', 0, NULL, '', 'fjgl', 'fujianguanli', 1491635035, 1703251765, 53, 'normal');
INSERT INTO `fa_auth_rule` VALUES (8, 'file', 2, 'general/profile', '账号信息', 'fa fa-user', '', '', '', 1, 'addtabs', '', 'grzl1', 'gerenziliao1', 1491635035, 1703078806, 34, 'normal');
INSERT INTO `fa_auth_rule` VALUES (9, 'file', 5, 'auth/admin', 'Admin', 'fa fa-user', '', '', 'Admin tips', 1, NULL, '', 'glygl', 'guanliyuanguanli', 1491635035, 1491635035, 118, 'normal');
INSERT INTO `fa_auth_rule` VALUES (10, 'file', 5, 'auth/adminlog', 'Admin log', 'fa fa-list-alt', '', '', 'Admin log tips', 1, NULL, '', 'glyrz', 'guanliyuanrizhi', 1491635035, 1491635035, 113, 'normal');
INSERT INTO `fa_auth_rule` VALUES (11, 'file', 5, 'auth/group', 'Group', 'fa fa-group', '', '', 'Group tips', 1, NULL, '', 'jsz', 'juesezu', 1491635035, 1491635035, 109, 'normal');
INSERT INTO `fa_auth_rule` VALUES (12, 'file', 5, 'auth/rule', 'Rule', 'fa fa-bars', '', '', 'Rule tips', 1, NULL, '', 'cdgz', 'caidanguize', 1491635035, 1491635035, 104, 'normal');
INSERT INTO `fa_auth_rule` VALUES (13, 'file', 1, 'dashboard/index', 'View', 'fa fa-circle-o', '', '', '', 0, NULL, '', '', '', 1491635035, 1491635035, 136, 'normal');
INSERT INTO `fa_auth_rule` VALUES (14, 'file', 1, 'dashboard/add', 'Add', 'fa fa-circle-o', '', '', '', 0, NULL, '', '', '', 1491635035, 1491635035, 135, 'normal');
INSERT INTO `fa_auth_rule` VALUES (15, 'file', 1, 'dashboard/del', 'Delete', 'fa fa-circle-o', '', '', '', 0, NULL, '', '', '', 1491635035, 1491635035, 133, 'normal');
INSERT INTO `fa_auth_rule` VALUES (16, 'file', 1, 'dashboard/edit', 'Edit', 'fa fa-circle-o', '', '', '', 0, NULL, '', '', '', 1491635035, 1491635035, 134, 'normal');
INSERT INTO `fa_auth_rule` VALUES (17, 'file', 1, 'dashboard/multi', 'Multi', 'fa fa-circle-o', '', '', '', 0, NULL, '', '', '', 1491635035, 1491635035, 132, 'normal');
INSERT INTO `fa_auth_rule` VALUES (18, 'file', 6, 'general/config/index', 'View', 'fa fa-circle-o', '', '', '', 0, NULL, '', '', '', 1491635035, 1491635035, 52, 'normal');
INSERT INTO `fa_auth_rule` VALUES (19, 'file', 6, 'general/config/add', 'Add', 'fa fa-circle-o', '', '', '', 0, NULL, '', '', '', 1491635035, 1491635035, 51, 'normal');
INSERT INTO `fa_auth_rule` VALUES (20, 'file', 6, 'general/config/edit', 'Edit', 'fa fa-circle-o', '', '', '', 0, NULL, '', '', '', 1491635035, 1491635035, 50, 'normal');
INSERT INTO `fa_auth_rule` VALUES (21, 'file', 6, 'general/config/del', 'Delete', 'fa fa-circle-o', '', '', '', 0, NULL, '', '', '', 1491635035, 1491635035, 49, 'normal');
INSERT INTO `fa_auth_rule` VALUES (22, 'file', 6, 'general/config/multi', 'Multi', 'fa fa-circle-o', '', '', '', 0, NULL, '', '', '', 1491635035, 1491635035, 48, 'normal');
INSERT INTO `fa_auth_rule` VALUES (23, 'file', 7, 'general/attachment/index', 'View', 'fa fa-circle-o', '', '', 'Attachment tips', 0, NULL, '', '', '', 1491635035, 1491635035, 59, 'normal');
INSERT INTO `fa_auth_rule` VALUES (24, 'file', 7, 'general/attachment/select', 'Select attachment', 'fa fa-circle-o', '', '', '', 0, NULL, '', '', '', 1491635035, 1491635035, 58, 'normal');
INSERT INTO `fa_auth_rule` VALUES (25, 'file', 7, 'general/attachment/add', 'Add', 'fa fa-circle-o', '', '', '', 0, NULL, '', '', '', 1491635035, 1491635035, 57, 'normal');
INSERT INTO `fa_auth_rule` VALUES (26, 'file', 7, 'general/attachment/edit', 'Edit', 'fa fa-circle-o', '', '', '', 0, NULL, '', '', '', 1491635035, 1491635035, 56, 'normal');
INSERT INTO `fa_auth_rule` VALUES (27, 'file', 7, 'general/attachment/del', 'Delete', 'fa fa-circle-o', '', '', '', 0, NULL, '', '', '', 1491635035, 1491635035, 55, 'normal');
INSERT INTO `fa_auth_rule` VALUES (28, 'file', 7, 'general/attachment/multi', 'Multi', 'fa fa-circle-o', '', '', '', 0, NULL, '', '', '', 1491635035, 1491635035, 54, 'normal');
INSERT INTO `fa_auth_rule` VALUES (29, 'file', 8, 'general/profile/index', 'View', 'fa fa-circle-o', '', '', '', 0, NULL, '', '', '', 1491635035, 1491635035, 33, 'normal');
INSERT INTO `fa_auth_rule` VALUES (30, 'file', 8, 'general/profile/update', 'Update profile', 'fa fa-circle-o', '', '', '', 0, NULL, '', '', '', 1491635035, 1491635035, 32, 'normal');
INSERT INTO `fa_auth_rule` VALUES (31, 'file', 8, 'general/profile/add', 'Add', 'fa fa-circle-o', '', '', '', 0, NULL, '', '', '', 1491635035, 1491635035, 31, 'normal');
INSERT INTO `fa_auth_rule` VALUES (32, 'file', 8, 'general/profile/edit', 'Edit', 'fa fa-circle-o', '', '', '', 0, NULL, '', '', '', 1491635035, 1491635035, 30, 'normal');
INSERT INTO `fa_auth_rule` VALUES (33, 'file', 8, 'general/profile/del', 'Delete', 'fa fa-circle-o', '', '', '', 0, NULL, '', '', '', 1491635035, 1491635035, 29, 'normal');
INSERT INTO `fa_auth_rule` VALUES (34, 'file', 8, 'general/profile/multi', 'Multi', 'fa fa-circle-o', '', '', '', 0, NULL, '', '', '', 1491635035, 1491635035, 28, 'normal');
INSERT INTO `fa_auth_rule` VALUES (35, 'file', 3, 'category/index', 'View', 'fa fa-circle-o', '', '', 'Category tips', 0, NULL, '', '', '', 1491635035, 1491635035, 142, 'normal');
INSERT INTO `fa_auth_rule` VALUES (36, 'file', 3, 'category/add', 'Add', 'fa fa-circle-o', '', '', '', 0, NULL, '', '', '', 1491635035, 1491635035, 141, 'normal');
INSERT INTO `fa_auth_rule` VALUES (37, 'file', 3, 'category/edit', 'Edit', 'fa fa-circle-o', '', '', '', 0, NULL, '', '', '', 1491635035, 1491635035, 140, 'normal');
INSERT INTO `fa_auth_rule` VALUES (38, 'file', 3, 'category/del', 'Delete', 'fa fa-circle-o', '', '', '', 0, NULL, '', '', '', 1491635035, 1491635035, 139, 'normal');
INSERT INTO `fa_auth_rule` VALUES (39, 'file', 3, 'category/multi', 'Multi', 'fa fa-circle-o', '', '', '', 0, NULL, '', '', '', 1491635035, 1491635035, 138, 'normal');
INSERT INTO `fa_auth_rule` VALUES (40, 'file', 9, 'auth/admin/index', 'View', 'fa fa-circle-o', '', '', 'Admin tips', 0, NULL, '', '', '', 1491635035, 1491635035, 117, 'normal');
INSERT INTO `fa_auth_rule` VALUES (41, 'file', 9, 'auth/admin/add', 'Add', 'fa fa-circle-o', '', '', '', 0, NULL, '', '', '', 1491635035, 1491635035, 116, 'normal');
INSERT INTO `fa_auth_rule` VALUES (42, 'file', 9, 'auth/admin/edit', 'Edit', 'fa fa-circle-o', '', '', '', 0, NULL, '', '', '', 1491635035, 1491635035, 115, 'normal');
INSERT INTO `fa_auth_rule` VALUES (43, 'file', 9, 'auth/admin/del', 'Delete', 'fa fa-circle-o', '', '', '', 0, NULL, '', '', '', 1491635035, 1491635035, 114, 'normal');
INSERT INTO `fa_auth_rule` VALUES (44, 'file', 10, 'auth/adminlog/index', 'View', 'fa fa-circle-o', '', '', 'Admin log tips', 0, NULL, '', '', '', 1491635035, 1491635035, 112, 'normal');
INSERT INTO `fa_auth_rule` VALUES (45, 'file', 10, 'auth/adminlog/detail', 'Detail', 'fa fa-circle-o', '', '', '', 0, NULL, '', '', '', 1491635035, 1491635035, 111, 'normal');
INSERT INTO `fa_auth_rule` VALUES (46, 'file', 10, 'auth/adminlog/del', 'Delete', 'fa fa-circle-o', '', '', '', 0, NULL, '', '', '', 1491635035, 1491635035, 110, 'normal');
INSERT INTO `fa_auth_rule` VALUES (47, 'file', 11, 'auth/group/index', 'View', 'fa fa-circle-o', '', '', 'Group tips', 0, NULL, '', '', '', 1491635035, 1491635035, 108, 'normal');
INSERT INTO `fa_auth_rule` VALUES (48, 'file', 11, 'auth/group/add', 'Add', 'fa fa-circle-o', '', '', '', 0, NULL, '', '', '', 1491635035, 1491635035, 107, 'normal');
INSERT INTO `fa_auth_rule` VALUES (49, 'file', 11, 'auth/group/edit', 'Edit', 'fa fa-circle-o', '', '', '', 0, NULL, '', '', '', 1491635035, 1491635035, 106, 'normal');
INSERT INTO `fa_auth_rule` VALUES (50, 'file', 11, 'auth/group/del', 'Delete', 'fa fa-circle-o', '', '', '', 0, NULL, '', '', '', 1491635035, 1491635035, 105, 'normal');
INSERT INTO `fa_auth_rule` VALUES (51, 'file', 12, 'auth/rule/index', 'View', 'fa fa-circle-o', '', '', 'Rule tips', 0, NULL, '', '', '', 1491635035, 1491635035, 103, 'normal');
INSERT INTO `fa_auth_rule` VALUES (52, 'file', 12, 'auth/rule/add', 'Add', 'fa fa-circle-o', '', '', '', 0, NULL, '', '', '', 1491635035, 1491635035, 102, 'normal');
INSERT INTO `fa_auth_rule` VALUES (53, 'file', 12, 'auth/rule/edit', 'Edit', 'fa fa-circle-o', '', '', '', 0, NULL, '', '', '', 1491635035, 1491635035, 101, 'normal');
INSERT INTO `fa_auth_rule` VALUES (54, 'file', 12, 'auth/rule/del', 'Delete', 'fa fa-circle-o', '', '', '', 0, NULL, '', '', '', 1491635035, 1491635035, 100, 'normal');
INSERT INTO `fa_auth_rule` VALUES (55, 'file', 4, 'addon/index', 'View', 'fa fa-circle-o', '', '', 'Addon tips', 0, NULL, '', '', '', 1491635035, 1491635035, 0, 'normal');
INSERT INTO `fa_auth_rule` VALUES (56, 'file', 4, 'addon/add', 'Add', 'fa fa-circle-o', '', '', '', 0, NULL, '', '', '', 1491635035, 1491635035, 0, 'normal');
INSERT INTO `fa_auth_rule` VALUES (57, 'file', 4, 'addon/edit', 'Edit', 'fa fa-circle-o', '', '', '', 0, NULL, '', '', '', 1491635035, 1491635035, 0, 'normal');
INSERT INTO `fa_auth_rule` VALUES (58, 'file', 4, 'addon/del', 'Delete', 'fa fa-circle-o', '', '', '', 0, NULL, '', '', '', 1491635035, 1491635035, 0, 'normal');
INSERT INTO `fa_auth_rule` VALUES (59, 'file', 4, 'addon/downloaded', 'Local addon', 'fa fa-circle-o', '', '', '', 0, NULL, '', '', '', 1491635035, 1491635035, 0, 'normal');
INSERT INTO `fa_auth_rule` VALUES (60, 'file', 4, 'addon/state', 'Update state', 'fa fa-circle-o', '', '', '', 0, NULL, '', '', '', 1491635035, 1491635035, 0, 'normal');
INSERT INTO `fa_auth_rule` VALUES (63, 'file', 4, 'addon/config', 'Setting', 'fa fa-circle-o', '', '', '', 0, NULL, '', '', '', 1491635035, 1491635035, 0, 'normal');
INSERT INTO `fa_auth_rule` VALUES (64, 'file', 4, 'addon/refresh', 'Refresh', 'fa fa-circle-o', '', '', '', 0, NULL, '', '', '', 1491635035, 1491635035, 0, 'normal');
INSERT INTO `fa_auth_rule` VALUES (65, 'file', 4, 'addon/multi', 'Multi', 'fa fa-circle-o', '', '', '', 0, NULL, '', '', '', 1491635035, 1491635035, 0, 'normal');
INSERT INTO `fa_auth_rule` VALUES (66, 'file', 0, 'user', 'User', 'fa fa-user-circle', '', '', '', 0, NULL, '', 'hygl', 'huiyuanguanli', 1491635035, 1699243225, 0, 'normal');
INSERT INTO `fa_auth_rule` VALUES (67, 'file', 66, 'user/user', 'User', 'fa fa-user', '', '', '', 1, NULL, '', 'hygl', 'huiyuanguanli', 1491635035, 1491635035, 0, 'normal');
INSERT INTO `fa_auth_rule` VALUES (68, 'file', 67, 'user/user/index', 'View', 'fa fa-circle-o', '', '', '', 0, NULL, '', '', '', 1491635035, 1491635035, 0, 'normal');
INSERT INTO `fa_auth_rule` VALUES (69, 'file', 67, 'user/user/edit', 'Edit', 'fa fa-circle-o', '', '', '', 0, NULL, '', '', '', 1491635035, 1491635035, 0, 'normal');
INSERT INTO `fa_auth_rule` VALUES (70, 'file', 67, 'user/user/add', 'Add', 'fa fa-circle-o', '', '', '', 0, NULL, '', '', '', 1491635035, 1491635035, 0, 'normal');
INSERT INTO `fa_auth_rule` VALUES (71, 'file', 67, 'user/user/del', 'Del', 'fa fa-circle-o', '', '', '', 0, NULL, '', '', '', 1491635035, 1491635035, 0, 'normal');
INSERT INTO `fa_auth_rule` VALUES (72, 'file', 67, 'user/user/multi', 'Multi', 'fa fa-circle-o', '', '', '', 0, NULL, '', '', '', 1491635035, 1491635035, 0, 'normal');
INSERT INTO `fa_auth_rule` VALUES (73, 'file', 66, 'user/group', 'User group', 'fa fa-users', '', '', '', 1, NULL, '', 'hyfz', 'huiyuanfenzu', 1491635035, 1491635035, 0, 'normal');
INSERT INTO `fa_auth_rule` VALUES (74, 'file', 73, 'user/group/add', 'Add', 'fa fa-circle-o', '', '', '', 0, NULL, '', '', '', 1491635035, 1491635035, 0, 'normal');
INSERT INTO `fa_auth_rule` VALUES (75, 'file', 73, 'user/group/edit', 'Edit', 'fa fa-circle-o', '', '', '', 0, NULL, '', '', '', 1491635035, 1491635035, 0, 'normal');
INSERT INTO `fa_auth_rule` VALUES (76, 'file', 73, 'user/group/index', 'View', 'fa fa-circle-o', '', '', '', 0, NULL, '', '', '', 1491635035, 1491635035, 0, 'normal');
INSERT INTO `fa_auth_rule` VALUES (77, 'file', 73, 'user/group/del', 'Del', 'fa fa-circle-o', '', '', '', 0, NULL, '', '', '', 1491635035, 1491635035, 0, 'normal');
INSERT INTO `fa_auth_rule` VALUES (78, 'file', 73, 'user/group/multi', 'Multi', 'fa fa-circle-o', '', '', '', 0, NULL, '', '', '', 1491635035, 1491635035, 0, 'normal');
INSERT INTO `fa_auth_rule` VALUES (79, 'file', 66, 'user/rule', 'User rule', 'fa fa-circle-o', '', '', '', 1, NULL, '', 'hygz', 'huiyuanguize', 1491635035, 1491635035, 0, 'normal');
INSERT INTO `fa_auth_rule` VALUES (80, 'file', 79, 'user/rule/index', 'View', 'fa fa-circle-o', '', '', '', 0, NULL, '', '', '', 1491635035, 1491635035, 0, 'normal');
INSERT INTO `fa_auth_rule` VALUES (81, 'file', 79, 'user/rule/del', 'Del', 'fa fa-circle-o', '', '', '', 0, NULL, '', '', '', 1491635035, 1491635035, 0, 'normal');
INSERT INTO `fa_auth_rule` VALUES (82, 'file', 79, 'user/rule/add', 'Add', 'fa fa-circle-o', '', '', '', 0, NULL, '', '', '', 1491635035, 1491635035, 0, 'normal');
INSERT INTO `fa_auth_rule` VALUES (83, 'file', 79, 'user/rule/edit', 'Edit', 'fa fa-circle-o', '', '', '', 0, NULL, '', '', '', 1491635035, 1491635035, 0, 'normal');
INSERT INTO `fa_auth_rule` VALUES (84, 'file', 79, 'user/rule/multi', 'Multi', 'fa fa-circle-o', '', '', '', 0, NULL, '', '', '', 1491635035, 1491635035, 0, 'normal');
INSERT INTO `fa_auth_rule` VALUES (85, 'file', 0, 'command', '在线命令管理', 'fa fa-terminal', '', '', '', 0, NULL, '', 'zxmlgl', 'zaixianminglingguanli', 1695454875, 1699243225, 0, 'normal');
INSERT INTO `fa_auth_rule` VALUES (86, 'file', 85, 'command/index', '查看', 'fa fa-circle-o', '', '', '', 0, NULL, '', 'zk', 'zhakan', 1695454875, 1695454875, 0, 'normal');
INSERT INTO `fa_auth_rule` VALUES (87, 'file', 85, 'command/add', '添加', 'fa fa-circle-o', '', '', '', 0, NULL, '', 'tj', 'tianjia', 1695454875, 1695454875, 0, 'normal');
INSERT INTO `fa_auth_rule` VALUES (88, 'file', 85, 'command/detail', '详情', 'fa fa-circle-o', '', '', '', 0, NULL, '', 'xq', 'xiangqing', 1695454875, 1695454875, 0, 'normal');
INSERT INTO `fa_auth_rule` VALUES (89, 'file', 85, 'command/command', '生成并执行命令', 'fa fa-circle-o', '', '', '', 0, NULL, '', 'scbzxml', 'shengchengbingzhixingmingling', 1695454875, 1695454875, 0, 'normal');
INSERT INTO `fa_auth_rule` VALUES (90, 'file', 85, 'command/execute', '再次执行命令', 'fa fa-circle-o', '', '', '', 0, NULL, '', 'zczxml', 'zaicizhixingmingling', 1695454875, 1695454875, 0, 'normal');
INSERT INTO `fa_auth_rule` VALUES (91, 'file', 85, 'command/del', '删除', 'fa fa-circle-o', '', '', '', 0, NULL, '', 'sc', 'shanchu', 1695454875, 1695454875, 0, 'normal');
INSERT INTO `fa_auth_rule` VALUES (92, 'file', 85, 'command/multi', '批量更新', 'fa fa-circle-o', '', '', '', 0, NULL, '', 'plgx', 'pilianggengxin', 1695454875, 1695454875, 0, 'normal');
INSERT INTO `fa_auth_rule` VALUES (93, 'file', 0, 'platform', '平台管理', 'fa fa-cubes', '', '', '', 1, 'addtabs', '', 'ptgl', 'pingtaiguanli', 1695455134, 1697441650, 0, 'normal');
INSERT INTO `fa_auth_rule` VALUES (94, 'file', 93, 'platform/index', '查看', 'fa fa-circle-o', '', '', '', 0, 'addtabs', '', 'zk', 'zhakan', 1697441676, 1697441676, 0, 'normal');
INSERT INTO `fa_auth_rule` VALUES (95, 'file', 93, 'platform/edit', '修改', 'fa fa-circle-o', '', '', '', 0, 'addtabs', '', 'xg', 'xiugai', 1697441704, 1697441704, 0, 'normal');
INSERT INTO `fa_auth_rule` VALUES (96, 'file', 93, 'platform/add', '添加', 'fa fa-circle-o', '', '', '', 0, 'addtabs', '', 'tj', 'tianjia', 1697441723, 1697441723, 0, 'normal');
INSERT INTO `fa_auth_rule` VALUES (97, 'file', 93, 'platform/del', '删除', 'fa fa-circle-o', '', '', '', 0, 'addtabs', '', 'sc', 'shanchu', 1697441749, 1697441749, 0, 'normal');

-- ----------------------------
-- Table structure for `fa_bbfx`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx`;

CREATE TABLE `fa_bbfx` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `version_name` varchar(100) NOT NULL,
  `version` int(10) NOT NULL,
  `sversion` int(10) NOT NULL DEFAULT '0',
  `sversion_name` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Data for the table `fa_bbfx`
-- ----------------------------

INSERT INTO `fa_bbfx` VALUES (1, '2.2.2511211', 222511211, 222511201, '2.2.2511201');

-- ----------------------------
-- Table structure for `fa_bbfx_activity`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_activity`;

CREATE TABLE `fa_bbfx_activity` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=开启,0=关闭',
  `is_shenhe` int(10) NOT NULL DEFAULT '0' COMMENT '活动审核:1=开启,0=关闭',
  `edit_shenhe` int(10) NOT NULL DEFAULT '0' COMMENT '活动编辑审核:1=开启,0=关闭',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_activity_baoming`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_activity_baoming`;

CREATE TABLE `fa_bbfx_activity_baoming` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `activity_id` int(10) NOT NULL DEFAULT '0' COMMENT '活动ID',
  `order_no` varchar(100) DEFAULT NULL COMMENT '订单号',
  `balance` decimal(12,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '抵扣余额',
  `baoming_fee` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '报名费',
  `realname` varchar(100) DEFAULT NULL COMMENT '姓名',
  `mobile` varchar(100) DEFAULT NULL COMMENT '电话',
  `sex` int(10) NOT NULL DEFAULT '1' COMMENT '性别:1=男,2=女',
  `jiesuan_status` int(10) NOT NULL DEFAULT '0' COMMENT '结算状态:0=待结算,1=已结算',
  `jiesuan_time` bigint(16) NOT NULL DEFAULT '0' COMMENT '结算时间',
  `hexiao_status` int(10) NOT NULL DEFAULT '0' COMMENT '核销状态:0=待核销,1=已核销',
  `hexiao_code` varchar(100) DEFAULT NULL COMMENT '核销码',
  `hexiao_time` bigint(16) NOT NULL DEFAULT '0' COMMENT '核销时间',
  `is_pay` int(10) NOT NULL DEFAULT '0' COMMENT '报名支付:1=已支付,0=未支付',
  `paytype` int(10) NOT NULL DEFAULT '0' COMMENT '支付类型',
  `paytime` bigint(16) NOT NULL DEFAULT '0' COMMENT '支付时间',
  `info` text COMMENT '数据',
  `createtime` bigint(16) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_activity_list`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_activity_list`;

CREATE TABLE `fa_bbfx_activity_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `pid` int(10) NOT NULL DEFAULT '0' COMMENT '关联ID',
  `title` varchar(100) DEFAULT NULL COMMENT '活动标题',
  `image` varchar(255) DEFAULT NULL COMMENT '活动图片',
  `type` int(10) NOT NULL DEFAULT '1' COMMENT '活动类型:1=线下活动,2=线上活动',
  `baoming_fee` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '报名费',
  `poster_image` varchar(255) DEFAULT NULL COMMENT '海报图片',
  `slide_images` text COMMENT '轮播图',
  `slide_videos` text COMMENT '轮播视频',
  `advert_image` varchar(255) DEFAULT NULL COMMENT '广告图',
  `starttime` bigint(16) NOT NULL DEFAULT '0' COMMENT '开始时间',
  `endtime` bigint(16) NOT NULL DEFAULT '0' COMMENT '结束时间',
  `bm_stime` bigint(16) NOT NULL DEFAULT '0' COMMENT '报名开始时间',
  `bm_etime` bigint(16) NOT NULL DEFAULT '0' COMMENT '报名结束时间',
  `baoming_total` int(10) NOT NULL DEFAULT '0' COMMENT '报名人数',
  `virtual_baoming` int(10) NOT NULL DEFAULT '0' COMMENT '虚拟报名人数',
  `detail_images` text COMMENT '详情图片',
  `mobile` varchar(100) DEFAULT NULL COMMENT '联系电话',
  `music` varchar(255) DEFAULT NULL COMMENT '音乐',
  `is_public` int(10) NOT NULL DEFAULT '1' COMMENT '公开活动:1=是,0=否',
  `is_hexiao` int(10) NOT NULL DEFAULT '0' COMMENT '活动核销:1=开启,0=关闭',
  `baoming_user_scroll` int(10) NOT NULL DEFAULT '0' COMMENT '报名用户滚动:1=开启,0=关闭',
  `address` varchar(255) DEFAULT NULL COMMENT '活动地址',
  `detail_address` varchar(255) DEFAULT NULL COMMENT '详细地址',
  `lat` double NOT NULL DEFAULT '0' COMMENT '纬度',
  `lng` double NOT NULL DEFAULT '0' COMMENT '经度',
  `status` int(10) NOT NULL DEFAULT '1' COMMENT '状态:1=启用,0=禁用',
  `sh_status` int(10) NOT NULL DEFAULT '1' COMMENT '审核状态:0=待审核,1=通过,2=驳回',
  `sh_time` bigint(16) NOT NULL DEFAULT '0' COMMENT '审核时间',
  `browse` int(10) NOT NULL DEFAULT '0' COMMENT '浏览人数',
  `updatetime` bigint(16) NOT NULL DEFAULT '0' COMMENT '更新时间',
  `createtime` bigint(16) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_agent`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_agent`;

CREATE TABLE `fa_bbfx_agent` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(11) NOT NULL DEFAULT '0',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=开启,0=关闭',
  `level` int(10) NOT NULL DEFAULT '0' COMMENT '代理级别:1=省级,2=市级,3=区级,4=街道',
  `become_agent` int(10) NOT NULL DEFAULT '1' COMMENT '成为代理商条件:1=购买商品,2=消费金额,3=单笔消费,4=申请',
  `become_purchase_money` text COMMENT '代理商条件消费金额',
  `become_goods` text COMMENT '代理商条件购买商品',
  `commission_received_type` int(10) NOT NULL DEFAULT '1' COMMENT '到账时间:1=订单付款后,2=订单完成后',
  `become_order_type` int(10) NOT NULL DEFAULT '1' COMMENT '消费条件统计的方式:1=订单付款后,2=订单完成后',
  `settlement_type` int(10) NOT NULL DEFAULT '1' COMMENT '收益结算:1=结算到佣金,2=结算到余额',
  `agent_rule` int(10) NOT NULL DEFAULT '0' COMMENT '详细规则:1=开启,0=关闭',
  `agent_reward` text COMMENT '佣金配置',
  `is_show_yx` int(10) NOT NULL DEFAULT '0' COMMENT '代理协议:0=隐藏1=显示,',
  `xy_title` varchar(100) DEFAULT NULL COMMENT '代理协议名称',
  `xy_content` text COMMENT '代理协议内容',
  `address_type` int(10) NOT NULL DEFAULT '0' COMMENT '地址类型:0=订单收货地址,1=用户所属区域',
  `is_jicha` int(10) NOT NULL DEFAULT '0' COMMENT '代理级差:1=开启,0=关闭',
  `is_deputy_city_agent` int(10) NOT NULL DEFAULT '0' COMMENT '副市级代理:1=开启,0=关闭',
  `achievement_subsidy` text COMMENT '业绩补贴',
  `commission_calculation_mode` int(10) NOT NULL DEFAULT '0' COMMENT '佣金计算模式:0=按商品计算,1=按订单计算',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_bbfx_agent_log`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_agent_log`;

CREATE TABLE `fa_bbfx_agent_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `province` varchar(100) DEFAULT NULL COMMENT '省份',
  `city` varchar(100) DEFAULT NULL COMMENT '城区',
  `area` varchar(100) DEFAULT NULL COMMENT '区县',
  `street` varchar(100) DEFAULT NULL COMMENT '街道',
  `level` int(10) NOT NULL DEFAULT '0' COMMENT '代理级别:1=省级,2=市级,3=区级,4=街道',
  `is_deputy_city_agent` int(10) NOT NULL DEFAULT '0' COMMENT '副市级代理:1=是,0=否',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_apopup`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_apopup`;

CREATE TABLE `fa_bbfx_apopup` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `name` varchar(100) DEFAULT NULL COMMENT '单页名称',
  `thumb` varchar(255) NOT NULL COMMENT '单页图片',
  `link` text NOT NULL COMMENT '跳转链接',
  `width` int(10) unsigned NOT NULL DEFAULT '80' COMMENT '宽度',
  `height` int(10) unsigned NOT NULL DEFAULT '80' COMMENT '高度',
  `tanchu` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '弹出次数,0为不限制',
  `is_gzh_show` int(10) NOT NULL DEFAULT '0' COMMENT '公众号网页展示:1=是,0=否',
  `status` int(10) NOT NULL DEFAULT '1' COMMENT '状态:1=正常,0=禁用',
  `sort` int(10) NOT NULL DEFAULT '0' COMMENT '排序',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_bbfx_apopup_log`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_apopup_log`;

CREATE TABLE `fa_bbfx_apopup_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `pid` int(10) NOT NULL DEFAULT '0' COMMENT '单页ID',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_bbfx_apopup_set`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_apopup_set`;

CREATE TABLE `fa_bbfx_apopup_set` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=开启,0=关闭',
  `mode` int(10) NOT NULL DEFAULT '0' COMMENT '展示类型:0=重叠展示,1=轮播展示',
  `width` int(10) NOT NULL DEFAULT '80' COMMENT '宽度',
  `height` int(10) NOT NULL DEFAULT '60' COMMENT '高度',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_bbfx_attachment_category`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_attachment_category`;

CREATE TABLE `fa_bbfx_attachment_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `name` varchar(100) DEFAULT NULL COMMENT '分类名称',
  `sort` int(10) NOT NULL DEFAULT '0' COMMENT '排序',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_bbfx_auth`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_auth`;

CREATE TABLE `fa_bbfx_auth` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `pid` int(10) DEFAULT NULL,
  `rule` varchar(255) DEFAULT NULL,
  `type` int(10) NOT NULL DEFAULT '0' COMMENT '0 页面 1 Ajax请求',
  `sort` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=462 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Data for the table `fa_bbfx_auth`
-- ----------------------------

INSERT INTO `fa_bbfx_auth` VALUES (1, '数据统计', NULL, '/dashboard', 0, 170);
INSERT INTO `fa_bbfx_auth` VALUES (2, '用户管理', NULL, '/user', 0, 160);
INSERT INTO `fa_bbfx_auth` VALUES (3, '用户列表', 2, '/user/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (4, '余额提现', 355, '/finance/withdrawal/withdrawal', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (5, '商品管理', NULL, '/goods', 0, 150);
INSERT INTO `fa_bbfx_auth` VALUES (6, '商品列表', 5, '/goods/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (8, '商品分类', 5, '/goods/categroy', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (9, '订单管理', NULL, '/order', 0, 140);
INSERT INTO `fa_bbfx_auth` VALUES (10, '订单列表', 9, '/order/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (15, '售后订单', 9, '/order/sales', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (17, '分销管理', NULL, '/fenxiao', 0, 130);
INSERT INTO `fa_bbfx_auth` VALUES (18, '分销中心', 17, '/fenxiao/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (19, '分销用户', 2, '/user/user', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (20, '分销等级', 17, '/fenxiao/level', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (21, '提现管理', 355, '/finance/withdrawal/commissionWithdrawal', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (22, '分销海报', 17, '/fenxiao/poster', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (23, '分销树', 17, '/fenxiao/tree', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (24, '分销订单', 19, 'fenxiao/order/list', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (25, '应用管理', NULL, '/plugin/index', 0, 120);
INSERT INTO `fa_bbfx_auth` VALUES (26, '积分商城', 25, '/scoreshop/index', 0, 110);
INSERT INTO `fa_bbfx_auth` VALUES (27, '基本设置', 26, '/scoreshop', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (28, '商品管理', 26, '/scoreshop/goods', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (29, '商品分类', 26, '/scoreshop/category', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (30, '兑换记录', 26, '/scoreshop/order', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (31, '资金转账', 25, '/transfer_account/index', 0, 100);
INSERT INTO `fa_bbfx_auth` VALUES (32, '区域代理', 25, '/agent/index', 0, 90);
INSERT INTO `fa_bbfx_auth` VALUES (33, '基本设置', 32, '/agent', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (34, '代理用户', 32, '/agent/user', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (35, '返还奖', 25, '/return/index', 0, 80);
INSERT INTO `fa_bbfx_auth` VALUES (36, '基础设置', 35, '/return', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (37, '返还列表', 35, '/return/list', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (38, '返还记录', 35, '/return/log', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (39, '链动2+1模式', 25, '/transfer21_mode/index', 0, 70);
INSERT INTO `fa_bbfx_auth` VALUES (40, '链动3+1模式', 25, '/transfer_mode/index', 0, 60);
INSERT INTO `fa_bbfx_auth` VALUES (41, '加权分红', 25, '/abonus/index', 0, 50);
INSERT INTO `fa_bbfx_auth` VALUES (42, '页面装修', 25, '/diypage', 0, 40);
INSERT INTO `fa_bbfx_auth` VALUES (43, '权限管理', NULL, '/auth', 0, 30);
INSERT INTO `fa_bbfx_auth` VALUES (44, '管理员', 43, '/auth/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (45, '角色管理', 43, '/auth/role', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (46, '权限列表', 43, '/auth/auth', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (47, '系统配置', NULL, '/config', 0, 1);
INSERT INTO `fa_bbfx_auth` VALUES (48, '基础配置', 47, '/config/basics', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (49, '支付配置', 47, '/config/pay', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (50, '消息通知', 47, '/config/message', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (51, '充值', 3, 'user/recharge/post', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (52, '删除', 3, 'user/user/delete', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (53, '修改状态', 3, 'user/user/status', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (56, '提现审核', 4, 'user/withdrawal/check', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (57, '设置状态', 6, 'goods/goods/status', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (58, '删除', 6, 'goods/goods/delete', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (59, '编辑', 6, 'goods/goods/post', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (60, '设置状态', 8, 'goods/category/status', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (61, '删除', 8, 'goods/category/delete', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (62, '编辑', 8, 'goods/category/post', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (63, '添加卡密', 6, 'goods/serialNumber/post', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (64, '删除卡密', 6, 'goods/serialNumber/delete', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (65, '订单详情', 10, 'order/order/detail', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (66, '订单发货', 10, 'order/order/send', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (67, '修改收货信息', 10, 'order/order/updateDeliver', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (68, '订单收货', 10, 'order/order/takeDelivery', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (69, '订单退款', 10, 'order/order/refund', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (70, '编辑', 18, 'fenxiao/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (71, '设置分销商', 19, 'fenxiao/user/setSupuser', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (72, '删除身份', 19, 'fenxiao/user/delete', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (73, '删除', 20, 'fenxiao/level/delete', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (74, '编辑', 20, 'fenxiao/level/post', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (75, '提现审核', 21, 'fenxiao/withdrawal/check', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (76, '删除', 22, 'fenxiao/poster/delete', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (77, '编辑', 22, 'fenxiao/poster/post', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (78, '基本设置编辑', 27, 'scoreshop/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (79, '删除', 28, 'scoreshop/goods/delete', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (80, '设置状态', 28, 'scoreshop/goods/status', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (81, '编辑', 28, 'scoreshop/goods/post', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (82, '添加卡密', 28, 'scoreshop/goods/serialnumberPost', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (83, '删除卡密', 28, 'scoreshop/goods/serialnumberDel', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (84, '设置状态', 29, 'scoreshop/category/status', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (85, '删除', 29, 'scoreshop/category/delete', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (86, '编辑', 29, 'scoreshop/category/post', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (87, '兑换详情', 30, 'scoreshop/order/detail', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (88, '退款', 30, 'scoreshop/order/refund', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (89, '发货', 30, 'scoreshop/order/send', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (90, '收货', 30, 'scoreshop/order/takeDelivery', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (91, '修改收货信息', 30, 'scoreshop/order/updateDeliver', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (92, '修改备注', 30, 'scoreshop/order/updateRemarks', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (93, '基本设置编辑', 31, 'transfer_account/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (94, '代理设置编辑', 33, 'agent/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (95, '删除区域代理身份', 34, 'agent/user/delete', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (96, '修改状态', 34, 'agent/user/status', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (97, '基本设置编辑', 36, 'return/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (98, '基本设置编辑', 39, 'transfer_mode/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (99, '基础设置编辑', 41, 'abonus/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (100, '设置默认页面', 304, 'diypage/index/setDefault', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (101, '删除', 304, 'diypage/index/delete', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (102, '编辑', 304, 'diypage/index/post', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (103, '装修', 304, 'diypage/index/updateDiypage', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (104, '删除', 46, 'auth/authDel', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (105, '编辑', 46, 'auth/authPost', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (106, '删除', 45, 'auth/roleDel', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (107, '编辑', 45, 'auth/rolePost', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (108, '删除', 44, 'auth/delete', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (109, '编辑', 44, 'auth/post', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (110, '编辑', 48, 'config/baseSubmit', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (111, '编辑', 426, 'config/paySubmit', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (112, '编辑', 50, 'config/messageSubmit', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (113, '积分提现', 355, '/finance/withdrawal/scoreWithdrawal', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (114, '提现审核', 113, 'user/withdrawal/score_check', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (115, '查看', 3, 'user/user/list', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (116, '优惠券', 25, '/coupon/index', 0, 10);
INSERT INTO `fa_bbfx_auth` VALUES (117, '优惠券管理', 116, '/coupon', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (118, '发送优惠券', 116, '/coupon/sendCoupon', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (119, '查看', 117, 'sale/coupon/getList', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (120, '修改状态', 117, 'sale/coupon/status', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (121, '编辑', 117, 'sale/coupon/post', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (122, '删除', 117, 'sale/coupon/delete', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (123, '发送优惠券', 118, 'sale/coupon/sendCoupon', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (124, '分销审核', 17, '/user/apply', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (125, '审核', 124, 'fenxiao/apply/check', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (126, '打印设置', 47, '/config/printer', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (127, '打印机管理', 47, '/config/printerList', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (128, '编辑', 126, 'config/printerSubmit', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (129, '编辑', 127, 'printer/post', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (130, '删除', 127, 'printer/delete', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (131, '余额明细', 356, '/finance/financeDetail/moneyLog', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (132, '积分明细', 356, '/finance/financeDetail/scoreLog', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (133, '佣金明细', 356, '/finance/financeDetail/commissionLog', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (134, '会员卡', 25, '/card/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (135, '会员卡', 134, '/card', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (136, '购买记录', 134, '/card/order', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (137, '编辑', 135, 'card/card/post', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (138, '删除', 135, 'card/card/delete', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (139, '修改状态', 135, 'card/card/status', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (140, '文章视频', 25, '/news/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (141, '查看', 135, 'card/card/getList', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (142, '文章列表', 140, '/news', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (143, '查看', 142, 'news/article/getList', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (144, '编辑', 142, 'news/article/post', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (145, '删除', 142, 'news/article/delete', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (146, '修改状态', 142, 'news/article/status', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (147, '视频列表', 140, '/news/video', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (148, '查看', 147, 'news/video/getList', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (149, '编辑', 147, 'news/video/post', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (150, '删除', 147, 'news/video/delete', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (151, '修改状态', 147, 'news/video/status', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (152, '分类列表', 140, '/news/category', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (153, '查看', 152, 'news/category/getList', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (154, '编辑', 152, 'news/category/post', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (155, '删除', 152, 'news/category/delete', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (156, '修改状态', 152, 'news/category/status', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (157, '双轨模式', 25, '/double_track/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (158, '双轨模式', 157, '/double_track', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (159, '基础设置', 158, 'double_track/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (160, '管理等级', 157, '/double_track/level', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (161, '查看', 160, 'double_track/level/getList', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (162, '编辑', 160, 'double_track/level/post', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (163, '删除', 160, 'double_track/level/delete', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (164, '清除数据', 47, '/config/clear', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (165, '清除', 164, 'common/clearData', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (166, '核销订单', 10, 'order/order/hexiao', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (167, '关闭订单', 10, 'order/order/close', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (168, '删除订单', 10, 'order/order/delete', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (169, '充值管理', 354, '/finance/rechargeLog', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (170, '查看业绩', 19, 'fenxiao/user/getTeamAchievement', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (171, '查看团队', 19, 'fenxiao/user/team', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (172, '门店管理', NULL, '/store', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (173, '门店列表', 172, '/store/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (174, '查看', 173, 'store/store/getList', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (175, '编辑', 173, 'store/store/post', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (176, '删除', 173, 'store/store/delete', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (177, '经销商', 172, '/store/dealer', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (178, '查看', 177, 'store/dealer/getList', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (179, '编辑', 177, 'store/dealer/post', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (180, '删除', 177, 'store/dealer/delete', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (181, '级差奖', 25, '/jicha/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (182, '设置', 181, 'jicha/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (183, '复购奖', 25, '/repurchase/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (184, '设置', 183, 'repurchase/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (185, '见单奖', 25, '/jiandan/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (186, '设置', 185, 'jiandan/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (187, '平级奖', 25, '/pingji/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (188, '设置', 187, 'pingji/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (189, '管理奖', 25, '/management/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (190, '设置', 189, 'management/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (191, '限时特价', 25, '/seckill/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (192, '活动列表', 191, '/seckill', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (193, '查看', 192, 'seckill/index/getList', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (194, '编辑', 192, 'seckill/index/post', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (195, '删除', 192, 'seckill/index/delete', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (196, '设置状态', 192, 'seckill/index/status', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (197, '商品列表', 191, '/seckill/goods', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (198, '查看', 197, 'seckill/goods/getList', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (199, '编辑', 197, 'seckill/goods/post', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (200, '删除', 197, 'seckill/goods/delete', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (201, '设置状态', 197, 'seckill/goods/status', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (202, '321模式', 25, '/yies_mode/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (203, '设置', 202, 'yies_mode/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (204, '复购平级奖', 25, '/repurchasepingji/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (205, '设置', 204, 'repurchasepingji/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (206, '活动弹窗', 25, '/apopup/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (207, '基础设置', 206, 'apopup/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (208, '活动单页', 206, '/apopup/list', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (209, '查看', 208, 'apopup/index/getList', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (210, '编辑', 208, 'apopup/index/post', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (211, '删除', 208, 'apopup/index/delete', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (212, '设置状态', 208, 'apopup/index/status', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (213, '电子合同', 25, '/contract/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (214, '基础设置', 213, 'contract/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (215, '合同列表', 213, '/contract/list', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (216, '查看', 215, 'contract/contract/getList', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (217, '编辑', 215, 'contract/contract/post', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (218, '删除', 215, 'contract/contract/delete', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (219, '用户合同', 213, '/contract/record', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (220, '意见反馈', 25, '/feedback/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (221, '处理', 220, 'feedback/feedback/status', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (222, '删除', 220, 'feedback/feedback/delete', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (223, '复购金', 25, '/repurchasegold/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (224, '设置', 223, 'repurchasegold/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (225, '累计返还奖', 25, '/cumulative_fanhuan/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (226, '基础设置', 225, 'cumulative_fanhuan/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (227, '返还用户', 225, '/cumulative_fanhuan/user', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (228, '云仓', 25, '/cloud_warehouse/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (229, '设置', 228, 'cloud_warehouse/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (230, '阶梯直推', 25, '/ladderpush/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (231, '设置', 230, 'ladderpush/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (232, '阶梯加权分红', 25, '/ladderabonus/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (233, '设置', 232, 'ladderabonus/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (234, '指定奖', 25, '/appoint/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (235, '设置', 234, 'appoint/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (236, '直推业绩奖', 25, '/directpush_achievement/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (237, '设置', 236, 'directpush_achievement/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (238, '直推见单奖', 25, '/directpush_jiandan/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (239, '设置', 238, 'directpush_jiandan/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (240, '下二代奖', 25, '/below/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (241, '设置', 240, 'below/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (242, '团建奖', 25, '/team_building/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (243, '设置', 242, 'team_building/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (244, '出局倍数', 25, '/strikeout/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (245, '设置', 244, 'strikeout/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (246, '排队免单', 25, '/queue_mode/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (247, '基础设置', 246, 'queue_mode/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (248, '排队用户', 246, '/queue_mode/user', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (249, '返还铭记', 246, '/queue_mode/record', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (250, '直推团队奖', 25, '/directpush_team/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (251, '设置', 250, 'directpush_team/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (252, '股份加权分红', 25, '/sabonus/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (253, '设置', 252, 'sabonus/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (254, '动态红包', 25, '/dynamic_redpacket/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (255, '基础设置', 254, 'dynamic_redpacket/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (256, '红包提现', 254, '/dynamic_redpacket/withdrawal', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (257, '审核', 256, 'dynamic_redpacket/withdrawal/check', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (258, '短视频', 25, '/short_video/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (259, '基础设置', 258, 'short_video/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (260, '视频列表', 258, '/short_video/video', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (261, '查看', 260, 'short_video/video/getList', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (262, '编辑', 260, 'short_video/video/post', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (263, '删除', 260, 'short_video/video/delete', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (264, '设置状态', 260, 'short_video/video/status', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (265, '评论列表', 258, '/short_video/comment', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (266, '审核', 265, 'short_video/comment/shenhe', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (267, '删除', 265, 'short_video/comment/delete', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (268, '常见问题', 25, '/problem/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (269, '查看', 268, 'problem/problem/getList', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (270, '编辑', 268, 'problem/problem/post', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (271, '删除', 268, 'problem/problem/delete', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (272, '设置状态', 268, 'problem/category/status', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (273, '预存释放', 25, '/deposit_release/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (274, '基础设置', 273, 'deposit_release/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (275, '预存订单', 273, '/deposit_release/order', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (276, '预存记录', 356, '/finance/financeDetail/depositLog', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (277, '提现记录', 273, '/deposit_release/withdrawal', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (278, '审核', 277, 'deposit_release/withdrawal/check', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (279, '操作日志', 43, '/auth/operLog', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (280, '编辑', 3, 'user/user/post', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (281, '商品评价', 5, '/goods/comment', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (282, '查看', 281, 'goods/comment/getList', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (283, '删除', 281, 'goods/comment/delete', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (284, '审核', 281, 'goods/comment/shenhe', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (285, '审核', 169, 'user/recharge/check', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (286, '设置', 34, 'agent/user/setUser', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (287, '设置库存', 228, 'cloud_warehouse/user/setStock', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (288, '库存记录', 228, '/cloud_warehouse/log', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (289, '签到有礼', 25, '/signin/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (290, '基础设置', 289, 'signin/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (291, '签到记录', 289, '/signin/signin', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (292, '拼团活动', 25, '/pintuan/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (293, '基础设置', 292, 'pintuan/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (294, '拼团商品', 292, '/pintuan/pintuan', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (295, '查看', 294, 'pintuan/goods/getList', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (296, '编辑', 294, 'pintuan/goods/post', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (297, '删除', 294, 'pintuan/goods/delete', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (298, '上/下架', 294, 'pintuan/goods/status', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (299, '拼团订单', 292, '/pintuan/pintuan/order', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (300, '查看', 299, 'pintuan/order/getList', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (301, '强制操作', 299, 'pintuan/order/force', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (302, '储值利息', 25, '/sinterest/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (303, '基础设置', 302, 'sinterest/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (304, '页面装修', 42, '/diypage/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (305, '样式风格', 42, '/diypage/style', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (306, '编辑', 305, 'config/styleSubmit', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (307, '超越奖', 25, '/chaoyue/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (308, '基础设置', 307, 'chaoyue/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (309, '阶梯平级奖', 25, '/ladderpingji/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (310, '基础设置', 309, 'ladderpingji/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (311, '多商户', 25, '/merchant/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (312, '基础设置', 311, 'merchant/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (313, '商户管理', 311, '/merchant/merchantList', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (314, '查看', 313, 'merchant/merchant/getList', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (315, '编辑', 313, 'merchant/merchant/post', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (316, '删除', 313, 'merchant/merchant/delete', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (317, '审核', 313, 'merchant/merchant/shenhe', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (318, '商品管理', 311, '/merchant/goods', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (319, '查看', 318, 'merchant/goods/getList', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (320, '编辑', 318, 'merchant/goods/post', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (321, '上架/下架', 318, 'merchant/goods/status', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (322, '审核', 318, 'merchant/goods/shenhe', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (323, '商品评价', 318, '/merchant/goods/comment', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (324, '查看', 323, 'merchant/comment/getList', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (325, '商品分类', 311, '/merchant/categroy', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (326, '查看', 325, 'merchant/category/getList', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (327, '删除', 325, 'merchant/category/delete', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (328, '提现管理', 311, '/merchant/withdrawal', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (329, '查看', 328, 'merchant/withdrawal/getList', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (330, '打款审核', 328, 'merchant/withdrawal/check', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (331, '疯狂卖货模式', 25, '/crazy/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (332, '基础设置', 331, 'crazy/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (333, '人脉互助模式', 25, '/sconnection/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (334, '基础设置', 333, 'sconnection/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (335, '返利拼团', 25, '/rebate_pintuan/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (336, '基础设置', 335, 'rebate_pintuan/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (337, '内缩平级奖', 25, '/npingji/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (338, '基础设置', 337, 'npingji/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (339, '提现分红', 25, '/txabonus/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (340, '基础设置', 339, 'txabonus/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (341, '发放奖励', 339, 'txabonus/config/releaseReward', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (342, '运费模板', 25, '/shippingfee/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (343, '模板列表', 342, 'shippingfee/template/getList', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (344, '资金池', 25, '/capitalpool/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (345, '基础设置', 344, 'capitalpool/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (346, '手动分红', 344, 'capitalpool/config/setAbonus', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (347, '排行榜', 25, '/paihangbang/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (348, '基础设置', 347, 'paihangbang/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (349, '排行榜用户', 347, '/paihangbang/user', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (350, '超级卖货模式', 25, '/super_maihuo/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (351, '基础配置', 350, 'super_maihuo/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (352, '新三三复制', 25, '/pyramid/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (353, '基础配置', 352, 'pyramid/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (354, '财务管理', NULL, '/finance', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (355, '提现管理', 354, '/finance/withdrawal', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (356, '财务明细', 354, '/finance/financeDetail', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (357, '复购金记录', 356, '/finance/financeDetail/repurchasegoldLog', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (358, '扫码验真', 25, '/sverify/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (359, '基础配置', 358, 'sverify/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (360, '产品管理', 358, '/sverify/product', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (361, '防伪码管理', 358, '/sverify/code', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (362, '查询记录', 358, '/sverify/record', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (363, '查看', 360, 'sverify/product/getList', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (364, '编辑', 360, 'sverify/product/post', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (365, '删除', 360, 'sverify/product/delete', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (366, '生成防伪码', 360, 'sverify/product/batchCreate', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (367, '查看', 361, 'sverify/product_code/getList', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (368, '删除', 361, 'sverify/product_code/delete', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (369, '删除', 362, 'sverify/query/delete', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (370, '阶梯管理奖', 25, '/laddermanage/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (371, '基础设置', 370, 'laddermanage/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (372, '押金', 25, '/yajin/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (373, '基础配置', 372, 'yajin/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (374, '押金记录', 372, '/yajin/order', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (375, '退还记录', 372, '/yajin/refund', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (376, '审核', 375, 'yajin/refund/shenhe', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (377, '模式预设', 25, '/preset/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (378, '使用模式', 377, 'mode/initMode', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (379, '电子面单', 47, '/config/aliyunEWaybill', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (380, '编辑', 379, 'config/electronicWaybillSubmit', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (381, '分享素材', 25, '/smaterial/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (382, '分享素材', 381, 'smaterial/smaterial/getList', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (383, '素材分类', 381, '/smaterial/category', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (384, 'Ai问答', 25, '/qwen/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (385, '基础配置', 384, 'qwen/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (386, 'Ai数字人', 25, '/shuziren/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (387, '基础配置', 386, 'shuziren/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (388, '快递公司', 47, '/config/deliveryList', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (389, '贡献值', 25, '/contribution/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (390, '基础配置', 389, 'contribution/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (391, '删除', 318, 'merchant/goods/delete', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (392, '编辑', 325, 'merchant/category/post', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (393, '礼品', 25, '/gift/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (394, '基础配置', 393, 'gift/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (395, '消息通知', 25, '/notice/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (396, '发送通知', 395, 'notice/notice/send', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (397, '删除通知', 395, 'notice/notice/delete', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (398, '超级聊天', 25, '/chat/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (399, '基础配置', 398, 'chat/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (400, '活动报名', 25, '/activity/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (401, '基础配置', 400, 'activity/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (402, '活动列表', 400, '/activity/list', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (403, '详情', 402, 'activity/activity/detail', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (404, '编辑', 402, 'activity/activity/post', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (405, '审核', 402, 'activity/activity/shenhe', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (406, '删除', 402, 'activity/activity/delete', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (407, '报名列表', 400, '/activity/baominList', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (408, '复购见单', 25, '/repurchase_jiandan/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (409, '基础配置', 408, 'repurchase_jiandan/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (410, '下二代福利奖', 25, '/below_welfare/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (411, '基础配置', 410, 'below_welfare/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (412, '分享奖', 25, '/saward/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (413, '基础配置', 412, 'saward/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (414, '系统信息', 0, '/site', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (415, '后台登录页', 414, '/site/login', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (416, '微信公众号', 414, '/site/wechatGZH', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (417, '微信小程序', 414, '/site/miniProgram', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (418, '公众号支付', 414, '/site/wechatGZHPay', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (419, '微信小程序支付', 414, '/site/miniProgramPay', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (420, '服务商支付', 414, '/site/servicePay', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (421, '支付宝支付', 414, '/site/alipay', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (422, '微信H5支付', 414, '/site/wechatH5', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (423, '环境信息', 414, '/site/system', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (426, '支付配置', 49, '/config/pay/pay', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (427, '余额充值', 49, '/config/pay/balance', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (428, '编辑', 427, 'config/rechargebalanceSubmit', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (429, '积分充值', 49, '/config/pay/score', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (430, '编辑', 429, 'config/rechargescoreSubmit', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (431, '余额提现', 49, '/config/pay/balancewithdrawl', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (432, '编辑', 431, 'config/withdrawalSubmit', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (433, '积分提现', 49, '/config/pay/scorewithdrawl', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (434, '编辑', 433, 'config/withdrawalscoreSubmit', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (435, '佣金提现', 49, '/config/pay/commissionwithdrawl', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (436, '编辑', 435, 'fenxiao/config/withdrawalSet', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (437, '层级级差', 25, '/leveljicha/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (438, '基础配置', 437, 'leveljicha/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (439, '积分业绩', 25, '/sachievement/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (440, '基础配置', 439, 'sachievement/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (441, '合并等级', 25, '/mergelevel/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (442, '基础配置', 441, 'mergelevel/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (443, '积分奖励', 25, '/scorereward/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (444, '基础配置', 443, 'scorereward/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (445, '分销积分', 25, '/fenxiaoscore/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (446, '基础配置', 445, 'fenxiaoscore/config/set', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (447, '前端入口', 42, '/diypage/front', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (448, '文字替换', 42, '/diypage/textReplace', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (449, '前端模板', 42, '/diypage/template', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (450, '轮播管理', 311, '/merchant/slide', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (451, '编辑', 448, 'config/textSubmit', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (452, '编辑', 450, 'slide/post', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (453, '删除', 450, 'slide/delete', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (454, '商户分类', 311, '/merchant/mchCategroy', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (455, '编辑', 454, 'merchant/merchant_category/post', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (456, '删除', 454, 'merchant/merchant_category/delete', 1, 0);
INSERT INTO `fa_bbfx_auth` VALUES (457, '鸣谢', 414, '/site/thanks', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (458, '激活授权', 414, '/site/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (459, '系统更新', 414, '/site/update', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (460, '自定义表单', 25, '/form/index', 0, 0);
INSERT INTO `fa_bbfx_auth` VALUES (461, '基础配置', 460, 'form/config/set', 1, 0);

-- ----------------------------
-- Table structure for `fa_bbfx_base`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_base`;

CREATE TABLE `fa_bbfx_base` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) NOT NULL DEFAULT '0',
  `title` varchar(20) DEFAULT NULL COMMENT '平台名称',
  `logo` varchar(500) DEFAULT NULL,
  `is_wxpay` int(10) NOT NULL DEFAULT '0' COMMENT '微信支付:1=开启,0=关闭',
  `is_balancepay` int(10) NOT NULL DEFAULT '0' COMMENT '余额支付:1=开启,0=关闭',
  `is_alipay` int(10) NOT NULL DEFAULT '0' COMMENT '支付宝支付:1=开启,0=关闭',
  `is_cashpay` int(10) NOT NULL DEFAULT '0' COMMENT '线下支付:1=开启,0=关闭',
  `theme_color` varchar(10) NOT NULL DEFAULT '#ff5555',
  `font_color` varchar(10) NOT NULL DEFAULT '#ffffff',
  `btn_color` varchar(100) NOT NULL DEFAULT '#ff5555' COMMENT '按钮颜色',
  `is_open` int(10) NOT NULL DEFAULT '1' COMMENT '是否开启服务 1是 2否',
  `ad_unitId` varchar(200) DEFAULT NULL COMMENT '广告位ID',
  `ad_bannar_unitId` varchar(200) DEFAULT NULL,
  `ad_dbannar_unitId` varchar(200) DEFAULT NULL,
  `ad_mbannar_unitId` varchar(200) DEFAULT NULL,
  `ad_interstitialAd_unitId` varchar(200) DEFAULT NULL,
  `is_adunitId` int(10) NOT NULL DEFAULT '0' COMMENT '1 开启激励视频广告',
  `integral` int(10) NOT NULL DEFAULT '0' COMMENT '广告奖励积分',
  `is_sign` int(10) NOT NULL DEFAULT '0' COMMENT '1 开启签到',
  `first_reward` int(10) NOT NULL DEFAULT '0' COMMENT '首次签到奖励',
  `daily_reward` int(10) NOT NULL DEFAULT '0' COMMENT '日常签到奖励',
  `share_title` varchar(20) DEFAULT NULL,
  `share_desc` varchar(200) DEFAULT NULL,
  `share_img` varchar(200) DEFAULT NULL,
  `text_replace` longtext COMMENT '文字替换',
  `appid` varchar(100) DEFAULT NULL COMMENT '公众号appid',
  `appsecret` varchar(100) DEFAULT NULL COMMENT '公众号AppSecret',
  `is_recharge` int(10) NOT NULL DEFAULT '0' COMMENT '开启充值 1 开启 0 关闭',
  `recharge_ratio` decimal(10,2) unsigned NOT NULL DEFAULT '1.00' COMMENT '充值比例',
  `cert` text,
  `cert_key` text,
  `is_task` int(10) NOT NULL DEFAULT '1',
  `task_num` int(11) NOT NULL DEFAULT '-1',
  `is_subscribemsg` int(11) NOT NULL DEFAULT '0',
  `subscribemsg` text,
  `admin` text,
  `stock_remind_num` int(11) NOT NULL DEFAULT '0',
  `access_token` varchar(255) DEFAULT NULL,
  `access_token_time` int(11) NOT NULL DEFAULT '0',
  `wx_access_token` varchar(255) DEFAULT NULL,
  `wx_access_token_time` int(11) NOT NULL DEFAULT '0',
  `is_pian` int(11) NOT NULL DEFAULT '0',
  `notice_type` int(10) NOT NULL DEFAULT '1' COMMENT '1 小程序订阅消息  2 公众号模板消息',
  `wx_appid` varchar(255) DEFAULT NULL,
  `wx_secret` varchar(255) DEFAULT NULL,
  `wx_domain` varchar(255) DEFAULT NULL,
  `updatenotice_tips` varchar(500) DEFAULT NULL COMMENT '前端更新订阅提示',
  `updatenotice_status` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新通知状态:1=开启,0=关闭',
  `is_forcemobile` int(10) NOT NULL DEFAULT '0' COMMENT '强制获取手机号:1=开启,0=关闭',
  `service_agreement` longtext COMMENT '服务协议',
  `privacy_agreement` text COMMENT '隐私协议',
  `login_bg` varchar(255) DEFAULT NULL COMMENT '登录背景',
  `block_tips` varchar(255) DEFAULT NULL COMMENT '拉黑提示',
  `platform_close_tips` varchar(255) DEFAULT NULL COMMENT '平台关闭提示',
  `texts` text COMMENT '文字替换',
  `printer` text COMMENT '打印设置',
  `orderset` text COMMENT '订单配置',
  `goodsset` text COMMENT '商品设置',
  `sms` text COMMENT '短信配置',
  `withdrawal` text COMMENT '提现配置',
  `is_pay_password` int(10) NOT NULL DEFAULT '0' COMMENT '支付密码:1=开启,0=关闭',
  `is_gzh_login` int(10) NOT NULL DEFAULT '0' COMMENT '公众号登录:1=开启,0=关闭',
  `order_oper` int(10) unsigned NOT NULL DEFAULT '1',
  `kefu_link` text COMMENT '客服链接',
  `login_template` int(10) NOT NULL DEFAULT '0' COMMENT '登录模板:0=默认模板,1=模板二',
  `category_template` int(10) NOT NULL DEFAULT '0' COMMENT '分类模板:0=模板一,1=模板二',
  `buylevel_tips` varchar(255) DEFAULT NULL COMMENT '购买商品等级不足提示',
  `fenxiao_template` int(10) NOT NULL DEFAULT '2' COMMENT '分销中心样式',
  `wxapp_login` int(10) NOT NULL DEFAULT '0' COMMENT '小程序端登录:0=小程序登录,1=验证码登录,2=手机号授权登录,3=账号密码登录',
  `recharge` text COMMENT '充值配置',
  `store` text COMMENT '门店设置',
  `data` longtext COMMENT '数据',
  `hide_close_plugin` int(10) NOT NULL DEFAULT '0' COMMENT '隐藏关闭应用:1=是,0=否',
  `new_order_id` int(10) NOT NULL DEFAULT '0' COMMENT '新订单ID',
  `is_merch_transfer_new` int(10) NOT NULL DEFAULT '0' COMMENT '商家转账到零钱新版本:1=开启,0=关闭',
  `bg_color` varchar(100) NOT NULL DEFAULT '#F1F8F4' COMMENT '背景色',
  `top_bg` varchar(255) NOT NULL DEFAULT '/assets/images/newui/mobile/page_bg.png' COMMENT '顶部背景',
  `merch_transfer_scene` varchar(20) NOT NULL DEFAULT '1005' COMMENT '微信商家转账场景',
  `gzh_template_msg` text COMMENT '公众号模板消息',
  `uid_prefix` varchar(100) DEFAULT NULL COMMENT '用户ID前缀',
  `telephone` varchar(100) DEFAULT NULL COMMENT '电话',
  `is_recharge_balance` int(10) NOT NULL DEFAULT '1' COMMENT '充值余额:1=开启,0=关闭',
  `recharge_score_ratio` int(10) NOT NULL DEFAULT '1' COMMENT '积分充值比例',
  `recharge_score` text COMMENT '积分充值设置',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_bbfx_below_welfare`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_below_welfare`;

CREATE TABLE `fa_bbfx_below_welfare` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=开启,0=关闭',
  `reward` text COMMENT '奖励配置',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_capitalpool`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_capitalpool`;

CREATE TABLE `fa_bbfx_capitalpool` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=开启,0=关闭',
  `abonus_money` decimal(12,2) NOT NULL DEFAULT '0.00' COMMENT '资金池金额',
  `capital_rate` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '资金比例',
  `capital_settlement_type` int(10) NOT NULL DEFAULT '1' COMMENT '资金结算:1=付款后结算,2=完成后结算,3=每进指定单量计算',
  `capital_settlement_order` int(10) NOT NULL DEFAULT '0' COMMENT '资金池结算单量',
  `capital_settlement_finally_order` int(10) NOT NULL DEFAULT '0' COMMENT '最后结算资金池订单',
  `settlement_type` int(10) NOT NULL DEFAULT '0' COMMENT '结算类型:0=手动结算,1=每月结算,2=每季结算,3=每年结算',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_capitalpool_money_log`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_capitalpool_money_log`;

CREATE TABLE `fa_bbfx_capitalpool_money_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `type` int(10) NOT NULL DEFAULT '0' COMMENT '类型',
  `title` varchar(255) DEFAULT NULL COMMENT '标题',
  `money` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '变动金额',
  `before` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '变动前',
  `after` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '变动后',
  `extend` varchar(255) DEFAULT NULL,
  `createtime` bigint(16) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_category`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_category`;

CREATE TABLE `fa_bbfx_category` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) NOT NULL DEFAULT '0',
  `mid` int(10) NOT NULL DEFAULT '0' COMMENT '商户ID',
  `pid` int(10) NOT NULL DEFAULT '0' COMMENT '上级分类ID',
  `title` varchar(10) DEFAULT NULL COMMENT '分类名称',
  `status` int(10) NOT NULL DEFAULT '1' COMMENT '是否显示:1=显示,0=隐藏',
  `thumb` varchar(255) DEFAULT NULL COMMENT '图标',
  `sort` int(10) NOT NULL DEFAULT '0' COMMENT '排序',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=53 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_bbfx_chaoyue`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_chaoyue`;

CREATE TABLE `fa_bbfx_chaoyue` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=开启,0=关闭',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_chat`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_chat`;

CREATE TABLE `fa_bbfx_chat` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=开启,0=关闭',
  `port` int(10) NOT NULL DEFAULT '2000' COMMENT '端口',
  `ssl_cert` varchar(255) DEFAULT NULL COMMENT 'SSL证书文件',
  `ssl_certkey` varchar(255) DEFAULT NULL COMMENT 'SSL私钥文件',
  `tip` varchar(500) DEFAULT NULL COMMENT '聊天提示',
  `kefu_uid` varchar(500) DEFAULT NULL COMMENT '客服ID',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_chat_dialogue`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_chat_dialogue`;

CREATE TABLE `fa_bbfx_chat_dialogue` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `rid` varchar(100) DEFAULT NULL COMMENT '对话ID',
  `type` int(10) NOT NULL DEFAULT '0' COMMENT '类型:0=朋友聊天,1=群聊天',
  `from_user_id` int(10) NOT NULL DEFAULT '0' COMMENT '发起用户ID',
  `to_user_id` int(10) NOT NULL DEFAULT '0' COMMENT '接收用户ID',
  `name` varchar(255) DEFAULT NULL COMMENT '会话名称',
  `from_user_status` int(10) NOT NULL DEFAULT '1' COMMENT '状态:1=显示,0=隐藏',
  `to_user_status` int(10) NOT NULL DEFAULT '1' COMMENT '状态:1=显示,0=隐藏',
  `updatetime` bigint(16) NOT NULL DEFAULT '0' COMMENT '更新时间',
  `createtime` bigint(16) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_chat_friend`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_chat_friend`;

CREATE TABLE `fa_bbfx_chat_friend` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `friend_user_id` int(10) NOT NULL DEFAULT '0' COMMENT '好友用户ID',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:0=待同意,1=同意,2=拒绝',
  `user_del` int(10) NOT NULL DEFAULT '0' COMMENT '删除:1=是,0=否',
  `friend_user_del` int(10) NOT NULL DEFAULT '0' COMMENT '删除:1=是,0=否',
  `shtime` bigint(16) NOT NULL DEFAULT '0' COMMENT '审核时间',
  `updatetime` bigint(16) NOT NULL DEFAULT '0' COMMENT '更新时间',
  `createtime` bigint(16) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_chat_list`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_chat_list`;

CREATE TABLE `fa_bbfx_chat_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `from_user_id` int(10) NOT NULL DEFAULT '0' COMMENT '发送用户ID',
  `to_user_id` int(10) NOT NULL DEFAULT '0' COMMENT '接收用户ID',
  `pid` int(10) NOT NULL DEFAULT '0' COMMENT '会话ID',
  `type` int(10) NOT NULL DEFAULT '1' COMMENT '类型:1=文字,2=图片,3=视频,4=语音',
  `content` varchar(1000) DEFAULT NULL COMMENT '消息内容',
  `is_read` int(10) NOT NULL DEFAULT '0' COMMENT '已读:1=是,0=否',
  `readtime` bigint(16) NOT NULL DEFAULT '0' COMMENT '已读时间',
  `from_user` varchar(1000) DEFAULT NULL COMMENT '发送用户信息',
  `to_user` varchar(1000) DEFAULT NULL COMMENT '接收用户信息',
  `is_revoke` int(10) NOT NULL DEFAULT '0' COMMENT '撤回:1=是,0=否',
  `revoketime` bigint(16) NOT NULL DEFAULT '0' COMMENT '撤回时间',
  `from_user_del` int(10) NOT NULL DEFAULT '0' COMMENT '发送用户删除:1=是,0=否',
  `to_user_del` int(10) NOT NULL DEFAULT '0' COMMENT '接收用户删除:1=是,0=否',
  `createtime` bigint(16) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=387 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_chat_read`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_chat_read`;

CREATE TABLE `fa_bbfx_chat_read` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `chat_id` int(10) NOT NULL DEFAULT '0' COMMENT '消息ID',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `pid` int(10) NOT NULL DEFAULT '0' COMMENT '对话ID',
  `createtime` bigint(16) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_cloud_warehouse`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_cloud_warehouse`;

CREATE TABLE `fa_bbfx_cloud_warehouse` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=开启,0=关闭',
  `cw_goods` varchar(1000) DEFAULT NULL COMMENT '云仓商品',
  `fanhuan_rate` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '返还比例',
  `fanhuan_currency` int(10) NOT NULL DEFAULT '1' COMMENT '返还币种:1=余额,2=积分',
  `level` int(10) NOT NULL DEFAULT '0' COMMENT '云仓开启等级',
  `delayed_daozhang` int(10) NOT NULL DEFAULT '0' COMMENT '延时到账天数',
  `chuhuo_deduct_pingji` int(10) NOT NULL DEFAULT '0' COMMENT '出货奖扣除平级奖:1=开启,0=关闭',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_cloud_warehouse_goods`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_cloud_warehouse_goods`;

CREATE TABLE `fa_bbfx_cloud_warehouse_goods` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `goods_id` int(10) NOT NULL DEFAULT '0' COMMENT '商品ID',
  `stock` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '库存',
  `jinhuo_stock` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '进货库存(最多还可进多少货)',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_cloud_warehouse_stock_record`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_cloud_warehouse_stock_record`;

CREATE TABLE `fa_bbfx_cloud_warehouse_stock_record` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `goods_id` int(10) NOT NULL DEFAULT '0' COMMENT '云仓商品',
  `type` int(10) NOT NULL DEFAULT '0' COMMENT '操作类型',
  `item_type` int(10) NOT NULL DEFAULT '0' COMMENT '项目类型',
  `item_id` int(10) NOT NULL DEFAULT '0' COMMENT '项目ID',
  `stock` int(11) NOT NULL DEFAULT '0' COMMENT '变动库存',
  `befores` int(10) NOT NULL DEFAULT '0' COMMENT '变动前',
  `afters` int(10) NOT NULL DEFAULT '0' COMMENT '变动后',
  `title` varchar(100) DEFAULT NULL COMMENT '标题',
  `info` text COMMENT '数据',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '操作时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_comment_zan`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_comment_zan`;

CREATE TABLE `fa_bbfx_comment_zan` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `type` int(10) NOT NULL DEFAULT '0' COMMENT '类型:0=商品',
  `pid` int(10) NOT NULL DEFAULT '0' COMMENT '主ID',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_contract`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_contract`;

CREATE TABLE `fa_bbfx_contract` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `name` varchar(100) DEFAULT NULL COMMENT '活动名称',
  `content` varchar(255) NOT NULL COMMENT '活动内容',
  `type` int(10) NOT NULL DEFAULT '0' COMMENT '合同类型:1=商品合同',
  `signing_type` int(10) NOT NULL DEFAULT '0' COMMENT '签约类型:0=强制签约,1=普通签约',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_bbfx_contract_record`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_contract_record`;

CREATE TABLE `fa_bbfx_contract_record` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `name` varchar(100) DEFAULT NULL COMMENT '合同名称',
  `pid` int(10) NOT NULL DEFAULT '0' COMMENT '合同ID',
  `og_id` int(10) NOT NULL DEFAULT '0' COMMENT '订单商品ID',
  `content` varchar(255) NOT NULL COMMENT '合同路径',
  `type` int(10) NOT NULL DEFAULT '0' COMMENT '合同类型:1=商品合同',
  `signing_type` int(10) NOT NULL DEFAULT '0' COMMENT '签约类型:0=强制签约,1=普通签约	',
  `signingtime` bigint(16) NOT NULL DEFAULT '0' COMMENT '签约时间',
  `signing_image` varchar(255) DEFAULT NULL COMMENT '签名图片',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '签约状态:0=已签约,1=未签约',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_bbfx_contract_set`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_contract_set`;

CREATE TABLE `fa_bbfx_contract_set` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=开启,0=关闭',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_bbfx_contribution`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_contribution`;

CREATE TABLE `fa_bbfx_contribution` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL COMMENT '平台ID',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=开启,0=关闭',
  `source` text COMMENT '贡献值来源',
  `score_convert` int(10) NOT NULL DEFAULT '0' COMMENT '积分转换:1=开启,0=关闭',
  `score_convert_rate` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '积分转换比例',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_coupon`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_coupon`;

CREATE TABLE `fa_bbfx_coupon` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(11) NOT NULL DEFAULT '0',
  `type` int(10) NOT NULL DEFAULT '0' COMMENT '优惠券类型:0=一次性,1=持续性',
  `name` varchar(100) DEFAULT NULL COMMENT '优惠券名称',
  `money` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '优惠券金额',
  `max_money` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '使用金额限制(%)',
  `mj_money` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '满减金额（0为不限制）',
  `validitytime` int(10) NOT NULL DEFAULT '0' COMMENT '有效期（天）,0为为不限制',
  `status` int(10) NOT NULL DEFAULT '1' COMMENT '状态:0=禁用,1=正常(已领取的优惠券禁用无效)',
  `goods_ids` varchar(500) DEFAULT NULL COMMENT '指定商品',
  `total` int(10) NOT NULL DEFAULT '-1' COMMENT '优惠券数量',
  `condition_type` int(10) NOT NULL DEFAULT '0' COMMENT '使用条件:0=无条件,1=指定商品,2=满减金额',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_bbfx_crazy`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_crazy`;

CREATE TABLE `fa_bbfx_crazy` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=开启,0=关闭',
  `daozhang_type` int(10) NOT NULL DEFAULT '0' COMMENT '份额到账类型:1=付款后到账,0=完成后到账',
  `repurchase_goods` varchar(255) DEFAULT NULL COMMENT '复购商品',
  `abonus_num` int(10) NOT NULL DEFAULT '1' COMMENT '分红次数',
  `abonus_money` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '每份金额',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_crazy_group`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_crazy_group`;

CREATE TABLE `fa_bbfx_crazy_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `group_id` int(10) NOT NULL DEFAULT '0' COMMENT '主分红组ID',
  `pid` int(10) NOT NULL DEFAULT '0' COMMENT '分红用户ID',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '组长ID',
  `order_id` int(10) NOT NULL DEFAULT '0' COMMENT '订单ID',
  `total` int(10) NOT NULL DEFAULT '0' COMMENT '人数',
  `stime` int(11) NOT NULL DEFAULT '0' COMMENT '开始时间',
  `etime` int(11) NOT NULL DEFAULT '0' COMMENT '结束时间',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:0=待分红,1=已分红',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_crazy_group_user`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_crazy_group_user`;

CREATE TABLE `fa_bbfx_crazy_group_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `pid` int(10) NOT NULL DEFAULT '0' COMMENT '分红用户ID',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `order_id` int(10) NOT NULL DEFAULT '0' COMMENT '订单ID',
  `group_id` int(10) NOT NULL DEFAULT '0' COMMENT '分组ID',
  `money` decimal(10,0) unsigned NOT NULL DEFAULT '0' COMMENT '分红金额',
  `contribution_value` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '贡献值',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=101 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_crazy_user`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_crazy_user`;

CREATE TABLE `fa_bbfx_crazy_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `order_id` int(10) NOT NULL DEFAULT '0' COMMENT '订单ID',
  `num` int(10) NOT NULL DEFAULT '0' COMMENT '分红次数',
  `money` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '分红金额',
  `contribution_value` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '贡献值',
  `info` text COMMENT '信息',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=已完成,0=进行中',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=52 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_cumulative_fanhuan`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_cumulative_fanhuan`;

CREATE TABLE `fa_bbfx_cumulative_fanhuan` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=开启,0=关闭',
  `fanhuan_total` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '返还比例',
  `everyday_rate` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '每天返还(‰)',
  `settlement_currency` int(10) NOT NULL DEFAULT '1' COMMENT '结算币种:1=余额,2=积分',
  `settlement_status` int(10) NOT NULL DEFAULT '1' COMMENT '结算状态:1=已付款,2=已完成',
  `release_method` int(10) NOT NULL DEFAULT '1' COMMENT '释放方式:1=常规释放,2=递减释放',
  `decimal_type` int(10) NOT NULL DEFAULT '2' COMMENT '释放数值:1=向下取值,2=四舍五入,3=向上取值',
  `oper` int(10) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_cumulative_fanhuan_user`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_cumulative_fanhuan_user`;

CREATE TABLE `fa_bbfx_cumulative_fanhuan_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `total` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '返还总额',
  `surplus` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '剩余返还',
  `sdate` date DEFAULT NULL COMMENT '上次返还日期',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_deposit_release`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_deposit_release`;

CREATE TABLE `fa_bbfx_deposit_release` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=开启,0=关闭',
  `release_score` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '释放积分',
  `release_balance` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '释放余额',
  `release_currency` varchar(255) DEFAULT NULL COMMENT '释放币种',
  `release_limit` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '释放额度',
  `release_time_type` int(10) NOT NULL DEFAULT '1' COMMENT '释放时间类型:1=每月,2=每天',
  `release_month` varchar(100) NOT NULL DEFAULT '2024-09' COMMENT '释放月份',
  `deposit_paytype` varchar(255) DEFAULT NULL COMMENT '预存款支付方式',
  `withdrawal` text COMMENT '提现设置',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_deposit_release_order`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_deposit_release_order`;

CREATE TABLE `fa_bbfx_deposit_release_order` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `order_no` varchar(100) DEFAULT NULL COMMENT '订单编号',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `money` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '存款金额',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:0=待支付,1=已支付',
  `paytype` int(10) NOT NULL DEFAULT '0' COMMENT '支付类型:1=微信支付,2=余额支付',
  `paytime` int(11) NOT NULL DEFAULT '0' COMMENT '支付时间',
  `one_share` int(10) NOT NULL DEFAULT '0',
  `two_share` int(10) NOT NULL DEFAULT '0',
  `three_share` int(10) NOT NULL DEFAULT '0',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_directpush_team`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_directpush_team`;

CREATE TABLE `fa_bbfx_directpush_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=开启,0=关闭',
  `show_month_commission` int(10) NOT NULL DEFAULT '0' COMMENT '显示本月收益',
  `rule` text COMMENT '奖金规则',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_diypage`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_diypage`;

CREATE TABLE `fa_bbfx_diypage` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) NOT NULL DEFAULT '0',
  `title` varchar(20) DEFAULT NULL COMMENT '页面标题',
  `data` longtext COMMENT '页面配置',
  `type` int(10) NOT NULL DEFAULT '1' COMMENT '页面类型:1=自定义页面,2=个人中心',
  `default_status` int(10) NOT NULL DEFAULT '0' COMMENT '默认状态:1=是(默认首页，默认个人中心),0=否',
  `access_permissions_levels` text COMMENT '访问权限等级',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=59 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_bbfx_diypage_template`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_diypage_template`;

CREATE TABLE `fa_bbfx_diypage_template` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `title` varchar(100) DEFAULT NULL COMMENT '模板',
  `image` varchar(255) DEFAULT NULL COMMENT '图片',
  `data` longtext COMMENT '数据',
  `type` int(10) NOT NULL DEFAULT '1' COMMENT '页面类型:1=自定义页面,2=个人中心',
  `createtime` bigint(16) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_double_track`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_double_track`;

CREATE TABLE `fa_bbfx_double_track` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=开启,0=关闭',
  `num` int(10) unsigned NOT NULL DEFAULT '2' COMMENT '双轨模式人数',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_bbfx_double_track_level`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_double_track_level`;

CREATE TABLE `fa_bbfx_double_track_level` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `name` varchar(100) NOT NULL COMMENT '等级名称',
  `management_reward` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '管理奖',
  `big_market_achievement` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '大市场业绩',
  `small_market_achievement` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '小市场业绩',
  `level` int(10) NOT NULL DEFAULT '0' COMMENT '等级排序',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_bbfx_dynamic_redpacket`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_dynamic_redpacket`;

CREATE TABLE `fa_bbfx_dynamic_redpacket` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=开启,0=关闭',
  `rucang_redpacket_rate` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '入仓红包比例',
  `rucang_money` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '仓内总资金',
  `price_bridge` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '价格桥',
  `black_box` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '黑匣子',
  `redpacket_part` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '红包总份数',
  `calculate_order_status` int(10) NOT NULL DEFAULT '1' COMMENT '计算时间:1=订单付款后,2=订单完成后',
  `chucang_redpacket_price` int(10) NOT NULL DEFAULT '0' COMMENT '出仓红包实时价格',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COMMENT='动态红包配置';

-- ----------------------------
-- Table structure for `fa_bbfx_dynamic_redpacket_sequence`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_dynamic_redpacket_sequence`;

CREATE TABLE `fa_bbfx_dynamic_redpacket_sequence` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `rucang_redpacket_money` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '入仓红包金额',
  `rucang_money` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '仓内总资金',
  `price_bridge` decimal(12,4) unsigned NOT NULL DEFAULT '0.0000' COMMENT '价格桥',
  `redpacket_part` decimal(12,4) unsigned NOT NULL DEFAULT '0.0000' COMMENT '仓内红包总份数',
  `black_box` decimal(12,4) unsigned NOT NULL DEFAULT '0.0000' COMMENT '黑匣子',
  `redpacket_realtime_price` decimal(12,4) unsigned NOT NULL DEFAULT '0.0000' COMMENT '红包实时价格',
  `property_part` decimal(12,4) unsigned NOT NULL DEFAULT '0.0000' COMMENT '资产总份数',
  `dividend_money` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '分出资产总金额',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:0=进行中,1=已完成',
  `completetime` int(11) NOT NULL DEFAULT '0' COMMENT '完成时间',
  `updatetime` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_dynamic_redpacket_sequence_item`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_dynamic_redpacket_sequence_item`;

CREATE TABLE `fa_bbfx_dynamic_redpacket_sequence_item` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `order_id` int(10) NOT NULL DEFAULT '0' COMMENT '订单ID',
  `pid` int(10) NOT NULL DEFAULT '0',
  `rucang_redpacket_money` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '入仓红包金额	',
  `rucang_money` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '仓内总资金',
  `price_bridge` decimal(12,4) unsigned NOT NULL DEFAULT '0.0000' COMMENT '价格桥',
  `redpacket_part` decimal(12,4) unsigned NOT NULL DEFAULT '0.0000' COMMENT '仓内红包总份数',
  `black_box` decimal(12,4) unsigned NOT NULL DEFAULT '0.0000' COMMENT '黑匣子',
  `redpacket_realtime_price` decimal(12,4) unsigned NOT NULL DEFAULT '0.0000' COMMENT '红包实时价格',
  `user_redpacket_part` decimal(12,4) unsigned NOT NULL DEFAULT '0.0000' COMMENT '用户拥有红包份数',
  `user_property_part` decimal(12,4) unsigned NOT NULL DEFAULT '0.0000' COMMENT '用户资产份数',
  `user_dividend_money` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '用户资产本轮红利',
  `money` decimal(10,4) unsigned NOT NULL DEFAULT '0.0000' COMMENT '用户可提现红包金额',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:0=待发放,1=已发放',
  `completetime` int(11) NOT NULL DEFAULT '0',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_express`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_express`;

CREATE TABLE `fa_bbfx_express` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `name` varchar(50) DEFAULT '',
  `express` varchar(50) DEFAULT '',
  `status` tinyint(1) DEFAULT '1',
  `sort` int(10) unsigned DEFAULT '0',
  `code` varchar(30) DEFAULT '',
  `coding` varchar(10) DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=107 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_bbfx_feedback`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_feedback`;

CREATE TABLE `fa_bbfx_feedback` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `content` varchar(1000) DEFAULT NULL COMMENT '反馈内容',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:0=待处理,1=已处理',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_bbfx_fenxiao`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_fenxiao`;

CREATE TABLE `fa_bbfx_fenxiao` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(11) NOT NULL,
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=开启,0=关闭',
  `level` int(10) NOT NULL DEFAULT '0' COMMENT '分销层级:0=不开启,1=一级分销,2=二级分销,3=三级分销',
  `is_selfbuy` int(10) NOT NULL DEFAULT '0' COMMENT '分销内购:1=开启,0=关闭',
  `commission_received_type` int(10) NOT NULL DEFAULT '1' COMMENT '佣金到账:1=订单付款后到账,2=订单完成后到账',
  `become_agent` int(10) NOT NULL DEFAULT '0' COMMENT '成为分销商条件:0=无条件,1=购买商品,2=消费金额,3=单笔消费',
  `become_purchase_money` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '分销商条件消费金额',
  `become_goods` text COMMENT '分销商条件购买商品',
  `become_card` int(10) NOT NULL DEFAULT '0' COMMENT '成为分销商条件会员卡',
  `become_order_type` int(10) NOT NULL DEFAULT '1' COMMENT '消费条件统计的方式:1=订单付款后,2=订单完成后,3=过售后期后',
  `withdrawal_type` text COMMENT '提现方式:1=提现到系统余额,2=提现到微信零钱,3=手动提现到支付宝,4=手动提现到银行卡',
  `withdrawal_wxtype` int(10) NOT NULL DEFAULT '1' COMMENT '付款方式:1=商家转账到零钱,2=企业付款到零钱',
  `service_charge` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '提现手续费',
  `withdrawal_limit` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '提现额度',
  `max_withdrawal` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '最高提现',
  `withdrawal_balance_check` int(10) NOT NULL DEFAULT '0' COMMENT '提现到余额审核:0=关闭,1=开启',
  `withdrawal_balance_score_free` int(10) NOT NULL DEFAULT '0' COMMENT '提现到积分余额免手续费:1=开启,0=关闭',
  `withdrawal_integer_multiple` int(10) NOT NULL DEFAULT '0' COMMENT '提现限制倍数',
  `bank` text COMMENT '提现银行',
  `transfer_mode` int(10) NOT NULL DEFAULT '0' COMMENT '转移模式(x+1):1=开启,0=关闭',
  `transfer_num` int(10) unsigned NOT NULL DEFAULT '3' COMMENT '转移人数',
  `transfer_mode_pinji` int(10) NOT NULL DEFAULT '0' COMMENT '2+1平级奖计算:0=当前关系计算,1=原始关系计算',
  `is_jicha` int(10) NOT NULL DEFAULT '0' COMMENT '级差奖:1=开启,0=关闭',
  `is_jiandan` int(10) NOT NULL DEFAULT '0' COMMENT '见单奖:1=开启,0=关闭',
  `is_jiandan_jicha` int(10) NOT NULL DEFAULT '0' COMMENT '见单奖级差:1=开启,0=关闭',
  `is_jiandan_interval` int(10) NOT NULL DEFAULT '0' COMMENT '间隔直推:1=开启,0=关闭',
  `is_pingji` int(10) NOT NULL DEFAULT '0' COMMENT '平级奖:1=开启,0=关闭',
  `is_abonus` int(10) NOT NULL DEFAULT '0' COMMENT '加权分红:1=开启,0=关闭',
  `is_abonus_gld` int(10) NOT NULL DEFAULT '0' COMMENT '高等级拿低等级:1=开启,0=关',
  `is_repurchase` int(10) NOT NULL DEFAULT '0' COMMENT '复购奖:1=开启,0=关闭',
  `repurchase_mode` int(10) NOT NULL DEFAULT '0' COMMENT '复购奖模式:0=普通模式,1=下单扣除',
  `is_repurchase_pingji` int(10) NOT NULL DEFAULT '0' COMMENT '复购平级奖:1=开启,0=关闭',
  `repurchase_pingji_layer` int(10) NOT NULL DEFAULT '3' COMMENT '复购平级奖层数',
  `pingji_calculate` int(10) NOT NULL DEFAULT '2' COMMENT '平级奖计算方式:1=订单金额百分比,2=用户收入百分比',
  `pingji_layer` int(10) unsigned NOT NULL DEFAULT '1' COMMENT '平级奖代数',
  `pingji_type` int(10) NOT NULL DEFAULT '0' COMMENT '平级奖类型:0=普通平级,1=下单平级',
  `up_method` int(10) NOT NULL DEFAULT '1' COMMENT '升级方式:1=单条件满足升级,2=多条件满足升级',
  `up_type` text COMMENT '升级条件',
  `dand_up` int(10) NOT NULL DEFAULT '0' COMMENT '购买商品单独升级:1=开启,0=关闭',
  `default_level` text COMMENT '默认等级',
  `texts` text COMMENT '文字替换',
  `calculate_type` int(10) NOT NULL DEFAULT '1' COMMENT '佣金计算:1=实付金额,2=订单原价',
  `settlement_type` int(10) NOT NULL DEFAULT '1' COMMENT '收益结算:1=结算到佣金,2=结算到余额',
  `abonus_rule` int(10) NOT NULL DEFAULT '1' COMMENT '分红规则:1=商品分红,2=订单分红',
  `abonus` text,
  `selfbuy_achievement` int(10) NOT NULL DEFAULT '0' COMMENT '自购业绩:1=开启,0=关闭',
  `become_team_achievement` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '分销商条件团队业绩',
  `freeze_money` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '2+1冻结收益',
  `is_management` int(10) NOT NULL DEFAULT '0' COMMENT '管理奖:1=开启,0=关闭',
  `is_management_assistant_reward` int(10) NOT NULL DEFAULT '0' COMMENT '管理奖辅助奖:1=开启,0=关闭',
  `management_type` int(10) NOT NULL DEFAULT '2' COMMENT '管理奖类型:1=跟随等级,2=单独计算',
  `management_reward` text COMMENT '管理奖配置',
  `management_jisuan` int(10) NOT NULL DEFAULT '1' COMMENT '管理奖计算方式:1=逐级减,2=直推减',
  `management_remove_daqu` int(10) NOT NULL DEFAULT '0' COMMENT '去除大区业绩:1=开启,0=关闭',
  `management_jiesuan_day` int(10) unsigned NOT NULL DEFAULT '1' COMMENT '管理奖结算日',
  `yies_mode` int(10) NOT NULL DEFAULT '0' COMMENT '321模式:1=开启:0=关闭',
  `yies_mode_pingji` int(10) NOT NULL DEFAULT '0' COMMENT '平级奖计算:0=当前关系计算,1=原始关系计算',
  `oper` int(10) unsigned NOT NULL DEFAULT '1',
  `fenzhang_status` int(10) NOT NULL DEFAULT '0' COMMENT '佣金分账:1=开启,0=关闭',
  `fenzhang_rate` int(10) unsigned NOT NULL DEFAULT '30' COMMENT '分账比例(最大30%)',
  `settlement_abonus_stype` int(10) NOT NULL DEFAULT '0' COMMENT '分红结算类型:0=立即发放,1=日结周发',
  `is_repurchase_gold` int(10) NOT NULL DEFAULT '0' COMMENT '复购金:1=开启,0=关闭',
  `repurchase_gold` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '复购金比例',
  `is_ladder_abonus` int(10) NOT NULL DEFAULT '0' COMMENT '阶梯分红:1=开启,0=关闭',
  `is_ladder_abonus_gld` int(10) NOT NULL DEFAULT '0' COMMENT '高等级参与低等级分红:1=开启,0=关闭',
  `ladder_abonus` text COMMENT '阶梯分红配置',
  `ladder_abonus_mode` int(10) NOT NULL DEFAULT '1' COMMENT '分红模式:1=统一分红,2=多组分红',
  `ladder_abonus_multiple` text COMMENT '多组分红配置',
  `is_ladder_push` int(10) NOT NULL DEFAULT '0' COMMENT '阶梯直推:1=开启,0=关闭',
  `is_ladder_push_loop` int(10) NOT NULL DEFAULT '0' COMMENT '阶梯循环:1=开启,0=关闭',
  `is_appoint` int(10) NOT NULL DEFAULT '0' COMMENT '指定奖:1=开启,0=关闭',
  `appoint` text COMMENT '指定奖配置',
  `is_directpush_achievement` int(10) NOT NULL DEFAULT '0' COMMENT '直推业绩奖:1=开启,0=关闭',
  `directpush_achievement` text COMMENT '直推业绩奖配置',
  `is_directpush_jiandan` int(10) NOT NULL DEFAULT '0' COMMENT '直推见单奖:1=开启,0=关闭',
  `directpush_jiandan` text COMMENT '直推见单奖配置',
  `is_below` int(10) NOT NULL DEFAULT '0' COMMENT '下二代奖:1=开启,0=关闭',
  `below` text COMMENT '下二代奖配置',
  `is_team_building` int(10) NOT NULL DEFAULT '0' COMMENT '团建奖:1=开启,0=关闭',
  `team_building` text COMMENT '团建奖配置',
  `is_strikeout` int(10) NOT NULL DEFAULT '0' COMMENT '出局设置:1=开启,0=关闭',
  `show_month_commission` int(10) NOT NULL DEFAULT '0' COMMENT '显示本月管理奖:1=是,0=否',
  `is_rebind` int(10) NOT NULL DEFAULT '0' COMMENT '重新绑定关系:1=开启,0=关闭',
  `rebind_day` int(10) NOT NULL DEFAULT '0' COMMENT 'x天未消费解除绑定',
  `user_shenhe_apply` int(10) NOT NULL DEFAULT '0' COMMENT '用户审核升级申请:1=开启,0=,关闭',
  `is_jiandan_pingji` int(10) NOT NULL DEFAULT '0' COMMENT '见单平级:1=开启,0=关闭',
  `is_deduct_daquachievement` int(10) NOT NULL DEFAULT '0' COMMENT '扣除大区业绩:1=开启,0=关闭',
  `jiandan_level` int(10) NOT NULL DEFAULT '0' COMMENT '见单奖层级',
  `is_withdrawal_limit` int(10) NOT NULL DEFAULT '0' COMMENT '提现限制:1=开启,0=关闭',
  `ordinary_user_share` int(10) NOT NULL DEFAULT '0' COMMENT '普通用户分享:0=关闭,1=绑定自己,2=绑定上级分销商',
  `jiandan` text COMMENT '见单业绩',
  `withdrawal_limit_amount` int(10) NOT NULL DEFAULT '0' COMMENT '提现限制金额',
  `withdrawal_unlimit_buygoods` varchar(255) DEFAULT NULL COMMENT '激活提现购买商品',
  `withdrawal_unlimit_order` int(10) NOT NULL DEFAULT '0' COMMENT '解除限制单数',
  `pingji_reward_num` int(10) NOT NULL DEFAULT '0' COMMENT '平级奖获得人数',
  `settlement_score` int(10) NOT NULL DEFAULT '0' COMMENT '结算积分奖励',
  `settlement_score_rate` int(10) NOT NULL DEFAULT '0' COMMENT '结算积分比例',
  `sup_user_buyorder` int(10) NOT NULL DEFAULT '0' COMMENT '有推荐人下单:1=开启,0=关闭',
  `is_ladder_abonus_pingji` int(10) NOT NULL DEFAULT '0' COMMENT '阶梯分红平级奖:1=开启,0=关闭',
  `ladder_abonus_pingji_rate` int(10) NOT NULL DEFAULT '0' COMMENT '阶梯分红平级平级奖比例',
  `score_achievement` int(10) NOT NULL DEFAULT '0' COMMENT '积分业绩:1=开启,0=关闭',
  `become_cz_balance` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '分销商条件充值余额',
  `level_jicha` int(10) NOT NULL DEFAULT '0' COMMENT '层级级差:1=开启,0=关闭',
  `is_becomedue` int(10) NOT NULL DEFAULT '0' COMMENT '分销商到期:1=开启,0=关闭',
  `is_mergelevel` int(10) NOT NULL DEFAULT '0' COMMENT '合并等级:1=开启,0=关闭',
  `is_abonus_out_amount` int(10) NOT NULL DEFAULT '0' COMMENT '分红出局金额:1=开启,0=关闭',
  `sup_uid_show` int(10) NOT NULL DEFAULT '0' COMMENT '上级ID显示:1=是,0=否',
  `transfer_mode_type` int(10) NOT NULL DEFAULT '0' COMMENT '2+1模式类型:0=普通升级,2=自由升级',
  `achievement_jisuan` int(10) NOT NULL DEFAULT '0' COMMENT '业绩计算方式:0=当前关系,1=原始关系',
  `fund_money` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '发展基金',
  `unlock_fund_num` int(10) NOT NULL DEFAULT '0' COMMENT '解锁发展金额人数',
  `tx_date_limit` varchar(500) DEFAULT NULL COMMENT '提现日期限制',
  `wexin_tx_check` int(10) NOT NULL DEFAULT '0' COMMENT '微信提现免审:1=开启,0=关闭',
  `wexin_tx_check_max` int(10) NOT NULL DEFAULT '0' COMMENT '微信提现免审额度',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_bbfx_fenxiao_abonus_item`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_fenxiao_abonus_item`;

CREATE TABLE `fa_bbfx_fenxiao_abonus_item` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `order_id` int(10) NOT NULL DEFAULT '0' COMMENT '订单ID',
  `total` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '分红总额',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:0=返还中,1=已完成',
  `sdate` date DEFAULT NULL COMMENT '开始日期',
  `info` text COMMENT '订单信息',
  `rule_id` int(10) NOT NULL DEFAULT '0' COMMENT '分红规则ID',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_id` (`order_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_bbfx_fenxiao_abonus_rule`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_fenxiao_abonus_rule`;

CREATE TABLE `fa_bbfx_fenxiao_abonus_rule` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `name` varchar(100) DEFAULT NULL COMMENT '等级名称',
  `single_purchase_money` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '单笔消费金额',
  `return_rate` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '返还比例',
  `abonus_rate` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '分红比例',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniacid` (`uniacid`,`single_purchase_money`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_bbfx_fenxiao_apply`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_fenxiao_apply`;

CREATE TABLE `fa_bbfx_fenxiao_apply` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `sh_user_id` int(10) NOT NULL DEFAULT '0' COMMENT '审核用户',
  `realname` varchar(100) DEFAULT NULL COMMENT '用户姓名',
  `mobile` varchar(100) DEFAULT NULL COMMENT '用户手机号',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:0=待审核,1=通过,2=拒绝',
  `level` int(10) NOT NULL DEFAULT '0',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_bbfx_fenxiao_commission`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_fenxiao_commission`;

CREATE TABLE `fa_bbfx_fenxiao_commission` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(11) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `user_id` int(11) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `money` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '变动佣金',
  `befores` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '变动前',
  `afters` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '变动后',
  `remarks` varchar(255) DEFAULT NULL COMMENT '备注',
  `info` text,
  `type` int(10) NOT NULL DEFAULT '0' COMMENT '类型(同分销订单类型)  20 佣金提现  21 拒绝提现',
  `pid` int(10) NOT NULL DEFAULT '0' COMMENT '分销订单',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=907 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_bbfx_fenxiao_level`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_fenxiao_level`;

CREATE TABLE `fa_bbfx_fenxiao_level` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `title` varchar(20) DEFAULT NULL,
  `commission1` decimal(10,0) unsigned NOT NULL DEFAULT '0' COMMENT '一级佣金',
  `commission2` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '二级佣金',
  `commission3` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '三级佣金',
  `commission1_score` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '一级积分',
  `commission2_score` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '二级积分',
  `commission3_score` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '三级积分',
  `level` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '等级',
  `conditions` text COMMENT '升级条件',
  `jc_reward` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '级差奖',
  `jd_reward` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '见单奖',
  `pj_reward` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '平级奖',
  `ab_reward` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '加权分红',
  `pj_reward_layer` text COMMENT '平级奖',
  `repurchase_reward1` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '一级复购奖',
  `repurchase_reward2` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '二级复购奖',
  `repurchase_reward3` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '三级复购奖',
  `is_jiandan` int(10) NOT NULL DEFAULT '0' COMMENT '1 开启见单奖',
  `is_jicha` int(10) NOT NULL DEFAULT '0' COMMENT '1 开启级差奖',
  `is_pingji` int(10) NOT NULL DEFAULT '0' COMMENT '1 开启平级奖',
  `is_abonus` int(10) NOT NULL DEFAULT '0' COMMENT '1 开启加权分红',
  `is_management` int(10) NOT NULL DEFAULT '0' COMMENT '管理奖:1=开启,0=关闭',
  `is_repurchase_pingji` int(10) NOT NULL DEFAULT '0' COMMENT '复购平均奖:1=开启,0=关闭',
  `repurchase_pingji_reward` text NOT NULL COMMENT '复购平级奖',
  `management_reward` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '管理奖配置',
  `management_assistant_reward` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '管理奖辅助奖',
  `thumb` varchar(255) DEFAULT NULL COMMENT '图标',
  `discount` decimal(10,2) unsigned NOT NULL DEFAULT '10.00' COMMENT '会员折扣',
  `description` longtext COMMENT '等级说明',
  `cloud_warehouse_stock` int(10) NOT NULL DEFAULT '0' COMMENT '云仓封顶库存',
  `strikeout_multiple` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '出局倍数',
  `user_shenhe_apply` int(10) NOT NULL DEFAULT '0' COMMENT '用户申请升级审核:1=开启,0=关闭',
  `jd_pingji_reward` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '见单平级',
  `is_chaoyue` int(10) NOT NULL DEFAULT '0' COMMENT '超越奖:1=开启,0=关闭',
  `cy_reward` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '超越奖',
  `is_npingji` int(10) NOT NULL DEFAULT '0' COMMENT '内缩平级奖:1=开启,0=关闭',
  `npingji_reward` int(10) DEFAULT '0' COMMENT '内缩平级奖',
  `becomedue_time` int(10) NOT NULL DEFAULT '0' COMMENT '分销商到期时间（月）',
  `abonus_out_amount` decimal(12,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '分红出局金额',
  `laddermanage_assistant_reward` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '阶梯管理奖辅助奖',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_bbfx_fenxiao_order`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_fenxiao_order`;

CREATE TABLE `fa_bbfx_fenxiao_order` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `money` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '佣金',
  `level` int(10) NOT NULL DEFAULT '0' COMMENT '分销等级',
  `type` int(10) NOT NULL DEFAULT '0' COMMENT '佣金类型:1=一级佣金,2=二级佣金,3=三级佣金,4=级差奖,5=见单奖,6=平级奖,7=加权分红(规则1),8=总分红(规则1,3),9=总分红(规则2,3),10=加权分红,11=代理佣金,12=加权分红(规则3贡献分红),13=总分红(规则3贡献分红)',
  `order_type` int(10) NOT NULL DEFAULT '0' COMMENT '订单类型:0=普通商品订单,1=会员卡订单,2=预存款订单',
  `money_type` int(10) NOT NULL DEFAULT '3' COMMENT '金额类型:1=余额,2=积分,3=佣金',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:-1=已失效(退款),0=待结算(待支付),1=已结算(已支付)',
  `order_id` int(10) NOT NULL DEFAULT '0' COMMENT '订单ID',
  `og_id` int(10) NOT NULL DEFAULT '0' COMMENT '订单商品ID',
  `goods_id` int(10) NOT NULL DEFAULT '0' COMMENT '商品ID',
  `xd_uid` int(10) NOT NULL DEFAULT '0' COMMENT '下单用户',
  `abonus_pid` int(10) NOT NULL DEFAULT '0' COMMENT '分红ID',
  `abonus_item_pid` int(10) NOT NULL DEFAULT '0' COMMENT '加权分红规则2有效',
  `agent_level` int(10) NOT NULL DEFAULT '0' COMMENT '代理级别:1=省级,2=市级,3=区级,4=街道',
  `layer` int(10) NOT NULL DEFAULT '0' COMMENT '层数',
  `extend` text COMMENT '扩展参数',
  `is_daozhang` int(10) NOT NULL DEFAULT '1' COMMENT '是否到账:1=是,0=否',
  `dztime` int(11) NOT NULL DEFAULT '0' COMMENT '到账时间',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7482 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_bbfx_fenxiao_poster`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_fenxiao_poster`;

CREATE TABLE `fa_bbfx_fenxiao_poster` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '商品ID',
  `name` varchar(100) DEFAULT NULL COMMENT '海报名称',
  `content` text COMMENT '海报内容',
  `jump_type` int(10) NOT NULL DEFAULT '0' COMMENT '海报跳转类型:0=首页,1=注册页',
  `status` int(10) NOT NULL DEFAULT '1' COMMENT '状态:1=正常,0=禁用',
  `sort` int(10) NOT NULL DEFAULT '0' COMMENT '排序',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_bbfx_fenxiao_upgrade_record`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_fenxiao_upgrade_record`;

CREATE TABLE `fa_bbfx_fenxiao_upgrade_record` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `sup_uid` int(10) NOT NULL DEFAULT '0' COMMENT '推荐人',
  `type` int(10) NOT NULL DEFAULT '0' COMMENT '升级类型:0=自动升级,1=后台升级,2=申请升级,3=指定升级,4=超级人脉模式指定升级',
  `before_level` int(10) NOT NULL DEFAULT '-1' COMMENT '以前等级',
  `level` int(10) NOT NULL DEFAULT '0' COMMENT '升级等级',
  `sup_level` int(10) NOT NULL DEFAULT '0' COMMENT '推荐人等级',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=244 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_fenxiaoscore`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_fenxiaoscore`;

CREATE TABLE `fa_bbfx_fenxiaoscore` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=开启,0=关闭',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_form`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_form`;

CREATE TABLE `fa_bbfx_form` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `title` varchar(100) DEFAULT NULL COMMENT '标题',
  `image` varchar(255) DEFAULT NULL COMMENT '图片',
  `content` text COMMENT '内容',
  `is_repeat` int(10) NOT NULL DEFAULT '0' COMMENT '重复提交:1=开启,0=关闭',
  `status` int(10) NOT NULL DEFAULT '1' COMMENT '状态:1=正常,0=禁用',
  `createtime` bigint(16) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_form_record`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_form_record`;

CREATE TABLE `fa_bbfx_form_record` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `form_id` int(10) NOT NULL DEFAULT '0' COMMENT '表单ID',
  `content` text COMMENT '表单内容',
  `info` text COMMENT '表单内容',
  `createtime` bigint(16) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_form_set`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_form_set`;

CREATE TABLE `fa_bbfx_form_set` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=开启,0=关闭',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=222 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_gift`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_gift`;

CREATE TABLE `fa_bbfx_gift` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=开启,0=关闭',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_goods`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_goods`;

CREATE TABLE `fa_bbfx_goods` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `mid` int(10) NOT NULL DEFAULT '0' COMMENT '商户ID',
  `title` varchar(100) DEFAULT NULL COMMENT '商品名称',
  `subtitle` varchar(255) DEFAULT NULL COMMENT '商品副标题',
  `thumb` varchar(255) DEFAULT NULL COMMENT '商品图',
  `price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '价格',
  `stock` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '库存',
  `status` int(10) NOT NULL DEFAULT '1' COMMENT '状态:1=上架,0=下架',
  `type` int(10) NOT NULL DEFAULT '1' COMMENT '商品类型:1=卡密商品,2=实体商品,3=核销商品,4=虚拟商品',
  `is_spec` int(10) NOT NULL DEFAULT '0' COMMENT '规格:1=开启,0=关闭',
  `is_recommend` int(10) NOT NULL DEFAULT '0' COMMENT '推荐:1=开启,0=关闭',
  `is_new` int(10) NOT NULL DEFAULT '0' COMMENT '新品:1=开启,0=关闭',
  `is_hot` int(10) NOT NULL DEFAULT '0' COMMENT '热卖	:1=开启,0=关闭',
  `is_nodiscount` int(10) NOT NULL DEFAULT '0' COMMENT '不参与会员折扣:1=是,0=否',
  `sort` int(10) NOT NULL DEFAULT '0' COMMENT '排序',
  `share_title` varchar(20) DEFAULT NULL COMMENT '分享标题',
  `share_desc` varchar(200) DEFAULT NULL COMMENT '分享描述',
  `share_img` varchar(200) DEFAULT NULL COMMENT '分享图片',
  `o_price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '原价',
  `minbuy` int(10) unsigned NOT NULL DEFAULT '1' COMMENT '单次最低购买',
  `maxbuy` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '单次最多购买',
  `total_maxbuy` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户总购买次数',
  `levels` varchar(255) DEFAULT NULL COMMENT '购买等级',
  `express_fee` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '快递费',
  `stock_type` int(10) NOT NULL DEFAULT '1' COMMENT '库存设置:1=拍下减库存,2=付款减库存,3=永不减库存',
  `slides` text COMMENT '商品幻灯',
  `videos` text COMMENT '商品视频',
  `content` text COMMENT '商品详情',
  `unit` varchar(20) NOT NULL DEFAULT '件' COMMENT '单位',
  `sales_volume` int(10) unsigned NOT NULL DEFAULT '0',
  `is_fenxiao` int(10) NOT NULL DEFAULT '1' COMMENT '分销功能:1=开启,0=关闭',
  `commission_rule` int(10) NOT NULL DEFAULT '0' COMMENT '分销规则:0=不开启,1=统一佣金,2=详细佣金',
  `commission1` text COMMENT '一级佣金配置',
  `commission2` text COMMENT '二级佣金配置',
  `commission3` text COMMENT '三级佣金配置',
  `is_jicha_rule` int(10) NOT NULL DEFAULT '0' COMMENT '独立级差奖:1=开启,0=关闭',
  `is_jiandan_rule` int(10) NOT NULL DEFAULT '0' COMMENT '独立见单奖:1=开启,0=关闭',
  `is_pingji_rule` int(10) NOT NULL DEFAULT '0' COMMENT '独立平级奖:1=开启,0=关闭',
  `is_abonus` int(10) NOT NULL DEFAULT '1' COMMENT '加权分红:1=开启,0=关闭',
  `is_abonus_rule` int(10) NOT NULL DEFAULT '0' COMMENT '独立分红配置:1=开启,0=关闭',
  `is_repurchase` int(10) NOT NULL DEFAULT '1' COMMENT '复购奖:1=开启,0=关闭',
  `is_repurchase_rule` int(10) NOT NULL DEFAULT '0' COMMENT '复购奖独立配置:0=关闭,1=统一佣金,2=详细佣金',
  `is_repurchase_pingji` int(10) NOT NULL DEFAULT '1' COMMENT '复购平级奖:1=开启,0=关闭',
  `is_repurchase_pingji_rule` int(10) NOT NULL DEFAULT '0' COMMENT '复购平级奖独立规则:0=不开启,1=统一佣金,2=详细佣金',
  `jc_reward` text COMMENT '级差奖配置',
  `jd_reward` text COMMENT '见单奖配置',
  `pj_reward` text COMMENT '平级奖配置',
  `ab_reward` text COMMENT '加权分红配置',
  `repurchase_reward1` text COMMENT '一级复购奖',
  `repurchase_reward2` text COMMENT '二级复购奖',
  `repurchase_reward3` text COMMENT '三级复购奖',
  `repurchase_pingji_reward` text COMMENT '复购平级奖配置',
  `upgrade_score` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '分销积分(用户分销等级升级)',
  `is_leveldiscount_rule` int(10) NOT NULL DEFAULT '0' COMMENT '商品独立会员折扣:1=开启,0=关闭',
  `level_discount` text COMMENT '会员折扣',
  `is_return` int(10) NOT NULL DEFAULT '1' COMMENT '返还奖:1=开启,0=关闭',
  `is_return_rule` int(10) NOT NULL DEFAULT '0' COMMENT '返还奖独立规则:1=开启,0=关闭',
  `returns` text COMMENT '返还配置',
  `is_agent` int(10) NOT NULL DEFAULT '1' COMMENT '区域代理:1=开启,0=关闭',
  `agent_rule` int(10) NOT NULL DEFAULT '0' COMMENT '区域代理规则:0=不开启,1=统一佣金,2=详细佣金',
  `agent` text COMMENT '区域代理详细规则',
  `is_give` int(10) NOT NULL DEFAULT '0' COMMENT '复购赠送:1=开启,0=关闭',
  `give_type` int(10) NOT NULL DEFAULT '0' COMMENT '赠送类型:1=赠送余额,2=赠送积分',
  `give` text COMMENT '复购赠送配置',
  `is_contract` int(10) NOT NULL DEFAULT '0' COMMENT '电子合同:1=开启,0=关闭',
  `contract` text COMMENT '电子合同',
  `fastest_delivery` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '最快发货',
  `arrive_day` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '送达天数',
  `express_name` varchar(100) DEFAULT NULL COMMENT '发货快递',
  `vip_free_shipping` int(10) NOT NULL DEFAULT '0' COMMENT '会员包邮:0=关闭,1=开启',
  `guarantee` text COMMENT '购买保障',
  `is_authentic` int(10) NOT NULL DEFAULT '0' COMMENT '正品显示:1=开启,0=关闭',
  `authentic_name` varchar(10) DEFAULT '100%正品' COMMENT '正品名称',
  `authentic_desc` varchar(100) DEFAULT '官方自营·品牌授权·中国人保承保·全链路品控' COMMENT '正品描述',
  `authentic_icon` varchar(255) DEFAULT NULL COMMENT '正品图标',
  `single_column_thumb` varchar(255) DEFAULT '' COMMENT '单列展现',
  `is_cumulative_fanhuan` int(10) NOT NULL DEFAULT '0' COMMENT '累计返还:1=开启,0=关闭',
  `cumulative_fanhuan_rule` int(10) NOT NULL DEFAULT '0' COMMENT '独立规则:0=不开启,1=统一规则,2=详细规则',
  `cumulative_fanhuan` text COMMENT '累计返还配置',
  `cloud_warehouse_rule` int(10) NOT NULL DEFAULT '0' COMMENT '独立规则:0=不开启,1=统一规则,2=详细规则',
  `cloud_warehouse` text COMMENT '云仓商品返还配置',
  `cloud_warehouse_chuhuo` text COMMENT '出货奖励',
  `is_ladder_push` int(10) NOT NULL DEFAULT '0' COMMENT '阶梯直推:1=开启,0=关闭',
  `is_ladder_push_loop` int(10) NOT NULL DEFAULT '1' COMMENT '阶梯循环:1=开启,0=关闭',
  `ladder_push_rule` int(10) NOT NULL DEFAULT '1' COMMENT '独立规则:0=不开启,1=统一规则,2=详细规则',
  `ladder_push` text COMMENT '阶梯直推配置',
  `delivery_method` int(10) NOT NULL DEFAULT '1' COMMENT '配送方式:1=快递配送,2=门店核销,3=快递配送和门店核销',
  `is_hexiao` int(10) NOT NULL DEFAULT '0' COMMENT '门店核销:1=开启,0=关闭',
  `hexiao_num` int(10) unsigned NOT NULL DEFAULT '1' COMMENT '核销次数',
  `hexiao_store_type` int(10) NOT NULL DEFAULT '0' COMMENT '核销门店:0=全部门店,1=指定门店',
  `plugin` longtext COMMENT '应用配置',
  `profit_amount` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '利润金额',
  `daily_buy` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '每日最多购买',
  `monthly_buy` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '每月最多购买',
  `virtual_sale` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '虚拟销量',
  `sh_status` int(10) NOT NULL DEFAULT '1' COMMENT '审核状态:0=待审核,1=通过,2=驳回',
  `sh_time` int(11) NOT NULL DEFAULT '0' COMMENT '审核时间',
  `shippingfee_template_id` int(10) NOT NULL DEFAULT '0' COMMENT '运费模板ID',
  `detail_images` varchar(1000) DEFAULT NULL COMMENT '详情图片',
  `weight` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '重量（kg）',
  `volume` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '体积（m³）',
  `cost_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '成本价',
  `parameter` text COMMENT '商品参数',
  `is_hexiao_quantity` int(10) NOT NULL DEFAULT '0' COMMENT '核销数量:1=开启,0=关闭',
  `buy_btn` varchar(10) DEFAULT NULL COMMENT '购买按钮',
  `hexiao_info_required` int(10) NOT NULL DEFAULT '1' COMMENT '核销信息必填:1=开启,0=关闭',
  `order_user_scroll` int(10) NOT NULL DEFAULT '0' COMMENT '下单用户滚动:1=开启,0=关闭',
  `is_setmeal` int(10) NOT NULL DEFAULT '0' COMMENT '套餐模式:1=开启,0=关闭',
  `score` decimal(10,1) NOT NULL DEFAULT '5.0' COMMENT '评分',
  `updatetime` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=107 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_bbfx_goods_category`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_goods_category`;

CREATE TABLE `fa_bbfx_goods_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(11) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `goods_id` int(11) NOT NULL DEFAULT '0',
  `category_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=104 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_bbfx_goods_comment`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_goods_comment`;

CREATE TABLE `fa_bbfx_goods_comment` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `mid` int(10) NOT NULL DEFAULT '0' COMMENT '商户ID',
  `store_id` int(10) NOT NULL DEFAULT '0' COMMENT '门店ID',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `goods_id` int(10) NOT NULL DEFAULT '0' COMMENT '商品ID',
  `order_id` int(10) NOT NULL DEFAULT '0' COMMENT '订单ID',
  `goods_name` varchar(255) DEFAULT NULL COMMENT '商品名称',
  `content` varchar(500) DEFAULT NULL COMMENT '评论内容',
  `images` text COMMENT '评论图片',
  `score` int(10) NOT NULL DEFAULT '1' COMMENT '评论',
  `sh_status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:0=待审核,1=已通过,2=已拒绝',
  `sh_time` int(11) NOT NULL DEFAULT '0' COMMENT '审核时间',
  `info` text,
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_goods_spec`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_goods_spec`;

CREATE TABLE `fa_bbfx_goods_spec` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `uniacid` int(11) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `goods_id` int(11) NOT NULL DEFAULT '0' COMMENT '商品ID',
  `name` varchar(100) DEFAULT NULL COMMENT '规格名称',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=50 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_bbfx_goods_spec_item`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_goods_spec_item`;

CREATE TABLE `fa_bbfx_goods_spec_item` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `goods_id` int(10) NOT NULL DEFAULT '0' COMMENT '商品ID',
  `pid` int(10) NOT NULL DEFAULT '0' COMMENT '规格ID',
  `name` varchar(100) DEFAULT NULL COMMENT '规格项名称',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=104 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_bbfx_goods_spec_sku`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_goods_spec_sku`;

CREATE TABLE `fa_bbfx_goods_spec_sku` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `goods_id` int(10) NOT NULL DEFAULT '0' COMMENT '商品ID',
  `sku` text COMMENT '规格组合ID',
  `sku_name` text COMMENT '规格组合名称',
  `price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '价格',
  `pintuan_price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '拼团价格',
  `kaituan_price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '开团价',
  `stock` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '库存',
  `thumb` varchar(255) DEFAULT NULL COMMENT '商品图片',
  `original_price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '原价',
  `profit_amount` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '利润金额',
  `weight` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '重量',
  `volume` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '体积',
  `cost_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '成本价',
  `dish` text COMMENT '品相',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=113 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_bbfx_goods_stock_log`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_goods_stock_log`;

CREATE TABLE `fa_bbfx_goods_stock_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL COMMENT '平台ID',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `goods_id` int(10) NOT NULL DEFAULT '0' COMMENT '商品ID',
  `sku_id` int(10) NOT NULL DEFAULT '0' COMMENT '规格ID',
  `type` int(10) NOT NULL DEFAULT '0' COMMENT '用户类型:0=管理员,1=用户',
  `itype` int(10) NOT NULL DEFAULT '0' COMMENT '操作类型',
  `item_id` int(10) NOT NULL DEFAULT '0' COMMENT '关联ID',
  `stock` int(10) NOT NULL DEFAULT '0' COMMENT '变动库存',
  `before` int(10) NOT NULL DEFAULT '0' COMMENT '变动前',
  `after` int(10) NOT NULL DEFAULT '0' COMMENT '变动后',
  `title` varchar(255) DEFAULT NULL COMMENT '标题',
  `remarks` varchar(255) NOT NULL COMMENT '备注',
  `info` text NOT NULL COMMENT '数据',
  `goods` text COMMENT '商品信息',
  `createtime` bigint(16) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=358 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_import_log`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_import_log`;

CREATE TABLE `fa_bbfx_import_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `type` int(10) NOT NULL DEFAULT '0' COMMENT '类型:0=订单物流单号导入,1=会员导入',
  `admin_id` int(10) NOT NULL DEFAULT '0' COMMENT '管理员ID',
  `content` text COMMENT '日志内容',
  `createtime` bigint(16) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_laddermanage`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_laddermanage`;

CREATE TABLE `fa_bbfx_laddermanage` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=开启,0=关闭',
  `show_month_income` int(10) NOT NULL DEFAULT '0' COMMENT '显示本月收益:1=开启,0=关闭',
  `manage_remove_daqu` int(10) NOT NULL DEFAULT '0' COMMENT '去除大区业绩:1=开启,0=关闭',
  `manage_jisuan` int(10) NOT NULL DEFAULT '1' COMMENT '计算方式:1=逐级减,2=直推减',
  `rule` text COMMENT '管理奖规则',
  `is_manage_assistant_reward` int(10) NOT NULL DEFAULT '0' COMMENT '管理辅助奖:1=开启,0=关闭',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_ladderpingji`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_ladderpingji`;

CREATE TABLE `fa_bbfx_ladderpingji` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=开启,0=关闭',
  `condition_type` int(10) NOT NULL DEFAULT '0' COMMENT '条件类型:0=直推指定等级用户,1=直推人数,2=团队人数',
  `reward_source` varchar(1000) DEFAULT NULL COMMENT '奖励来源',
  `rule` text COMMENT '规则',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_leveljicha`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_leveljicha`;

CREATE TABLE `fa_bbfx_leveljicha` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=开启,0=关闭',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_luckywheel`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_luckywheel`;

CREATE TABLE `fa_bbfx_luckywheel` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=开启,0=关闭',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_luckywheel_lottery_record`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_luckywheel_lottery_record`;

CREATE TABLE `fa_bbfx_luckywheel_lottery_record` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `type` int(10) NOT NULL DEFAULT '0' COMMENT '奖品类型',
  `prize_id` int(10) NOT NULL DEFAULT '0' COMMENT '奖品ID',
  `prize` text NOT NULL COMMENT '奖品信息',
  `code` varchar(100) DEFAULT NULL COMMENT '兑换码',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=已兑换,0=待兑换',
  `dhtime` bigint(16) NOT NULL DEFAULT '0' COMMENT '兑换时间',
  `createtime` bigint(16) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_luckywheel_prize`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_luckywheel_prize`;

CREATE TABLE `fa_bbfx_luckywheel_prize` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `type` int(10) NOT NULL DEFAULT '0' COMMENT '奖励类型:0=谢谢参与,1=余额,2=积分,3=商品',
  `image` varchar(255) DEFAULT NULL COMMENT '奖励图片',
  `title` varchar(100) DEFAULT NULL COMMENT '标题',
  `reward` varchar(1000) DEFAULT NULL COMMENT '奖励',
  `probability` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '中奖概率',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=正常,0=禁用',
  `sort` int(10) NOT NULL DEFAULT '0' COMMENT '排序',
  `createtime` bigint(16) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_luckywheel_zhiding`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_luckywheel_zhiding`;

CREATE TABLE `fa_bbfx_luckywheel_zhiding` (
  `id` int(11) NOT NULL DEFAULT '0' COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `prize_id` int(10) NOT NULL DEFAULT '0' COMMENT '奖品ID',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=已抽奖,0=待抽奖',
  `cjtime` bigint(16) NOT NULL DEFAULT '0' COMMENT '抽奖时间',
  `createtime` bigint(16) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_member_card`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_member_card`;

CREATE TABLE `fa_bbfx_member_card` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `name` varchar(100) DEFAULT NULL COMMENT '会员卡名称',
  `give` varchar(255) DEFAULT NULL COMMENT '赠送:1=积分,2=优惠券',
  `give_score` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '赠送积分',
  `give_coupon` text COMMENT '赠送优惠券',
  `style` varchar(255) NOT NULL COMMENT '样式',
  `yx_day` int(10) NOT NULL DEFAULT '10' COMMENT '有效期天数，-1=永久',
  `price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '价格',
  `discount` decimal(10,1) unsigned NOT NULL DEFAULT '10.0' COMMENT '折扣',
  `content` text NOT NULL COMMENT '使用说明',
  `is_fenxiao` int(10) NOT NULL DEFAULT '0' COMMENT '分销状态:1=开启,0=关闭',
  `commission_rule` int(10) NOT NULL DEFAULT '0' COMMENT '分销规则:0=不开启,1=统一佣金,2=详细佣金',
  `commission1` text COMMENT '一级佣金配置',
  `commission2` text COMMENT '二级佣金配置',
  `commission3` text COMMENT '三级佣金配置',
  `status` int(10) NOT NULL DEFAULT '1' COMMENT '状态:1=正常,0=禁用',
  `sort` int(10) NOT NULL DEFAULT '0' COMMENT '排序',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_bbfx_member_card_order`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_member_card_order`;

CREATE TABLE `fa_bbfx_member_card_order` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `order_no` varchar(100) DEFAULT NULL COMMENT '订单号',
  `title` varchar(100) DEFAULT NULL COMMENT '标题',
  `price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '订单金额',
  `member_card_id` int(10) NOT NULL DEFAULT '0' COMMENT '会员卡ID',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '支付状态:1=已支付,0=未支付',
  `paytype` int(10) NOT NULL DEFAULT '0' COMMENT '支付类型',
  `paytime` int(11) NOT NULL DEFAULT '0' COMMENT '支付时间',
  `endtime` int(11) NOT NULL DEFAULT '0' COMMENT '会员卡到期时间，-1永久',
  `one_share` int(10) NOT NULL DEFAULT '0',
  `two_share` int(10) NOT NULL DEFAULT '0',
  `three_share` int(10) NOT NULL DEFAULT '0',
  `info` text COMMENT '会员卡数据',
  `is_fenzhang` int(10) NOT NULL DEFAULT '0' COMMENT '分账:1=开启,0=关闭',
  `sup_path` text COMMENT '推荐路径',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_bbfx_merchant`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_merchant`;

CREATE TABLE `fa_bbfx_merchant` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '绑定用户',
  `sup_uid` int(10) NOT NULL DEFAULT '0' COMMENT '推荐人',
  `category_id` varchar(500) DEFAULT NULL COMMENT '商户分类',
  `name` varchar(100) DEFAULT NULL COMMENT '商户名称',
  `logo` varchar(255) DEFAULT NULL COMMENT '商家logo',
  `realname` varchar(100) DEFAULT NULL COMMENT '联系人',
  `mobile` varchar(100) DEFAULT NULL COMMENT '联系电话',
  `balance` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '余额',
  `balance_total` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '累计余额',
  `province` varchar(100) DEFAULT NULL COMMENT '省份',
  `city` varchar(100) DEFAULT NULL COMMENT '城市',
  `area` varchar(100) DEFAULT NULL COMMENT '区县',
  `address` varchar(100) DEFAULT NULL COMMENT '详细地址',
  `lng` double NOT NULL DEFAULT '0' COMMENT '经度',
  `lat` double NOT NULL DEFAULT '0' COMMENT '纬度',
  `yy_time` varchar(100) DEFAULT NULL COMMENT '营业时间',
  `introduction` varchar(255) DEFAULT NULL COMMENT '门店简介',
  `content` longtext COMMENT '门店介绍',
  `detail_images` text COMMENT '详情图片',
  `images` text COMMENT '门店图片',
  `is_fenxiao` int(10) NOT NULL DEFAULT '0' COMMENT '分销功能:1=开启,0=关闭',
  `commission_rate` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '分润佣金比例',
  `sup_commission` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '推荐佣金比例',
  `yy_status` int(10) NOT NULL DEFAULT '1' COMMENT '营业状态:1=开启,0=关闭',
  `score` decimal(10,1) NOT NULL DEFAULT '5.0' COMMENT '评分',
  `status` int(10) NOT NULL DEFAULT '1' COMMENT '状态:1=正常,0=禁用',
  `is_shenhe` int(10) NOT NULL DEFAULT '0' COMMENT '审核通过:1=是,0=否',
  `sh_status` int(10) NOT NULL DEFAULT '0' COMMENT '审核状态:0=待审核,1=通过,2=驳回',
  `sh_time` int(11) NOT NULL DEFAULT '0' COMMENT '审核时间',
  `sh_data` longtext NOT NULL COMMENT '审核数据',
  `updatetime` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_merchant_category`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_merchant_category`;

CREATE TABLE `fa_bbfx_merchant_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `name` varchar(100) DEFAULT NULL COMMENT '分类名称',
  `image` varchar(255) DEFAULT NULL COMMENT '分类图片',
  `sort` int(10) NOT NULL DEFAULT '0' COMMENT '排序',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_merchant_money_log`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_merchant_money_log`;

CREATE TABLE `fa_bbfx_merchant_money_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) NOT NULL,
  `mid` int(10) NOT NULL DEFAULT '0' COMMENT '门店ID',
  `money` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '变动金额',
  `befores` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '变动前',
  `afters` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '变动后',
  `remarks` varchar(255) NOT NULL COMMENT '备注',
  `info` text NOT NULL COMMENT '数据',
  `type` int(10) NOT NULL DEFAULT '0' COMMENT '金额类型:1=余额',
  `item_type` int(10) NOT NULL DEFAULT '0' COMMENT '操作类型:1=商品订单结算,2=余额提现,3=提现驳回',
  `item_id` varchar(100) NOT NULL COMMENT '项目ID',
  `createtime` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_bbfx_merchant_set`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_merchant_set`;

CREATE TABLE `fa_bbfx_merchant_set` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=开启,0=关闭',
  `apply_status` int(10) NOT NULL DEFAULT '0' COMMENT '商户申请:1=开启,0=关闭',
  `apply_shenhe` int(10) NOT NULL DEFAULT '0' COMMENT '申请审核:1=开启,0=关闭',
  `apply_condition_type` int(10) NOT NULL DEFAULT '0' COMMENT '申请条件:0=无条件,1=购买商品,2=直推指定等级人数,3=直推人数,4=团队人数,5=消费金额',
  `apply_condition` text COMMENT '申请条件',
  `goods_shenhe` int(10) NOT NULL DEFAULT '0' COMMENT '商品审核:1=开启,0=关闭',
  `daozhang_type` int(10) NOT NULL DEFAULT '0' COMMENT '到账时间:0=订单完成后,1=订单过售后期后',
  `is_fenxiao` int(10) NOT NULL DEFAULT '0' COMMENT '分销功能:1=开启,0=关闭',
  `edit_shenhe` int(10) NOT NULL DEFAULT '0' COMMENT '编辑审核:1=开启,0=关闭',
  `edit_goods_shenhe` int(10) NOT NULL DEFAULT '0' COMMENT '编辑商品审核:1=开启,0=关闭',
  `withdrawal` text COMMENT '提现配置',
  `banner` varchar(255) DEFAULT NULL COMMENT '商户banner',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_mergelevel`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_mergelevel`;

CREATE TABLE `fa_bbfx_mergelevel` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=开启,0=关闭',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_mode`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_mode`;

CREATE TABLE `fa_bbfx_mode` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `name` varchar(100) DEFAULT NULL COMMENT '模式名称',
  `sdesc` text COMMENT '模式描述',
  `content` text COMMENT '模式内容',
  `sort` int(10) NOT NULL DEFAULT '0' COMMENT '排序',
  `createtime` bigint(16) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_money_log`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_money_log`;

CREATE TABLE `fa_bbfx_money_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `money` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '变动金额',
  `befores` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '变动前',
  `afters` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '变动后',
  `remarks` varchar(255) NOT NULL COMMENT '备注',
  `info` text COMMENT '数据',
  `type` int(10) NOT NULL DEFAULT '0' COMMENT '金额类型:1=余额,2=积分,3=冻结收益,4=复购金',
  `item_type` int(10) NOT NULL DEFAULT '0' COMMENT '操作类型:1=商品支付,2=积分商品兑换,3=后台充值,4=订单退款,5=余额/积分提现,6=拒绝提现,7=充值余额,8=充值积分,9=佣金提现打款,10=余额/积分返还,11=佣金结算,12=资金转账,21=会员卡赠送,22=收益冻结,23=收益解冻',
  `item_id` varchar(100) DEFAULT NULL COMMENT '项目ID',
  `extend` text COMMENT '附加数据',
  `createtime` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4379 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_bbfx_news_article`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_news_article`;

CREATE TABLE `fa_bbfx_news_article` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `category_id` int(10) NOT NULL DEFAULT '0' COMMENT '分类ID',
  `author` varchar(100) DEFAULT NULL COMMENT '作者',
  `author_avatar` varchar(255) DEFAULT NULL COMMENT '作者头像',
  `title` varchar(100) DEFAULT NULL COMMENT '文章标题',
  `thumb` text COMMENT '文章封面',
  `content` longtext COMMENT '文章内容',
  `link` text COMMENT '文章链接',
  `type` int(10) NOT NULL DEFAULT '1' COMMENT '类型:1=普通文章,2=公众号文章',
  `status` int(10) NOT NULL DEFAULT '1' COMMENT '状态:1=正常,0=禁用',
  `browse` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '浏览量',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_bbfx_news_category`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_news_category`;

CREATE TABLE `fa_bbfx_news_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `type` int(10) NOT NULL DEFAULT '1' COMMENT '类型:1=文章,2=视频',
  `title` varchar(100) NOT NULL COMMENT '分类标题',
  `status` int(10) NOT NULL DEFAULT '1' COMMENT '状态:1=正常,0=禁用',
  `sort` int(10) NOT NULL DEFAULT '0' COMMENT '排序',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_bbfx_news_video`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_news_video`;

CREATE TABLE `fa_bbfx_news_video` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `category_id` int(10) NOT NULL DEFAULT '0' COMMENT '分类ID',
  `title` varchar(100) DEFAULT NULL COMMENT '视频标题',
  `thumb` varchar(255) DEFAULT NULL COMMENT '视频封面',
  `content` text COMMENT '视频链接',
  `link` text COMMENT '视频链接',
  `type` int(10) NOT NULL DEFAULT '1' COMMENT '类型:1=普通视频,2=视频链接',
  `status` int(10) NOT NULL DEFAULT '1' COMMENT '状态:1=正常,0=禁用',
  `browse` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '浏览量',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_bbfx_notice`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_notice`;

CREATE TABLE `fa_bbfx_notice` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `type` int(10) NOT NULL DEFAULT '0' COMMENT '类型:0=系统通知,1=消息推送',
  `itype` int(10) NOT NULL DEFAULT '0' COMMENT '类型',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `title` varchar(255) DEFAULT NULL COMMENT '标题',
  `content` longtext COMMENT '内容',
  `link` varchar(255) DEFAULT NULL COMMENT '跳转链接',
  `is_read` int(10) NOT NULL DEFAULT '0' COMMENT '已读:1=是,0=否',
  `readtime` int(11) NOT NULL DEFAULT '0' COMMENT '阅读时间',
  `extend` text COMMENT '信息',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=948 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_notice_log`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_notice_log`;

CREATE TABLE `fa_bbfx_notice_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `pid` int(10) NOT NULL DEFAULT '0',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_npingji`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_npingji`;

CREATE TABLE `fa_bbfx_npingji` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=开启,0=关闭',
  `layer` int(10) NOT NULL DEFAULT '1' COMMENT '平级奖层数',
  `deduct_direction` int(10) NOT NULL DEFAULT '0' COMMENT '扣除方向:0=向下扣除,1=向上扣除',
  `deduct_item` varchar(255) NOT NULL DEFAULT '1' COMMENT '扣除奖项',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_order`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_order`;

CREATE TABLE `fa_bbfx_order` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) NOT NULL DEFAULT '0',
  `order_no` varchar(100) DEFAULT NULL COMMENT '订单号',
  `user_id` int(10) NOT NULL DEFAULT '0',
  `mid` int(10) NOT NULL DEFAULT '0' COMMENT '商户ID',
  `store_id` int(10) NOT NULL DEFAULT '0' COMMENT '所属门店',
  `order_type` int(11) NOT NULL DEFAULT '1' COMMENT '订单类型:1=虚拟商品(卡密),2=实物商品(快递),3=核销商品,4=虚拟商品(不发货)',
  `user_coupon_id` int(10) NOT NULL DEFAULT '0' COMMENT '优惠券ID',
  `price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '支付金额(商品金额+运费)',
  `profit_amount` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '利润金额',
  `cost_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '成本价',
  `total_price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '订单总金额，未折扣价格(商品金额+运费)',
  `discount_price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '折扣金额',
  `discount_vip_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '会员折扣',
  `discount_coupon_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '优惠券折扣',
  `original_price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '商品原价',
  `repurchase_currency` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '抵扣复购金',
  `balance` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '抵扣余额',
  `paytype` int(10) NOT NULL DEFAULT '1' COMMENT '1 微信支付 2 余额支付 3 分享领取 ',
  `is_pay` int(10) NOT NULL DEFAULT '0' COMMENT '是否支付:0=未支付,1=已支付',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:0=待支付,1=待发货/待核销,2=已发货,3=已完成/已核销,-1=已取消',
  `refund_status` int(10) NOT NULL DEFAULT '-1' COMMENT '退款状态:-1=未退款,0=待审核,1=已退款,2=已拒绝',
  `goods_info` longtext COMMENT '商品信息',
  `express_fee` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '运费',
  `is_hexiao` int(10) NOT NULL DEFAULT '0' COMMENT '核销订单:1=是,0=否',
  `hexiao_realname` varchar(100) DEFAULT NULL COMMENT '用户姓名',
  `hexiao_mobile` varchar(100) DEFAULT NULL COMMENT '用户电话',
  `hexiao_total` int(10) unsigned NOT NULL DEFAULT '1' COMMENT '核销总次数',
  `hexiao_num` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '核销次数',
  `hexiao_uid` int(10) NOT NULL DEFAULT '0' COMMENT '核销用户',
  `hexiao_time` bigint(16) DEFAULT '0' COMMENT '核销时间',
  `hexiao_qrcode` varchar(255) DEFAULT NULL COMMENT '核销二维码',
  `hexiao_code` varchar(20) DEFAULT NULL COMMENT '核销码',
  `hexiao_wxacode` varchar(255) DEFAULT NULL COMMENT '核销小程序码',
  `hexiao_store` text COMMENT '核销门店',
  `delivery_method` int(10) NOT NULL DEFAULT '1' COMMENT '配送方式:1=快递配送,2=门店核销',
  `delivery_username` varchar(50) DEFAULT NULL COMMENT '收货人',
  `delivery_mobile` varchar(20) DEFAULT NULL COMMENT '收货电话',
  `delivery_province` varchar(20) DEFAULT NULL COMMENT '省份',
  `delivery_city` varchar(50) DEFAULT NULL COMMENT '城市',
  `delivery_area` varchar(50) DEFAULT NULL COMMENT '区',
  `delivery_address` varchar(1000) DEFAULT NULL COMMENT '详细地址',
  `delivery_street` varchar(255) DEFAULT NULL,
  `express` text COMMENT '物流信息',
  `deliver_type` int(10) NOT NULL DEFAULT '1' COMMENT '发货类型:1=按订单发货,2=按商品发货,3=自定义发货',
  `deliverytime` int(11) NOT NULL DEFAULT '0' COMMENT '发货时间',
  `pay_time` int(11) NOT NULL DEFAULT '0' COMMENT '支付时间',
  `completetime` int(11) NOT NULL DEFAULT '0' COMMENT '完成时间',
  `one_share` int(11) NOT NULL DEFAULT '0',
  `two_share` int(11) NOT NULL DEFAULT '0',
  `three_share` int(11) NOT NULL DEFAULT '0',
  `remarks` varchar(500) DEFAULT NULL,
  `platform` varchar(100) NOT NULL DEFAULT 'wxapp',
  `is_fenzhang` int(10) NOT NULL DEFAULT '0' COMMENT '分账:1=开启,0=关闭',
  `transaction_id` varchar(100) DEFAULT NULL COMMENT '微信支付单号',
  `is_cloud_warehouse` int(10) NOT NULL DEFAULT '0' COMMENT '云仓商品:1=是,0=否',
  `is_queue_modeok` int(10) NOT NULL DEFAULT '0' COMMENT '执行免单:1=是,0=否',
  `is_asales_end` int(10) NOT NULL DEFAULT '0' COMMENT '售后期结束:1=是,0=否',
  `asales_end_time` int(11) NOT NULL DEFAULT '0' COMMENT '售后期结束时间',
  `order_source` int(10) NOT NULL DEFAULT '0' COMMENT '订单来源:0=商城订单,1=秒杀订单,2=云仓提货订单,3=拼团订单,4=疯狂卖货模式复购,5=超级卖货模式复购	,6=礼品赠送,7=后台下单,8=云仓商品订单',
  `pintuan_order_id` int(10) NOT NULL DEFAULT '0' COMMENT '拼团主订单ID',
  `pintuan_status` int(10) NOT NULL DEFAULT '-1' COMMENT '拼团状态:-1=待支付,0=拼团中,1=拼团成功,2=拼团失败',
  `jiesuan_status` int(10) NOT NULL DEFAULT '0' COMMENT '商户订单结算状态:0=待结算,1=已结算,2=已到账',
  `daozhang_time` int(11) NOT NULL DEFAULT '0' COMMENT '商户订单到账时间',
  `is_crazy` int(10) NOT NULL DEFAULT '0' COMMENT '疯狂卖货模式订单:1=是,0=否',
  `is_super_maihuo` int(10) NOT NULL DEFAULT '0' COMMENT '超级卖货模式订单:1=是,0=否',
  `rebate_pintuan_status` int(10) NOT NULL DEFAULT '-1' COMMENT '返利拼团:-1=否,0=未拼中,1=已拼中',
  `is_add_sabonus` int(10) NOT NULL DEFAULT '0' COMMENT '加入股份分红:1=是,0=否',
  `is_electronic_waybill_print` int(10) NOT NULL DEFAULT '0' COMMENT '电子面单订单:1=是,0=否',
  `gift_status` int(10) NOT NULL DEFAULT '-1' COMMENT '礼品状态:-1=不是礼品,0=待领取,1=已领取',
  `gift_user_id` int(10) NOT NULL DEFAULT '0' COMMENT '礼品领取用户',
  `gift_receive_time` bigint(16) NOT NULL DEFAULT '0' COMMENT '礼品领取时间',
  `is_hexiao_quantity` int(10) NOT NULL DEFAULT '0' COMMENT '核销数量:1=开启,0=关闭',
  `cash_pay_shenhe` int(10) NOT NULL DEFAULT '-1' COMMENT '线下支付:-1=否,0=待审核,1=已通过,2=已驳回',
  `extend` longtext COMMENT '扩展数据',
  `sup_path` text COMMENT '推荐路径',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '添加时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=645 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_bbfx_order_goods`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_order_goods`;

CREATE TABLE `fa_bbfx_order_goods` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `mid` int(10) NOT NULL DEFAULT '0' COMMENT '商家ID',
  `order_id` int(10) NOT NULL DEFAULT '0' COMMENT '订单ID',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '实付价格',
  `profit_amount` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '商品利润金额',
  `cost_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '成本价',
  `total_price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '原价',
  `discount_price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00',
  `discount_vip_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '会员折扣',
  `discount_coupon_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '优惠券折扣',
  `total` int(10) unsigned NOT NULL DEFAULT '1' COMMENT '数量',
  `goods_id` int(10) NOT NULL DEFAULT '0' COMMENT '商品ID',
  `goods_info` longtext COMMENT '商品信息',
  `upgrade_score` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '分销积分',
  `user_coupon_id` int(10) NOT NULL DEFAULT '0' COMMENT '优惠券ID',
  `sku` text COMMENT '规格组合数据',
  `sku_id` int(10) NOT NULL DEFAULT '0' COMMENT '规格组合ID',
  `sku_name` varchar(500) DEFAULT NULL COMMENT '规格组合名称',
  `type` int(10) NOT NULL DEFAULT '0' COMMENT '商品类型:0=普通商品,1=特价商品',
  `seckill_activity_id` int(10) NOT NULL DEFAULT '0' COMMENT '特价活动ID',
  `seckill_goods_id` int(10) NOT NULL DEFAULT '0' COMMENT '特价商品ID',
  `is_cumulative_fanhuan` int(10) NOT NULL DEFAULT '0' COMMENT '累计返还:1=完成,0=未完成',
  `pintuan_goods_id` int(10) NOT NULL DEFAULT '0' COMMENT '拼团商品ID',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=660 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_bbfx_order_goods_hxcode`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_order_goods_hxcode`;

CREATE TABLE `fa_bbfx_order_goods_hxcode` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `order_id` int(10) NOT NULL DEFAULT '0' COMMENT '订单ID',
  `pid` int(10) NOT NULL DEFAULT '0' COMMENT '订单商品ID',
  `goods_id` int(10) NOT NULL DEFAULT '0' COMMENT '商品ID',
  `hexiao_code` varchar(100) DEFAULT NULL COMMENT '核销码',
  `hexiao_qrcode` varchar(255) DEFAULT NULL COMMENT '核销二维码',
  `hexiao_wxacode` varchar(255) DEFAULT NULL COMMENT '核销小程序码',
  `hexiao_total` int(10) unsigned NOT NULL DEFAULT '1' COMMENT '核销总次数',
  `hexiao_num` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '核销次数',
  `hexiao_uid` int(10) NOT NULL DEFAULT '0' COMMENT '核销用户',
  `hexiao_time` bigint(16) NOT NULL DEFAULT '0' COMMENT '核销时间',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '核销状态:1=已核销,0=待核销',
  `createtime` bigint(16) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=61 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_order_hexiao_record`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_order_hexiao_record`;

CREATE TABLE `fa_bbfx_order_hexiao_record` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `order_id` int(10) NOT NULL DEFAULT '0' COMMENT '订单ID',
  `store_id` int(10) NOT NULL DEFAULT '0' COMMENT '门店ID',
  `hexiao_total` int(10) NOT NULL DEFAULT '0' COMMENT '核销总次数',
  `hexiao_num` int(10) NOT NULL DEFAULT '0' COMMENT '待核销次数',
  `hxcode_id` int(10) NOT NULL DEFAULT '0' COMMENT '核销码ID',
  `info` longtext COMMENT '数据',
  `createtime` bigint(16) NOT NULL DEFAULT '0' COMMENT '核销时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_order_refund`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_order_refund`;

CREATE TABLE `fa_bbfx_order_refund` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(11) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `user_id` int(11) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `order_no` varchar(100) DEFAULT NULL COMMENT '退款单号',
  `order_id` int(11) NOT NULL DEFAULT '0' COMMENT '订单ID',
  `mobile` varchar(20) DEFAULT NULL COMMENT '联系人',
  `money` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '退款金额',
  `content` varchar(500) DEFAULT NULL COMMENT '退款原因',
  `images` text COMMENT '商品图片',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:0=待审核,1=已退款,2=已拒绝',
  `refundtime` int(11) NOT NULL DEFAULT '0' COMMENT '退款时间',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_bbfx_paihangbang`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_paihangbang`;

CREATE TABLE `fa_bbfx_paihangbang` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=开启,0=关闭',
  `ranking_method` int(10) NOT NULL DEFAULT '1' COMMENT '排名方式:1=团队业绩,2=直推业绩',
  `reward_source` int(10) NOT NULL DEFAULT '0' COMMENT '奖励来源:0=奖金池,1=购买商品',
  `reward_buy_goods` varchar(500) DEFAULT NULL COMMENT '奖励购买商品',
  `reward_buy_count` int(10) NOT NULL DEFAULT '0' COMMENT '每多少单分红',
  `achievement_time` int(10) NOT NULL DEFAULT '1' COMMENT '业绩计算时间:1=本月,2=本季度,3=本年',
  `reward_rate` int(10) NOT NULL DEFAULT '0' COMMENT '奖励比例（资金池金额、商品金额百分比）',
  `reward_ranking` int(10) NOT NULL DEFAULT '0' COMMENT '奖励排名',
  `reward_rule` text COMMENT '奖励规则',
  `bg_image` varchar(255) DEFAULT NULL COMMENT '背景图片',
  `banner_image` varchar(255) DEFAULT NULL COMMENT 'banner图片',
  `reward_buy_ok` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '已购单数',
  `reward_buy_money` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '购买商品累计金额',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_pay_order`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_pay_order`;

CREATE TABLE `fa_bbfx_pay_order` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(11) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `openid` varchar(255) DEFAULT NULL COMMENT 'openid',
  `order_no` varchar(100) DEFAULT NULL,
  `price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00',
  `order_type` int(10) NOT NULL DEFAULT '1' COMMENT '订单类型:1=商品订单,2=充值订单,3=会员卡订单,4=预存款订单',
  `is_pay` int(10) NOT NULL DEFAULT '0',
  `paytype` int(10) NOT NULL DEFAULT '1' COMMENT '支付类型:1=微信支付,2=余额支付',
  `paytime` int(11) NOT NULL DEFAULT '0',
  `mchid` varchar(100) DEFAULT NULL,
  `transaction_id` varchar(255) DEFAULT NULL COMMENT '微信订单号',
  `is_shipping` int(10) NOT NULL DEFAULT '0' COMMENT '是否上传发货信息:1=是,0=否',
  `alipay_trade_no` varchar(100) DEFAULT NULL COMMENT '支付宝交易单号',
  `platform` varchar(100) DEFAULT NULL COMMENT '下单平台',
  `createtime` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=511 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_bbfx_pintuan`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_pintuan`;

CREATE TABLE `fa_bbfx_pintuan` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=开启,0=关闭',
  `bg` varchar(255) NOT NULL DEFAULT '/assets/images/plugin/pintuan/bg.jpg' COMMENT '拼团背景',
  `bg_color` varchar(255) NOT NULL DEFAULT '#FD4349,#FF6A4E' COMMENT '背景颜色',
  `pintuan_desc` text COMMENT '拼团玩法',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_pintuan_goods`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_pintuan_goods`;

CREATE TABLE `fa_bbfx_pintuan_goods` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `store_id` int(10) NOT NULL DEFAULT '0' COMMENT '门店ID',
  `goods_id` int(10) NOT NULL DEFAULT '0' COMMENT '绑定商品',
  `price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '拼团价格',
  `pintuan_num` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '成团人数',
  `buy` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '购买次数',
  `virtual_pintian` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '虚拟成团',
  `stock` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '活动库存',
  `is_limitedtime` int(10) NOT NULL DEFAULT '0' COMMENT '组团限时:1=开启,0=关闭',
  `yx_day` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '有效时长',
  `is_tuanzhangyh` int(10) NOT NULL DEFAULT '0' COMMENT '团长优惠:1=开启,0=关闭',
  `kaituan_price` decimal(10,0) unsigned NOT NULL DEFAULT '0' COMMENT '开团价格',
  `auto_pintuan_success` int(10) NOT NULL DEFAULT '0' COMMENT '自动拼团成功:1=开启,0=关闭',
  `plugin` text COMMENT '插件数据',
  `status` int(10) NOT NULL DEFAULT '1' COMMENT '状态:1=上架,0=下架',
  `sort` int(10) NOT NULL DEFAULT '0' COMMENT '排序',
  `endtime` int(11) NOT NULL DEFAULT '0' COMMENT '截止时间',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_pintuan_order`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_pintuan_order`;

CREATE TABLE `fa_bbfx_pintuan_order` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `store_id` int(10) NOT NULL DEFAULT '0' COMMENT '门店ID',
  `pintuan_goods_id` int(10) NOT NULL DEFAULT '0' COMMENT '拼团商品',
  `total` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '成团人数',
  `residue` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '剩余人数',
  `tz_user_id` int(10) NOT NULL DEFAULT '0' COMMENT '团长ID',
  `tz_price` decimal(10,0) unsigned NOT NULL DEFAULT '0' COMMENT '团长购买价格',
  `price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '拼团价格',
  `status` int(10) NOT NULL DEFAULT '-1' COMMENT '状态:-1=待支付,0=拼团中,1=拼团成功,2=拼团失败,-2=关闭拼团',
  `starttime` int(11) NOT NULL DEFAULT '0' COMMENT '开始时间',
  `endtime` int(11) NOT NULL DEFAULT '0' COMMENT '结束时间',
  `jiesuantime` int(11) NOT NULL DEFAULT '0' COMMENT '结算时间',
  `goods` longtext COMMENT '商品数据',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_plugin`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_plugin`;

CREATE TABLE `fa_bbfx_plugin` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `name` varchar(100) DEFAULT NULL COMMENT '应用名称',
  `ident` varchar(100) DEFAULT NULL,
  `type` int(10) NOT NULL DEFAULT '0' COMMENT '应用类型',
  `status` int(10) NOT NULL DEFAULT '1' COMMENT '状态:1=显示,0=隐藏',
  `icon` varchar(255) DEFAULT NULL COMMENT '应用图标',
  `sort` int(10) NOT NULL DEFAULT '0' COMMENT '排序',
  `url` varchar(255) DEFAULT NULL COMMENT '链接',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_bbfx_printer`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_printer`;

CREATE TABLE `fa_bbfx_printer` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(11) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `name` varchar(100) DEFAULT NULL COMMENT '打印机名称',
  `type` int(10) NOT NULL DEFAULT '0' COMMENT '打印机品牌:1=易联云auth2.0接口(支持K4及以上)',
  `content` text COMMENT '打印机参数',
  `total` int(10) NOT NULL DEFAULT '1' COMMENT '打印联数',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_bbfx_problem`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_problem`;

CREATE TABLE `fa_bbfx_problem` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `title` varchar(100) DEFAULT NULL COMMENT '标题',
  `content` text COMMENT '内容',
  `sort` int(10) NOT NULL DEFAULT '0' COMMENT '排序',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=正常,0=禁用',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='常见问题';

-- ----------------------------
-- Table structure for `fa_bbfx_pyramid`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_pyramid`;

CREATE TABLE `fa_bbfx_pyramid` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=开启,0=关闭',
  `pingji_calculate` int(10) NOT NULL DEFAULT '0' COMMENT '平级奖计算:0=当前关系计算,1=原始关系计算',
  `commission1_calculate` int(10) NOT NULL DEFAULT '0' COMMENT '直推奖计算:0=当前关系计算,1=原始关系计算',
  `is_transfer` int(10) NOT NULL DEFAULT '0' COMMENT '跳出模式:1=开启,0=关闭',
  `mode` int(10) NOT NULL DEFAULT '0' COMMENT '模式:0=常规模式,1=大公排模式',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_queue_mode`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_queue_mode`;

CREATE TABLE `fa_bbfx_queue_mode` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=开启,0=关闭',
  `miandan_total` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '免单比例',
  `each_order_rate` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '每单比例',
  `queue_stype` int(10) NOT NULL DEFAULT '1' COMMENT '排单类型:1=订单付款后排单,2=订单完成后排单',
  `oper` int(10) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_bbfx_queue_mode_user`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_queue_mode_user`;

CREATE TABLE `fa_bbfx_queue_mode_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `money` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '免单总额',
  `surplus_money` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '剩余免单',
  `order_id` int(10) NOT NULL DEFAULT '0' COMMENT '免单订单',
  `rank` int(10) NOT NULL DEFAULT '0',
  `info` longtext NOT NULL COMMENT '数据',
  `createtime` bigint(16) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_bbfx_queue_mode_user_record`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_queue_mode_user_record`;

CREATE TABLE `fa_bbfx_queue_mode_user_record` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `pid` int(10) NOT NULL DEFAULT '0' COMMENT '免单用户ID',
  `money` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '免单金额',
  `order_id` int(10) NOT NULL DEFAULT '0' COMMENT '订单ID',
  `info` longtext NOT NULL COMMENT '数据',
  `createtime` bigint(16) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_bbfx_qwen`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_qwen`;

CREATE TABLE `fa_bbfx_qwen` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=开启,0=关闭',
  `apikey` varchar(100) DEFAULT NULL COMMENT 'API KEY',
  `model` varchar(100) DEFAULT 'qwen-max' COMMENT '模型',
  `levels` varchar(255) DEFAULT NULL COMMENT '使用等级',
  `dialogue_title` varchar(100) DEFAULT NULL COMMENT '对话标题',
  `dialogue_icon` varchar(255) DEFAULT NULL COMMENT '对话图标',
  `dialogue_tips` varchar(255) DEFAULT NULL COMMENT '对话提示',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_qwen_chat`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_qwen_chat`;

CREATE TABLE `fa_bbfx_qwen_chat` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `ckey` varchar(100) DEFAULT NULL COMMENT '对话KEY',
  `pid` int(10) NOT NULL DEFAULT '0' COMMENT '回答ID',
  `content` text COMMENT '对话内容',
  `role` varchar(100) NOT NULL DEFAULT 'user' COMMENT '类型:user=用户,system=AI',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=已完成,0=未完成',
  `ctime` bigint(16) NOT NULL DEFAULT '0' COMMENT '完成时间',
  `createtime` bigint(16) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=177 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_rebate_pintuan`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_rebate_pintuan`;

CREATE TABLE `fa_bbfx_rebate_pintuan` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=开启,0=关闭',
  `daozhang_type` int(10) NOT NULL DEFAULT '0' COMMENT '到账时间:0=拼中后,1=发货后,2=完成后',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_recharge_order`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_recharge_order`;

CREATE TABLE `fa_bbfx_recharge_order` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(11) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `order_no` varchar(100) DEFAULT NULL,
  `user_id` int(10) NOT NULL DEFAULT '0',
  `money` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '充值金额',
  `actual_money` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '实际到账',
  `type` int(10) NOT NULL DEFAULT '1' COMMENT '充值类型:1=充值余额,2=充值积分',
  `mode` int(10) NOT NULL DEFAULT '1' COMMENT '充值方式:1=微信充值,2=银行卡充值,3=支付宝充值',
  `pay_pingzheng` varchar(255) DEFAULT NULL COMMENT '支付凭证',
  `status` int(10) NOT NULL DEFAULT '1' COMMENT '状态:0=待审核,1=已通过,2=已拒绝',
  `is_pay` int(10) NOT NULL DEFAULT '0',
  `paytype` int(10) NOT NULL DEFAULT '0' COMMENT '支付类型:1=微信支付,2=银行卡,3=支付宝',
  `paytime` int(11) NOT NULL DEFAULT '0',
  `createtime` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_bbfx_repurchase_jiandan`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_repurchase_jiandan`;

CREATE TABLE `fa_bbfx_repurchase_jiandan` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=开启,0=关闭',
  `repurchase_goods` varchar(255) DEFAULT NULL COMMENT '复购商品',
  `mode` int(10) NOT NULL DEFAULT '0' COMMENT '模式:0=常规模式,1=大公排模式	',
  `layer` int(10) NOT NULL DEFAULT '12' COMMENT '奖励最高层数',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_repurchase_jiandan_rermission`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_repurchase_jiandan_rermission`;

CREATE TABLE `fa_bbfx_repurchase_jiandan_rermission` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `layer` int(10) NOT NULL DEFAULT '0' COMMENT '奖励层数',
  `updatetime` bigint(16) NOT NULL DEFAULT '0' COMMENT '更新时间',
  `createtime` bigint(16) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_repurchase_jiandan_rermission_log`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_repurchase_jiandan_rermission_log`;

CREATE TABLE `fa_bbfx_repurchase_jiandan_rermission_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `pid` int(10) NOT NULL DEFAULT '0' COMMENT 'PID',
  `og_id` int(10) NOT NULL DEFAULT '0' COMMENT '商品订单ID',
  `createtime` varchar(16) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_return`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_return`;

CREATE TABLE `fa_bbfx_return` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(11) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=开启,0=关闭',
  `oper` int(10) unsigned NOT NULL DEFAULT '1',
  `type` int(10) NOT NULL DEFAULT '1' COMMENT '返还类型:1=下单返还,2=按天返还,3=加权返还,4=按月返还',
  `currency` int(10) NOT NULL DEFAULT '1' COMMENT '返还币种:1=余额,2=积分',
  `return_total` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '返还总额',
  `return_total_score` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '返还总额(积分)',
  `return_day` int(10) NOT NULL DEFAULT '0' COMMENT '返还天数',
  `return_rule` int(10) NOT NULL DEFAULT '1' COMMENT '返还规则:1=商品返还,2=订单返还',
  `return_date` date DEFAULT NULL COMMENT '开始返还日期',
  `return_type` int(10) NOT NULL DEFAULT '1' COMMENT '返还时间:1=订单付款后返还,2=订单完成后返还',
  `return_rule_content` text COMMENT '返还详细规则',
  `return_rule_detailed` int(10) NOT NULL DEFAULT '0' COMMENT '详细规则:1=开启,0=关闭',
  `return_jiaquan` int(10) NOT NULL DEFAULT '0' COMMENT '加权分红比例',
  `error` int(10) NOT NULL DEFAULT '0',
  `texts` text,
  `oper_time` int(10) NOT NULL DEFAULT '0' COMMENT '最近执行时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_bbfx_return_item`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_return_item`;

CREATE TABLE `fa_bbfx_return_item` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(11) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `user_id` int(10) NOT NULL DEFAULT '0',
  `daily` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '每日/月返还',
  `total` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '返还总额',
  `day` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '返还天/月数(-1不限制)',
  `order_id` int(10) NOT NULL DEFAULT '0' COMMENT '返还订单',
  `order_goods_id` int(10) NOT NULL DEFAULT '0',
  `return_type` int(10) NOT NULL DEFAULT '0' COMMENT '返还类型:1=下单返还,2=按天返还,3=加权返还,4=按月返还',
  `type` int(10) NOT NULL DEFAULT '1' COMMENT '返还币种:1=余额,2=积分',
  `itype` int(10) NOT NULL DEFAULT '1' COMMENT '类型:1=商品金额返还,2=订单金额返还	',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:0=返还中,1=已完成',
  `sdate` date DEFAULT NULL COMMENT '最近返还日期',
  `info` text COMMENT '订单信息',
  `rule` text COMMENT '返还规则',
  `ntime` bigint(16) NOT NULL DEFAULT '0' COMMENT '下次返还时间',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_id` (`order_id`,`order_goods_id`,`type`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=83 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_bbfx_return_log`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_return_log`;

CREATE TABLE `fa_bbfx_return_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(11) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `user_id` int(10) NOT NULL DEFAULT '0',
  `pid` int(10) NOT NULL DEFAULT '0',
  `sdate` date DEFAULT NULL,
  `money` decimal(10,2) NOT NULL DEFAULT '0.00',
  `type` int(10) NOT NULL DEFAULT '1' COMMENT '1 余额 2 积分',
  `createtime` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`,`pid`,`sdate`)
) ENGINE=InnoDB AUTO_INCREMENT=612 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_bbfx_return_rule`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_return_rule`;

CREATE TABLE `fa_bbfx_return_rule` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(11) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `single_purchase_money` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '单笔消费金额',
  `return_rate` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '返还总额',
  `return_day` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '返还天数',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniacid` (`uniacid`,`single_purchase_money`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_bbfx_role`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_role`;

CREATE TABLE `fa_bbfx_role` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(11) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `name` varchar(100) DEFAULT NULL,
  `content` text,
  `auth_content` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_sabonus`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_sabonus`;

CREATE TABLE `fa_bbfx_sabonus` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `status` int(11) NOT NULL DEFAULT '0' COMMENT '状态:1=开启,0=关闭',
  `abonus_reward` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '分红比例',
  `abonus_day` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '分红天数',
  `calculate_mode` int(10) NOT NULL DEFAULT '1' COMMENT '分红计算:1=全部总份数计算,2=购买后总份数计算',
  `sdate` date DEFAULT NULL COMMENT '最近分红日期',
  `calculate_order_status` int(10) NOT NULL DEFAULT '1' COMMENT '到账份数:1=订单付款后,2=订单完成后',
  `part_calculate` int(10) NOT NULL DEFAULT '0' COMMENT '到账股份用户:0=用户上级,1=用户自己',
  `abonus_cycle` int(10) NOT NULL DEFAULT '0' COMMENT '分红周期:0=日,1=周,2=月',
  `reward_source` int(10) NOT NULL DEFAULT '0' COMMENT '奖励来源:0=商品订单业绩,1=商品分红金额',
  `part_source` int(10) NOT NULL DEFAULT '0' COMMENT '股份来源:0=商品股份,1=直推股份',
  `zhitui_order` int(10) unsigned NOT NULL DEFAULT '1' COMMENT '直推单数',
  `abonus_money` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '累计分红金额',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_sabonus_part`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_sabonus_part`;

CREATE TABLE `fa_bbfx_sabonus_part` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `order_id` int(10) NOT NULL DEFAULT '0' COMMENT '订单ID',
  `order_goods_id` int(10) NOT NULL DEFAULT '0' COMMENT '订单商品ID',
  `part` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '份数',
  `part_source` int(10) NOT NULL DEFAULT '0' COMMENT '股份来源:0=商品股份,1=直推股份',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_sachievement`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_sachievement`;

CREATE TABLE `fa_bbfx_sachievement` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=开启,0=关闭',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_saward`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_saward`;

CREATE TABLE `fa_bbfx_saward` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=开启,0=关闭',
  `reward` text COMMENT '奖励配置',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_sconnection`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_sconnection`;

CREATE TABLE `fa_bbfx_sconnection` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=开启,0=关闭',
  `interval_upgrade` int(10) NOT NULL DEFAULT '0' COMMENT '隔代升级:1=开启,0=关闭',
  `upgrade_commission` text COMMENT '升级手续费',
  `apply_upgrade_zhitui_user` int(10) NOT NULL DEFAULT '0' COMMENT '申请升级直推人数（默认等级除外）',
  `layer_upgrade` int(10) NOT NULL DEFAULT '0' COMMENT '按层升级:1=开启,0=关闭',
  `apply_upgrade_bg` varchar(255) DEFAULT NULL COMMENT '申请晋升背景',
  `wu_apply_user` varchar(255) DEFAULT NULL COMMENT '无审核用户时指定审核用户',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_sconnection_upgrade_log`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_sconnection_upgrade_log`;

CREATE TABLE `fa_bbfx_sconnection_upgrade_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `sh_user_id` int(10) NOT NULL DEFAULT '0' COMMENT '审核用户ID',
  `level` int(10) NOT NULL DEFAULT '0' COMMENT '申请等级',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=已审核,0=待审核',
  `upgradetime` int(11) NOT NULL DEFAULT '0' COMMENT '升级时间',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_sconnection_upgrade_order`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_sconnection_upgrade_order`;

CREATE TABLE `fa_bbfx_sconnection_upgrade_order` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `order_no` varchar(100) DEFAULT NULL COMMENT '订单编号',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `pid` int(10) NOT NULL DEFAULT '0' COMMENT '升级记录ID',
  `title` varchar(100) DEFAULT NULL COMMENT '标题',
  `price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '订单金额',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '支付状态:1=已支付,0=未支付',
  `paytype` int(10) NOT NULL DEFAULT '0' COMMENT '支付类型:1=微信,2=余额',
  `paytime` int(11) NOT NULL DEFAULT '0' COMMENT '支付时间',
  `info` text COMMENT '信息',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_scorereward`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_scorereward`;

CREATE TABLE `fa_bbfx_scorereward` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=开启,0=关闭',
  `reward_rate` int(10) NOT NULL DEFAULT '0' COMMENT '积分比例',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_scoreshop`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_scoreshop`;

CREATE TABLE `fa_bbfx_scoreshop` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(11) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=开启,0=关闭',
  `description` text COMMENT '积分说明',
  `share_title` varchar(100) DEFAULT NULL COMMENT '分享标题',
  `share_img` varchar(255) DEFAULT NULL COMMENT '分享图片',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='积分商城配置表';

-- ----------------------------
-- Table structure for `fa_bbfx_scoreshop_category`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_scoreshop_category`;

CREATE TABLE `fa_bbfx_scoreshop_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `title` varchar(10) DEFAULT NULL COMMENT '分类标题',
  `status` int(10) NOT NULL DEFAULT '1' COMMENT '状态:1=正常,0=禁用',
  `thumb` varchar(255) DEFAULT NULL COMMENT '分类图标',
  `sort` int(10) NOT NULL DEFAULT '0' COMMENT '分类排序',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='积分商城商品分类表';

-- ----------------------------
-- Table structure for `fa_bbfx_scoreshop_goods`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_scoreshop_goods`;

CREATE TABLE `fa_bbfx_scoreshop_goods` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `title` varchar(20) DEFAULT NULL COMMENT '商品名称',
  `thumb` varchar(200) DEFAULT NULL COMMENT '商品图片',
  `price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '商品价格',
  `score` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '商品积分',
  `stock` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '库存',
  `status` int(10) NOT NULL DEFAULT '1' COMMENT '状态:1=上架,0=下架',
  `type` int(10) NOT NULL DEFAULT '1' COMMENT '商品类型:1=虚拟商品(卡密类),2=实体商品,3=核销商品,4=虚拟商品(不发货)',
  `is_recommend` int(10) NOT NULL DEFAULT '0' COMMENT '推荐:1=开启,0=关闭',
  `is_new` int(10) NOT NULL DEFAULT '0' COMMENT '新品:1=开启,0=关闭',
  `is_hot` int(10) NOT NULL DEFAULT '0' COMMENT '热卖:1=开启,0=关闭',
  `sort` int(10) NOT NULL COMMENT '商品排序',
  `share_title` varchar(20) DEFAULT NULL COMMENT '商品排序',
  `share_img` varchar(200) DEFAULT NULL COMMENT '商品排序',
  `o_price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '商品原价',
  `express_fee` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '快递费',
  `slides` text COMMENT '商品幻灯',
  `videos` text COMMENT '商品视频',
  `content` text COMMENT '商品详情',
  `unit` varchar(20) NOT NULL DEFAULT '件' COMMENT '商品单位',
  `sales_volume` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '商品销量',
  `minbuy` int(10) unsigned NOT NULL DEFAULT '1' COMMENT '最低购买',
  `maxbuy` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '最多购买',
  `total_maxbuy` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '总购买',
  `daily_buy` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '每日最多购买',
  `monthly_buy` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '每月最多购买',
  `levels` varchar(255) DEFAULT NULL COMMENT '购买等级',
  `delivery_method` int(10) NOT NULL DEFAULT '1' COMMENT '配送方式:1=快递配送,2=门店核销,3=快递配送和门店核销',
  `hexiao_store_type` int(10) NOT NULL DEFAULT '0' COMMENT '核销门店:0=全部门店,1=指定门店',
  `hexiao_num` int(10) unsigned NOT NULL DEFAULT '1' COMMENT '核销次数',
  `is_hexiao` int(10) NOT NULL DEFAULT '0' COMMENT '门店核销(type=4):1=开启,0=关闭',
  `shippingfee_template_id` int(10) NOT NULL DEFAULT '0' COMMENT '运费模板ID',
  `weight` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '重量（kg）',
  `volume` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '体积（m³）',
  `fahuo_content` text COMMENT '发货内容',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COMMENT='积分商城商品表';

-- ----------------------------
-- Table structure for `fa_bbfx_scoreshop_goods_category`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_scoreshop_goods_category`;

CREATE TABLE `fa_bbfx_scoreshop_goods_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(11) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `goods_id` int(11) NOT NULL DEFAULT '0' COMMENT '商品ID',
  `category_id` int(11) NOT NULL DEFAULT '0' COMMENT '分类ID',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='积分商城商品分类组合表';

-- ----------------------------
-- Table structure for `fa_bbfx_scoreshop_order`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_scoreshop_order`;

CREATE TABLE `fa_bbfx_scoreshop_order` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `order_no` varchar(100) DEFAULT NULL COMMENT '订单编号',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `store_id` int(10) NOT NULL DEFAULT '0' COMMENT '门店ID',
  `order_type` int(11) NOT NULL DEFAULT '1' COMMENT '订单类型:1=虚拟商品(卡密),2=实物商品(快递),3=核销商品,4=虚拟商品(不发货)',
  `score` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '订单积分',
  `price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '实付金额',
  `original_price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '商品原价',
  `total_price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '订单总价',
  `paytype` int(10) NOT NULL DEFAULT '1' COMMENT '支付类型:1=微信支付,2=余额支付',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:0=待支付,1=待发货/待核销,2=已发货,3=已完成/已核销,-1=已取消',
  `refund_status` int(10) NOT NULL DEFAULT '-1' COMMENT '退款状态:-1=未退款,0=待审核,1=已退款,2=已拒绝',
  `goods_info` text COMMENT '商品信息',
  `express_fee` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '快递费',
  `delivery_username` varchar(50) DEFAULT NULL COMMENT '收货人姓名',
  `delivery_mobile` varchar(20) DEFAULT NULL COMMENT '收货人电话',
  `delivery_province` varchar(20) DEFAULT NULL COMMENT '收货省份',
  `delivery_city` varchar(50) DEFAULT NULL COMMENT '收货城市',
  `delivery_area` varchar(255) DEFAULT NULL COMMENT '收货区',
  `delivery_address` varchar(500) DEFAULT NULL COMMENT '收货详细地址',
  `express` text COMMENT '物流信息',
  `deliver_type` int(10) NOT NULL DEFAULT '1' COMMENT '发货类型:1=按订单发货,2=按商品发货,3=自定义发货',
  `deliverytime` int(11) NOT NULL DEFAULT '0' COMMENT '发货时间',
  `pay_time` int(11) NOT NULL DEFAULT '0' COMMENT '支付时间',
  `remarks` varchar(500) DEFAULT NULL COMMENT '订单备注',
  `delivery_method` int(10) NOT NULL DEFAULT '1' COMMENT '配送方式:1=快递配送,2=门店核销',
  `is_hexiao` int(10) NOT NULL DEFAULT '0' COMMENT '核销订单:1=是,0=否',
  `hexiao_realname` varchar(100) DEFAULT NULL COMMENT '用户姓名',
  `hexiao_mobile` varchar(100) DEFAULT NULL COMMENT '用户电话',
  `hexiao_num` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '核销次数',
  `hexiao_total` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '核销总次数',
  `hexiao_uid` int(10) NOT NULL DEFAULT '0' COMMENT '核销用户',
  `hexiao_time` int(11) NOT NULL DEFAULT '0' COMMENT '核销时间',
  `hexiao_store` text COMMENT '核销门店',
  `hexiao_qrcode` varchar(255) DEFAULT NULL COMMENT '核销二维码',
  `hexiao_wxacode` varchar(255) DEFAULT NULL COMMENT '核销小程序码',
  `hexiao_code` varchar(100) DEFAULT NULL COMMENT '核销码',
  `sup_path` text COMMENT '推荐路径',
  `platform` varchar(100) DEFAULT NULL COMMENT '下单平台',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8 COMMENT='积分商品订单表';

-- ----------------------------
-- Table structure for `fa_bbfx_scoreshop_order_goods`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_scoreshop_order_goods`;

CREATE TABLE `fa_bbfx_scoreshop_order_goods` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `order_id` int(10) NOT NULL DEFAULT '0' COMMENT '订单ID',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `score` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '商品积分',
  `price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '商品金额',
  `total_price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '商品总金额',
  `total` int(10) unsigned NOT NULL DEFAULT '1' COMMENT '商品数量',
  `goods_id` int(10) NOT NULL DEFAULT '0' COMMENT '商品ID',
  `goods_info` longtext COMMENT '商品信息',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=25 DEFAULT CHARSET=utf8 COMMENT='积分商城订单商品表';

-- ----------------------------
-- Table structure for `fa_bbfx_scoreshop_order_hexiao_record`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_scoreshop_order_hexiao_record`;

CREATE TABLE `fa_bbfx_scoreshop_order_hexiao_record` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `order_id` int(10) NOT NULL DEFAULT '0' COMMENT '订单ID',
  `store_id` int(10) NOT NULL DEFAULT '0' COMMENT '门店ID',
  `info` longtext COMMENT '数据',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '核销时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_scoreshop_order_refund`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_scoreshop_order_refund`;

CREATE TABLE `fa_bbfx_scoreshop_order_refund` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(11) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `user_id` int(11) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `order_no` varchar(100) DEFAULT NULL COMMENT '退款单号',
  `order_id` int(11) NOT NULL DEFAULT '0' COMMENT '订单ID',
  `mobile` varchar(20) DEFAULT NULL COMMENT '联系方式',
  `money` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '退款金额',
  `score` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '退款积分',
  `content` varchar(500) DEFAULT NULL COMMENT '退款原因',
  `images` text COMMENT '商品问题图片',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:0=待审核,1=已退款,2=已拒绝',
  `refundtime` int(11) NOT NULL DEFAULT '0' COMMENT '退款时间',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='积分商城订单退款表';

-- ----------------------------
-- Table structure for `fa_bbfx_scoreshop_serial_number`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_scoreshop_serial_number`;

CREATE TABLE `fa_bbfx_scoreshop_serial_number` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `goods_id` int(10) NOT NULL DEFAULT '0' COMMENT '商品ID',
  `val` text COMMENT '卡密值',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=已使用,0=未使用',
  `oper` int(11) unsigned NOT NULL DEFAULT '1',
  `pid` int(10) NOT NULL DEFAULT '0' COMMENT '订单商品ID',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='积分商城商品卡密表';

-- ----------------------------
-- Table structure for `fa_bbfx_scoreshop_store_goods`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_scoreshop_store_goods`;

CREATE TABLE `fa_bbfx_scoreshop_store_goods` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `store_id` int(10) NOT NULL DEFAULT '0' COMMENT '门店ID',
  `goods_id` int(10) NOT NULL DEFAULT '0' COMMENT '商品ID',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_seckill_activity`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_seckill_activity`;

CREATE TABLE `fa_bbfx_seckill_activity` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `seckill_goods_ids` text COMMENT '特价商品',
  `name` varchar(255) DEFAULT NULL COMMENT '活动名称',
  `starttime` int(11) DEFAULT '0' COMMENT '开启时间',
  `endtime` int(11) NOT NULL DEFAULT '0' COMMENT '结束时间',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=正常,0=禁用',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_bbfx_seckill_goods`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_seckill_goods`;

CREATE TABLE `fa_bbfx_seckill_goods` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `goods_id` int(10) NOT NULL DEFAULT '0' COMMENT '商品ID',
  `type` int(10) NOT NULL DEFAULT '1' COMMENT '折扣类型:1=固定金额,2=折扣',
  `price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '秒杀价格',
  `discount` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '活动折扣',
  `status` int(10) NOT NULL DEFAULT '1' COMMENT '状态:1=正常,0=禁用',
  `is_fenxiao` int(10) NOT NULL DEFAULT '1' COMMENT '参与分销:1=开启,0=关闭',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_bbfx_serial_number`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_serial_number`;

CREATE TABLE `fa_bbfx_serial_number` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `goods_id` int(10) NOT NULL DEFAULT '0' COMMENT '商品ID',
  `val` text COMMENT '卡密值',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=已使用,0=未使用',
  `oper` int(11) unsigned NOT NULL DEFAULT '1',
  `pid` int(10) NOT NULL DEFAULT '0' COMMENT '订单商品ID',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=136 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_bbfx_shippingfee_template`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_shippingfee_template`;

CREATE TABLE `fa_bbfx_shippingfee_template` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `name` varchar(100) DEFAULT NULL COMMENT '模板名称',
  `type` int(10) NOT NULL DEFAULT '0' COMMENT '类型:0=按重量计费,1=按体积计费,2=按件计费',
  `rule` text NOT NULL COMMENT '运费规则',
  `createtime` bigint(16) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_short_video`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_short_video`;

CREATE TABLE `fa_bbfx_short_video` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `status` int(10) NOT NULL DEFAULT '1' COMMENT '状态:1=开启,0=关闭',
  `page_bgcolor` varchar(100) NOT NULL DEFAULT '#000' COMMENT '页面背景',
  `page_bg` varchar(255) DEFAULT NULL COMMENT '页面背景',
  `publisher` varchar(100) DEFAULT NULL COMMENT '发布者',
  `publisher_avatar` varchar(255) DEFAULT NULL COMMENT '发布者头像',
  `goods_show` int(10) NOT NULL DEFAULT '0' COMMENT '商品显示:1=是,0=否',
  `comment_verify` int(10) NOT NULL DEFAULT '0' COMMENT '评论审核:1=开启,0=关闭',
  `show_publisher` int(10) NOT NULL DEFAULT '0' COMMENT '显示发布者:1=是,0=否',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_short_video_collect`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_short_video_collect`;

CREATE TABLE `fa_bbfx_short_video_collect` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `pid` int(10) NOT NULL DEFAULT '0' COMMENT '视频ID',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COMMENT='短视频收藏';

-- ----------------------------
-- Table structure for `fa_bbfx_short_video_comment`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_short_video_comment`;

CREATE TABLE `fa_bbfx_short_video_comment` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `pid` int(10) NOT NULL DEFAULT '0' COMMENT '视频ID',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `reply_id` int(10) NOT NULL DEFAULT '0' COMMENT '回复ID',
  `reply_pid` int(10) NOT NULL DEFAULT '0' COMMENT '回复主ID',
  `content` varchar(500) DEFAULT NULL COMMENT '回复内容',
  `dz_num` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '点赞数',
  `cai_num` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '踩数',
  `status` int(10) NOT NULL DEFAULT '1' COMMENT '状态:0=待审核,1=通过,2=拒绝',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_short_video_comment_dianzan`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_short_video_comment_dianzan`;

CREATE TABLE `fa_bbfx_short_video_comment_dianzan` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `pid` int(10) NOT NULL DEFAULT '0' COMMENT '视频ID',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `comment_id` int(10) NOT NULL DEFAULT '0' COMMENT '评论ID',
  `status` int(10) NOT NULL DEFAULT '1' COMMENT '状态:1=赞,0=踩',
  `updatetime` int(11) NOT NULL DEFAULT '0',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_short_video_dianzan`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_short_video_dianzan`;

CREATE TABLE `fa_bbfx_short_video_dianzan` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `pid` int(10) NOT NULL DEFAULT '0' COMMENT '视频ID',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `createtime` bigint(16) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_short_video_list`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_short_video_list`;

CREATE TABLE `fa_bbfx_short_video_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `title` varchar(200) DEFAULT NULL COMMENT '标题',
  `video` varchar(255) NOT NULL COMMENT '视频',
  `pageview` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '浏览量',
  `collect_num` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '收藏数',
  `share_num` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '分享数',
  `dianzan_num` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '点赞数量',
  `goods_id` int(10) NOT NULL DEFAULT '0' COMMENT '绑定商品',
  `is_recommend` int(10) NOT NULL DEFAULT '0' COMMENT '推荐:1=是,0=否',
  `status` int(10) NOT NULL DEFAULT '1' COMMENT '状态:1=正常,0=禁用',
  `sh_status` int(10) NOT NULL DEFAULT '0' COMMENT '审核状态:0=待审核,1=通过,2=驳回',
  `sh_time` int(11) NOT NULL DEFAULT '0' COMMENT '审核时间',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_short_video_share`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_short_video_share`;

CREATE TABLE `fa_bbfx_short_video_share` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `pid` int(10) NOT NULL DEFAULT '0' COMMENT '视频ID',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_shuziren`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_shuziren`;

CREATE TABLE `fa_bbfx_shuziren` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL COMMENT '平台ID',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=开启,0=关闭',
  `apikey` varchar(100) DEFAULT NULL COMMENT 'API KEY',
  `model` varchar(100) DEFAULT 'videoretalk' COMMENT '声动人像VideoRetalk模型',
  `audio_model` varchar(100) NOT NULL DEFAULT 'qwen-tts' COMMENT '声音复刻模型',
  `levels` varchar(255) DEFAULT NULL COMMENT '使用等级',
  `btn_bg` text COMMENT '按钮背景',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_shuziren_video`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_shuziren_video`;

CREATE TABLE `fa_bbfx_shuziren_video` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `voice_id` int(10) NOT NULL DEFAULT '0' COMMENT '音色ID',
  `video_id` int(10) NOT NULL DEFAULT '0' COMMENT '视频ID',
  `title` varchar(100) DEFAULT NULL COMMENT '标题',
  `text` text COMMENT '文字内容',
  `original_video` varchar(255) DEFAULT NULL COMMENT '原视频',
  `voice_url` varchar(255) DEFAULT NULL COMMENT '语音连接',
  `url` varchar(255) DEFAULT NULL COMMENT '视频链接',
  `task_id` varchar(255) DEFAULT NULL COMMENT '作业ID',
  `status` varchar(100) DEFAULT NULL COMMENT '状态',
  `completetime` bigint(16) NOT NULL DEFAULT '0' COMMENT '完成时间',
  `createtime` bigint(16) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_shuziren_video_tpl`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_shuziren_video_tpl`;

CREATE TABLE `fa_bbfx_shuziren_video_tpl` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `title` varchar(100) DEFAULT NULL COMMENT '视频标题',
  `url` varchar(255) DEFAULT NULL COMMENT '视频链接',
  `createtime` bigint(16) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_shuziren_voice`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_shuziren_voice`;

CREATE TABLE `fa_bbfx_shuziren_voice` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `title` varchar(100) DEFAULT NULL COMMENT '标题',
  `url` varchar(255) DEFAULT NULL COMMENT '声音链接',
  `voice_id` varchar(100) DEFAULT NULL COMMENT '音色ID',
  `apikey` varchar(100) DEFAULT NULL COMMENT '所属KEY',
  `status` varchar(100) NOT NULL COMMENT '状态',
  `createtime` bigint(16) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_signin`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_signin`;

CREATE TABLE `fa_bbfx_signin` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '签到',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=开启,0=关闭',
  `day` int(10) unsigned NOT NULL DEFAULT '15' COMMENT '签到天数',
  `signin_reward` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '签到奖励',
  `reward_type` int(10) NOT NULL DEFAULT '2' COMMENT '奖励类型:1=余额,2=积分',
  `continuity_signin_rule` text COMMENT '连续签到规则',
  `bg` varchar(255) DEFAULT NULL COMMENT '签到背景',
  `signin_on_color` varchar(255) DEFAULT '#ED7398,#EE7ACD' COMMENT '已签到背景',
  `signin_color` varchar(100) DEFAULT '#FAE5F1' COMMENT '未签到背景',
  `signin_icon` varchar(255) DEFAULT NULL COMMENT '签到图标',
  `sdesc` text COMMENT '签到说明',
  `pop_image` varchar(255) DEFAULT NULL COMMENT '签到弹窗图片',
  `haowu_recommend_image` varchar(255) DEFAULT NULL COMMENT '好物推荐图片',
  `btn_right_image` varchar(255) DEFAULT NULL COMMENT '按钮右侧图片',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_signin_record`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_signin_record`;

CREATE TABLE `fa_bbfx_signin_record` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(11) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `title` varchar(100) DEFAULT NULL COMMENT '标题',
  `total` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '奖励',
  `type` int(10) NOT NULL DEFAULT '0' COMMENT '奖励类型:1=余额,2=积分',
  `date` date DEFAULT NULL COMMENT '签到日期',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_sinterest`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_sinterest`;

CREATE TABLE `fa_bbfx_sinterest` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=开启,0=关闭',
  `settlement_type` int(10) NOT NULL DEFAULT '0' COMMENT '结算类型:0=每天结算,1=每月结算,2=每年结算',
  `settlement_currency` varchar(255) NOT NULL DEFAULT '' COMMENT '结算币种:1=余额,2=积分',
  `settlement_balance_rate` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '结算余额比例',
  `settlement_score_rate` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '结算积分比例',
  `sdate` date DEFAULT NULL COMMENT '结算日期',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_skqrcode`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_skqrcode`;

CREATE TABLE `fa_bbfx_skqrcode` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=开启,0=关闭',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_slide`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_slide`;

CREATE TABLE `fa_bbfx_slide` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `type` int(10) NOT NULL DEFAULT '0' COMMENT '类型',
  `title` varchar(100) DEFAULT NULL COMMENT '标题',
  `image` varchar(255) DEFAULT NULL COMMENT '图片',
  `sort` int(10) NOT NULL DEFAULT '0' COMMENT '排序',
  `link` varchar(500) NOT NULL COMMENT '链接',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_smaterial`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_smaterial`;

CREATE TABLE `fa_bbfx_smaterial` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `status` int(10) NOT NULL DEFAULT '1' COMMENT '状态:1=开启,0=关闭',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_smaterial_category`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_smaterial_category`;

CREATE TABLE `fa_bbfx_smaterial_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `pid` int(10) NOT NULL DEFAULT '0' COMMENT '上级ID',
  `title` varchar(100) DEFAULT NULL COMMENT '标题',
  `image` varchar(255) DEFAULT NULL COMMENT '图片',
  `sort` int(10) NOT NULL DEFAULT '0' COMMENT '排序',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_smaterial_item`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_smaterial_item`;

CREATE TABLE `fa_bbfx_smaterial_item` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `category_id` int(10) NOT NULL DEFAULT '0' COMMENT '分类ID',
  `title` varchar(255) DEFAULT NULL COMMENT '标题',
  `content` text COMMENT '分享内容',
  `type` int(10) NOT NULL DEFAULT '0' COMMENT '类型:0=图片,1=视频',
  `image` text COMMENT '分享图片',
  `video` varchar(255) DEFAULT NULL COMMENT '分享视频',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=正常,0=禁用',
  `sort` int(10) NOT NULL DEFAULT '0' COMMENT '排序',
  `createtime` bigint(16) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_store`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_store`;

CREATE TABLE `fa_bbfx_store` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `type` int(10) NOT NULL DEFAULT '0' COMMENT '类型:0=平台门店,1=商户门店',
  `main` int(10) NOT NULL DEFAULT '0' COMMENT '主门店:1=是,0=否',
  `mid` int(10) NOT NULL DEFAULT '0' COMMENT '商户ID',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '店长ID',
  `clerk_user_id` varchar(500) DEFAULT NULL COMMENT '店员ID',
  `category_id` varchar(500) DEFAULT NULL COMMENT '商户分类',
  `name` varchar(100) DEFAULT NULL COMMENT '门店名称',
  `logo` varchar(255) DEFAULT NULL COMMENT '门店logo',
  `realname` varchar(100) DEFAULT NULL COMMENT '店长姓名',
  `mobile` varchar(100) DEFAULT NULL COMMENT '联系电话',
  `yy_time` varchar(100) DEFAULT NULL COMMENT '营业时间',
  `province` varchar(100) DEFAULT NULL COMMENT '身份',
  `city` varchar(100) DEFAULT NULL COMMENT '城市',
  `area` varchar(100) DEFAULT NULL COMMENT '区县',
  `address` varchar(255) DEFAULT NULL COMMENT '详细地址',
  `lng` double NOT NULL DEFAULT '0' COMMENT '经度',
  `lat` double NOT NULL DEFAULT '0' COMMENT '纬度',
  `is_reservation` int(10) NOT NULL DEFAULT '0' COMMENT '预约功能:1=开启,0=关闭',
  `commission` text COMMENT '核销佣金设置',
  `introduction` varchar(255) DEFAULT NULL COMMENT '门店简介',
  `content` longtext COMMENT '门店介绍',
  `detail_images` text COMMENT '详情图片',
  `images` text COMMENT '门店图片',
  `score` decimal(10,1) NOT NULL DEFAULT '5.0' COMMENT '评分',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=正常,0=禁用',
  `sort` int(10) NOT NULL DEFAULT '0' COMMENT '排序',
  `createtime` bigint(16) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_store_goods`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_store_goods`;

CREATE TABLE `fa_bbfx_store_goods` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `store_id` int(10) NOT NULL DEFAULT '0' COMMENT '门店ID',
  `goods_id` int(10) NOT NULL DEFAULT '0' COMMENT '商品ID',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_store_reservation`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_store_reservation`;

CREATE TABLE `fa_bbfx_store_reservation` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `store_id` int(10) NOT NULL DEFAULT '0' COMMENT '门店ID',
  `mobile` varchar(100) DEFAULT NULL COMMENT '手机号',
  `reservation_time` int(11) NOT NULL DEFAULT '0' COMMENT '预约时间',
  `notes` varchar(500) DEFAULT NULL COMMENT '备注',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:0=待处理,1=已处理',
  `handle_time` int(11) NOT NULL DEFAULT '0' COMMENT '处理时间',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_super_maihuo`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_super_maihuo`;

CREATE TABLE `fa_bbfx_super_maihuo` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=开启,0=关闭',
  `daozhang_type` int(10) NOT NULL DEFAULT '0' COMMENT '份额到账类型:1=付款后到账,0=完成后到账',
  `repurchase_goods` varchar(255) DEFAULT NULL COMMENT '复购商品',
  `abonus_num` int(10) NOT NULL DEFAULT '1' COMMENT '分红次数',
  `abonus_money` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '每份金额',
  `abonus_score` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '分红积分',
  `sup_reward` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '推荐奖励',
  `bg_color` varchar(100) DEFAULT NULL COMMENT '背景色',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_super_maihuo_group`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_super_maihuo_group`;

CREATE TABLE `fa_bbfx_super_maihuo_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `num` int(10) NOT NULL DEFAULT '0' COMMENT '序号',
  `group_id` int(10) NOT NULL DEFAULT '0' COMMENT '主分红组ID',
  `pid` int(10) NOT NULL DEFAULT '0' COMMENT '分红用户ID',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '组长ID',
  `order_id` int(10) NOT NULL DEFAULT '0' COMMENT '订单ID',
  `money` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '分红金额',
  `total` int(10) NOT NULL DEFAULT '0' COMMENT '人数',
  `stime` int(11) NOT NULL DEFAULT '0' COMMENT '开始时间',
  `etime` int(11) NOT NULL DEFAULT '0' COMMENT '结束时间',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:0=待分红,1=已分红',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_super_maihuo_group_user`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_super_maihuo_group_user`;

CREATE TABLE `fa_bbfx_super_maihuo_group_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `pid` int(10) NOT NULL DEFAULT '0' COMMENT '分红用户ID',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `order_id` int(10) NOT NULL DEFAULT '0' COMMENT '订单ID',
  `group_id` int(10) NOT NULL DEFAULT '0' COMMENT '分组ID',
  `money` decimal(10,0) unsigned NOT NULL DEFAULT '0' COMMENT '分红金额',
  `contribution_value` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '贡献值',
  `num` int(10) NOT NULL DEFAULT '0' COMMENT '排序',
  `utime` bigint(16) NOT NULL DEFAULT '0' COMMENT '更新时间',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_super_maihuo_user`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_super_maihuo_user`;

CREATE TABLE `fa_bbfx_super_maihuo_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `order_id` int(10) NOT NULL DEFAULT '0' COMMENT '订单ID',
  `num` int(10) NOT NULL DEFAULT '0' COMMENT '分红次数',
  `money` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '分红金额',
  `contribution_value` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '贡献值',
  `info` text COMMENT '信息',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=已完成,0=进行中',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_sverify`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_sverify`;

CREATE TABLE `fa_bbfx_sverify` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=开启,0=关闭',
  `query_success_image` varchar(255) DEFAULT NULL COMMENT '查询成功图片',
  `query_fail_image` varchar(255) DEFAULT NULL COMMENT '查询失败图片',
  `wxapp_qrcode` int(10) NOT NULL DEFAULT '0' COMMENT '小程序二维码:1=开启,0=关闭',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_sverify_product`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_sverify_product`;

CREATE TABLE `fa_bbfx_sverify_product` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `code` varchar(255) DEFAULT NULL COMMENT '防伪code',
  `name` varchar(100) DEFAULT NULL COMMENT '产品名称',
  `image` varchar(255) DEFAULT NULL COMMENT '产品图片',
  `images` varchar(2000) DEFAULT NULL COMMENT 'banner图片',
  `number_prefix` varchar(100) DEFAULT NULL COMMENT '前缀',
  `number_digits` int(10) NOT NULL DEFAULT '6' COMMENT '编号位数',
  `query_first_tips` varchar(255) DEFAULT NULL COMMENT '查询正品首次提示',
  `query_success_tips` varchar(255) DEFAULT NULL COMMENT '查询正品成功提示',
  `query_fail_tips` varchar(255) DEFAULT NULL COMMENT '查询正品失败提示',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=正常,0=禁用',
  `extend` text COMMENT '扩展内容',
  `createtime` bigint(16) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_sverify_product_code`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_sverify_product_code`;

CREATE TABLE `fa_bbfx_sverify_product_code` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `product_id` int(10) NOT NULL DEFAULT '0' COMMENT '产品ID',
  `code` varchar(255) DEFAULT NULL COMMENT 'code',
  `query_num` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '查询次数',
  `qrcode` varchar(255) DEFAULT NULL COMMENT 'H5二维码',
  `wxapp_qrcode` varchar(255) DEFAULT NULL COMMENT '小程序二维码',
  `createtime` bigint(16) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_sverify_product_query_log`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_sverify_product_query_log`;

CREATE TABLE `fa_bbfx_sverify_product_query_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `product_id` int(10) NOT NULL DEFAULT '0' COMMENT '产品ID',
  `code` varchar(255) DEFAULT NULL COMMENT '防伪码',
  `ip` varchar(255) NOT NULL COMMENT '查询IP',
  `createtime` bigint(16) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_transfer_account`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_transfer_account`;

CREATE TABLE `fa_bbfx_transfer_account` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(11) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `status` int(11) NOT NULL DEFAULT '0' COMMENT '状态:1=开启,0=关闭',
  `service_charges1` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '余额转账手续费',
  `service_charges2` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '积分转账手续费',
  `balance_status` int(10) NOT NULL DEFAULT '0' COMMENT '余额转账:1=开启,0=关闭',
  `score_status` int(10) NOT NULL DEFAULT '0' COMMENT '积分转账:1=开启,0=关闭',
  `is_crossline` int(10) NOT NULL DEFAULT '1' COMMENT '跨线转移:1=开启,0=关闭',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_bbfx_transfer_account_log`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_transfer_account_log`;

CREATE TABLE `fa_bbfx_transfer_account_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `from_user_id` int(10) NOT NULL DEFAULT '0' COMMENT '转账用户',
  `to_user_id` int(10) NOT NULL DEFAULT '0' COMMENT '接收用户',
  `money` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '转账金额/积分',
  `service_recharge` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '手续费',
  `realmoney` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '实际到账金额/积分',
  `type` int(10) NOT NULL DEFAULT '0' COMMENT '转账类型:1=余额,2=积分',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_bbfx_txabonus`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_txabonus`;

CREATE TABLE `fa_bbfx_txabonus` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=开启,0=关闭',
  `team_subsidy` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '团队补贴',
  `tixian_extract_rate` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '提现抽取比例',
  `buy_goods` varchar(255) DEFAULT NULL COMMENT '购买商品',
  `zt_buy_goods` varchar(255) DEFAULT NULL COMMENT '直推购买商品',
  `abonus_num` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '分红人数',
  `consume_money` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '消费金额',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_txabonus_log`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_txabonus_log`;

CREATE TABLE `fa_bbfx_txabonus_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `money` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '抽取金额',
  `pid` int(10) NOT NULL DEFAULT '0' COMMENT '提现ID',
  `createtime` bigint(16) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_txabonus_user`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_txabonus_user`;

CREATE TABLE `fa_bbfx_txabonus_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `updatetime` bigint(16) NOT NULL DEFAULT '0' COMMENT '更新时间',
  `createtime` bigint(16) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_user`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_user`;

CREATE TABLE `fa_bbfx_user` (
  `id` int(10) unsigned NOT NULL COMMENT 'ID',
  `uid` int(10) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `sup_uid` int(10) NOT NULL DEFAULT '0' COMMENT '上级UID',
  `sup_path` longtext COMMENT '推荐路径',
  `share_id` int(10) NOT NULL DEFAULT '0' COMMENT '上级分享id',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `openid` varchar(100) DEFAULT NULL COMMENT 'openid',
  `username` varchar(100) DEFAULT NULL COMMENT '用户名',
  `nickname` varchar(30) CHARACTER SET utf8mb4 DEFAULT NULL COMMENT '昵称',
  `avatar` varchar(500) DEFAULT NULL COMMENT '头像',
  `realname` varchar(20) DEFAULT NULL COMMENT '姓名',
  `mobile` varchar(20) DEFAULT NULL COMMENT '手机号',
  `sex` int(10) NOT NULL DEFAULT '0' COMMENT '性别:1=男,2=女',
  `balance` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '余额',
  `sk_balance` decimal(12,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '收款码余额',
  `score` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '积分',
  `deposit_money` decimal(12,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '预存款',
  `redpacket_money` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '红包金额',
  `repurchase_currency` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '复购金',
  `status` int(10) NOT NULL DEFAULT '1' COMMENT '状态:1=正常,2=冻结',
  `signin_time` int(11) NOT NULL DEFAULT '0' COMMENT '签到时间',
  `total_continuity_signin_day` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '总连续签到天数',
  `continuity_signin_day` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '连续签到天数',
  `total_signin_day` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '总签到天数',
  `signin_remind` int(10) NOT NULL DEFAULT '0' COMMENT '签到提醒',
  `task_ok` int(11) unsigned NOT NULL DEFAULT '0',
  `task_total` int(11) unsigned NOT NULL DEFAULT '0',
  `task_time` int(11) NOT NULL DEFAULT '0',
  `subscribe_num` int(11) unsigned NOT NULL DEFAULT '0',
  `level` int(10) NOT NULL DEFAULT '0' COMMENT '分销等级',
  `is_distributor` int(10) NOT NULL DEFAULT '0' COMMENT '分销商:1=是,0=否',
  `distributor_status` int(10) NOT NULL DEFAULT '-1' COMMENT '分销商申请状态:-1=待申请,0=待审核,1=通过,2=拒绝',
  `become_distributor_time` int(11) NOT NULL DEFAULT '0' COMMENT '成为分销商时间',
  `upgrade_distributor_time` int(11) NOT NULL DEFAULT '0' COMMENT '升级分销商时间',
  `commission_total` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '累计佣金',
  `commission_ok` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '可提现佣金',
  `freeze_commission` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '冻结收益',
  `is_transfer` int(10) NOT NULL DEFAULT '0' COMMENT '转移推荐人:1=是,0=否(2+1模式)',
  `first_sup_uid` int(10) NOT NULL DEFAULT '0' COMMENT '第一推荐人，最开始的推荐人(2+1模式)',
  `transfer_sup_uid` int(10) NOT NULL DEFAULT '0' COMMENT '升级时移除的推荐人(2+1模式)',
  `update_notice` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新通知',
  `withdrawal_info` text,
  `agent_status` int(10) NOT NULL DEFAULT '-1' COMMENT '代理商:-1=不是代理商,0=待审核,1=审核通过,2=审核拒绝',
  `agent_level` int(10) NOT NULL DEFAULT '0' COMMENT '代理级别:1=省级,2=市级,3=区级,4=街道',
  `agent_province` varchar(100) DEFAULT NULL COMMENT '代理省份',
  `agent_city` varchar(100) DEFAULT NULL COMMENT '代理城市',
  `agent_area` varchar(100) DEFAULT NULL COMMENT '代理区县',
  `agent_street` varchar(100) DEFAULT NULL COMMENT '代理街道',
  `is_deputy_city_agent` int(10) NOT NULL DEFAULT '0' COMMENT '副市级代理:1=是,0=否',
  `is_agent_xyok` int(10) NOT NULL DEFAULT '0' COMMENT '代理协议:1=同意,0=拒绝',
  `become_agent_time` int(11) NOT NULL DEFAULT '0' COMMENT '成为代理商时间',
  `platform` varchar(100) NOT NULL DEFAULT 'WXAPP',
  `password` varchar(255) DEFAULT NULL COMMENT '登录密码',
  `pay_password` varchar(255) DEFAULT NULL COMMENT '支付密码',
  `salt` varchar(20) DEFAULT NULL COMMENT '密码盐',
  `code` varchar(100) DEFAULT NULL COMMENT '邀请码',
  `double_track_level` int(10) NOT NULL DEFAULT '0' COMMENT '双轨模式管理等级',
  `double_track_btime` int(11) NOT NULL DEFAULT '0' COMMENT '双轨模式成为管理时间',
  `double_track_utime` int(11) NOT NULL DEFAULT '0' COMMENT '双轨模式管理等级升级时间',
  `double_track_first_uid` int(10) NOT NULL DEFAULT '0' COMMENT '双轨模式第一推荐人',
  `double_track_transfer_uid` int(10) NOT NULL DEFAULT '0' COMMENT '双轨模式转移时的上级',
  `abonus_auth` int(10) NOT NULL DEFAULT '0' COMMENT '分红权限:1=开启,0=关闭',
  `abonus_auth_time` int(11) NOT NULL DEFAULT '0' COMMENT '开启分红权限时间',
  `skqrcode` varchar(255) DEFAULT NULL COMMENT '收款码',
  `bank_realname` varchar(100) DEFAULT NULL COMMENT '提现银行卡姓名',
  `bankname` varchar(100) DEFAULT NULL COMMENT '提现银行',
  `bankcard` varchar(100) DEFAULT NULL COMMENT '提现银行卡号',
  `zfb_realname` varchar(100) DEFAULT NULL COMMENT '提现支付宝姓名',
  `zfb` varchar(100) DEFAULT NULL COMMENT '提现支付宝账号',
  `freeze_money` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '冻结收益',
  `yiestransfer_sup_uid` int(10) NOT NULL DEFAULT '0' COMMENT '321模式，直推升级时的推荐人',
  `cloud_warehouse_stock` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '云仓商品库存',
  `cloud_warehouse_jinhuo_stock` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '云仓商品进货库存(最多还可进货库存)',
  `is_dealer` int(10) NOT NULL DEFAULT '0' COMMENT '经销商:1=是,0=否',
  `dealer_reward` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '经销商奖励',
  `dealer_province` varchar(100) DEFAULT NULL COMMENT '经销商管理省份',
  `dealer_city` varchar(100) DEFAULT NULL COMMENT '经销商管理城市',
  `dealer_store` varchar(500) DEFAULT NULL COMMENT '经销商指定门店',
  `dealer_store_reward` int(10) NOT NULL DEFAULT '0' COMMENT '门店指定经销商奖励',
  `become_dealer_time` bigint(16) NOT NULL DEFAULT '0' COMMENT '成为经销商时间',
  `hexiao_realname` varchar(100) DEFAULT NULL COMMENT '核销用户姓名',
  `hexiao_mobile` varchar(100) DEFAULT NULL COMMENT '核销用户电话',
  `strikeout_multiple` int(10) NOT NULL DEFAULT '-1' COMMENT '出局倍数:-1=不单独设置,0=不显示',
  `ss_region` varchar(100) DEFAULT NULL COMMENT '所属区域',
  `bindtime` int(11) NOT NULL DEFAULT '0' COMMENT '绑定关系时间',
  `last_login_time` int(11) NOT NULL DEFAULT '0' COMMENT '最后登录时间',
  `weixin` varchar(255) DEFAULT NULL COMMENT '微信号',
  `wealth_point_uid` int(10) NOT NULL DEFAULT '0' COMMENT '财富点位用户',
  `is_tixian_activate` int(10) NOT NULL DEFAULT '1' COMMENT '提现激活:1=开启,0=关闭',
  `tixian_activate_time` bigint(16) NOT NULL DEFAULT '0' COMMENT '提现激活时间',
  `pyramid_transfer` int(10) NOT NULL DEFAULT '0' COMMENT '三三复制转移:1=是,0=否',
  `fenxiao_becomedue_time` bigint(16) NOT NULL DEFAULT '0' COMMENT '分销到期时间',
  `contribution_value` decimal(12,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '贡献值',
  `contribution_value_total` decimal(12,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '累计贡献值',
  `wxapp_openid` varchar(100) DEFAULT NULL COMMENT '小程序openid',
  `gzh_openid` varchar(100) DEFAULT NULL COMMENT '公众号openid',
  `chat_uuid` varchar(100) DEFAULT NULL COMMENT '聊天ID',
  `repurchase_jiandan_transfer` int(10) NOT NULL DEFAULT '0' COMMENT '复购见单转移:1=是,0=否',
  `fund_money` decimal(12,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '发展基金',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '注册时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniacid` (`uniacid`,`username`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_bbfx_user_address`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_user_address`;

CREATE TABLE `fa_bbfx_user_address` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `is_default` int(10) NOT NULL DEFAULT '0' COMMENT '1 默认',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `consignee` varchar(50) DEFAULT NULL COMMENT '收货人',
  `phone` varchar(20) DEFAULT NULL COMMENT '联系电话	',
  `province_name` varchar(20) DEFAULT NULL COMMENT '省',
  `city_name` varchar(20) DEFAULT NULL COMMENT '市',
  `area_name` varchar(20) DEFAULT NULL COMMENT '区',
  `street_name` varchar(50) DEFAULT NULL COMMENT '街道',
  `address` varchar(255) DEFAULT NULL COMMENT '详细地址',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=75 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_bbfx_user_cart`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_user_cart`;

CREATE TABLE `fa_bbfx_user_cart` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(11) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `mid` int(10) NOT NULL DEFAULT '0' COMMENT '商户ID',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `goods_id` int(10) NOT NULL DEFAULT '0' COMMENT '商品ID',
  `sku_id` int(10) NOT NULL DEFAULT '0' COMMENT '规格组合ID',
  `total` int(10) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_bbfx_user_coupon`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_user_coupon`;

CREATE TABLE `fa_bbfx_user_coupon` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(11) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `user_id` int(11) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `coupon_id` int(11) NOT NULL DEFAULT '0' COMMENT '优惠券ID',
  `type` int(10) NOT NULL DEFAULT '0' COMMENT '优惠券类型:0=一次性,1=持续性',
  `name` varchar(100) DEFAULT NULL COMMENT '优惠券名称',
  `money` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '优惠券金额',
  `max_money` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '使用金额限制(%)',
  `mj_money` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '满减金额',
  `endtime` int(11) NOT NULL DEFAULT '0' COMMENT '到期时间，0为不限制',
  `goods_ids` varchar(500) DEFAULT NULL COMMENT '指定商品',
  `info` text COMMENT '优惠券信息',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=已使用,0=未使用',
  `condition_type` int(10) NOT NULL DEFAULT '0',
  `receive_type` int(10) NOT NULL DEFAULT '0' COMMENT '领取类型:0=后台发送,1=免费领取,2=会员卡赠送,3=下单赠送',
  `residue_money` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '剩余金额',
  `item_id` int(10) NOT NULL DEFAULT '0',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=197 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_bbfx_user_wxapp_subscribe`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_user_wxapp_subscribe`;

CREATE TABLE `fa_bbfx_user_wxapp_subscribe` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `tid` varchar(100) DEFAULT NULL COMMENT '模板ID',
  `tid_name` varchar(100) DEFAULT NULL COMMENT '模板名称',
  `num` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '消息次数',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_verifcode`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_verifcode`;

CREATE TABLE `fa_bbfx_verifcode` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `mobile` varchar(20) DEFAULT NULL COMMENT '手机号',
  `code` varchar(100) DEFAULT NULL COMMENT '验证码',
  `type` varchar(100) DEFAULT NULL COMMENT '验证码类型',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=已验证,0=未验证',
  `expirestime` int(11) NOT NULL DEFAULT '0' COMMENT '失效时间',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_bbfx_withdrawal_log`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_withdrawal_log`;

CREATE TABLE `fa_bbfx_withdrawal_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '平台ID',
  `user_id` int(11) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `withdrawal_no` varchar(100) DEFAULT NULL COMMENT '单号',
  `out_batch_no` varchar(100) DEFAULT NULL COMMENT '商家批次单号(商家转账到零钱)',
  `batch_id` varchar(1000) DEFAULT NULL COMMENT '微信批次单号（微信商家转账系统返回的唯一标识）',
  `money` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '提现金额',
  `realmoney` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '实际到账',
  `service_charge` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '手续费',
  `type` int(11) NOT NULL DEFAULT '0' COMMENT '1 商城余额  2 微信零钱  3 支付宝  4 银行卡  5 收款码  6 商城积分',
  `withdrawal_type` int(10) NOT NULL DEFAULT '0' COMMENT '提现类型:1=余额提现,2=佣金提现,3=积分提现,5=红包提现,6=预存款提现,7=商户提现',
  `realname` varchar(20) DEFAULT NULL COMMENT '姓名',
  `alipay` varchar(100) DEFAULT NULL COMMENT '支付宝账号',
  `bankname` varchar(100) DEFAULT NULL COMMENT '银行名称',
  `bankcard` varchar(100) DEFAULT NULL COMMENT '银行卡号',
  `skqrcode` varchar(500) DEFAULT NULL COMMENT '收款码',
  `paytime` int(11) NOT NULL DEFAULT '0' COMMENT '打款时间',
  `status` int(11) NOT NULL DEFAULT '0' COMMENT '0 审核中 1 已打款 2 已拒绝',
  `remarks` text COMMENT '拒绝原因',
  `package_info` text,
  `is_confirm` int(10) NOT NULL DEFAULT '-1' COMMENT '确认收款:-1=未同意,0=待确认,1=已确认',
  `confirmtime` bigint(16) NOT NULL DEFAULT '0' COMMENT '确认时间',
  `createtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_bbfx_yabonus`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_yabonus`;

CREATE TABLE `fa_bbfx_yabonus` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `level` varchar(255) NOT NULL COMMENT '分红等级',
  `abonus_rate` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '分红比例',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_yajin`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_yajin`;

CREATE TABLE `fa_bbfx_yajin` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:1=开启,0=关闭',
  `yajin_money` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '押金金额',
  `refund` text COMMENT '退还配置',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_yajin_record`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_yajin_record`;

CREATE TABLE `fa_bbfx_yajin_record` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `type` int(10) NOT NULL DEFAULT '0' COMMENT '类型:0=分销升级押金',
  `order_no` varchar(100) DEFAULT NULL COMMENT '订单号',
  `money` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '押金金额',
  `refund_money` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '退还金额',
  `title` varchar(100) DEFAULT NULL COMMENT '标题',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:0=待支付,1=待退还,2=已退还',
  `paytype` int(10) NOT NULL DEFAULT '0' COMMENT '支付类型',
  `paytime` bigint(16) NOT NULL DEFAULT '0' COMMENT '支付时间',
  `refundtime` bigint(16) NOT NULL DEFAULT '0' COMMENT '退还时间',
  `extend` text COMMENT '扩展参数',
  `createtime` bigint(16) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_bbfx_yajin_refund_record`
-- ----------------------------

DROP TABLE IF EXISTS `fa_bbfx_yajin_refund_record`;

CREATE TABLE `fa_bbfx_yajin_refund_record` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uniacid` int(10) NOT NULL DEFAULT '0' COMMENT '平台ID',
  `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `refund_no` varchar(100) NOT NULL COMMENT '退还单号',
  `pid` int(10) NOT NULL DEFAULT '0' COMMENT '押金记录ID',
  `money` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '押金金额',
  `refund_money` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '退还金额',
  `type` int(10) NOT NULL DEFAULT '0' COMMENT '提现方式:1=余额,2=微信零钱,3=支付宝,4=银行卡,5=收款码',
  `title` varchar(100) DEFAULT NULL COMMENT '标题',
  `realname` varchar(100) DEFAULT NULL COMMENT '姓名',
  `alipay` varchar(100) DEFAULT NULL COMMENT '支付宝账号',
  `bankname` varchar(100) DEFAULT NULL COMMENT '银行名称',
  `bankcard` varchar(100) DEFAULT NULL COMMENT '银行卡号',
  `skqrcode` varchar(255) DEFAULT NULL COMMENT '收款码',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '状态:0=待审核,1=通过,2=驳回',
  `shtime` bigint(16) NOT NULL DEFAULT '0' COMMENT '审核时间',
  `reason` varchar(500) DEFAULT NULL COMMENT '驳回原因',
  `out_batch_no` varchar(100) DEFAULT NULL,
  `batch_id` varchar(100) DEFAULT NULL,
  `package_info` text,
  `is_confirm` int(10) NOT NULL DEFAULT '-1' COMMENT '确认收款:-1=未同意,0=待确认,1=已确认',
  `confirmtime` bigint(16) NOT NULL DEFAULT '0' COMMENT '确认时间',
  `createtime` bigint(16) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_category`
-- ----------------------------

DROP TABLE IF EXISTS `fa_category`;

CREATE TABLE `fa_category` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '父ID',
  `type` varchar(30) DEFAULT '' COMMENT '栏目类型',
  `name` varchar(30) DEFAULT '',
  `nickname` varchar(50) DEFAULT '',
  `flag` set('hot','index','recommend') DEFAULT '',
  `image` varchar(100) DEFAULT '' COMMENT '图片',
  `keywords` varchar(255) DEFAULT '' COMMENT '关键字',
  `description` varchar(255) DEFAULT '' COMMENT '描述',
  `diyname` varchar(30) DEFAULT '' COMMENT '自定义名称',
  `createtime` bigint(16) DEFAULT NULL COMMENT '创建时间',
  `updatetime` bigint(16) DEFAULT NULL COMMENT '更新时间',
  `weigh` int(10) NOT NULL DEFAULT '0' COMMENT '权重',
  `status` varchar(30) DEFAULT '' COMMENT '状态',
  PRIMARY KEY (`id`),
  KEY `weigh` (`weigh`,`id`),
  KEY `pid` (`pid`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COMMENT='分类表';

-- ----------------------------
-- Data for the table `fa_category`
-- ----------------------------

INSERT INTO `fa_category` VALUES (1, 0, 'page', '官方新闻', 'news', 'recommend', '/assets/img/qrcode.png', '', '', 'news', 1491635035, 1491635035, 1, 'normal');
INSERT INTO `fa_category` VALUES (2, 0, 'page', '移动应用', 'mobileapp', 'hot', '/assets/img/qrcode.png', '', '', 'mobileapp', 1491635035, 1491635035, 2, 'normal');
INSERT INTO `fa_category` VALUES (3, 2, 'page', '微信公众号', 'wechatpublic', 'index', '/assets/img/qrcode.png', '', '', 'wechatpublic', 1491635035, 1491635035, 3, 'normal');
INSERT INTO `fa_category` VALUES (4, 2, 'page', 'Android开发', 'android', 'recommend', '/assets/img/qrcode.png', '', '', 'android', 1491635035, 1491635035, 4, 'normal');
INSERT INTO `fa_category` VALUES (5, 0, 'page', '软件产品', 'software', 'recommend', '/assets/img/qrcode.png', '', '', 'software', 1491635035, 1491635035, 5, 'normal');
INSERT INTO `fa_category` VALUES (6, 5, 'page', '网站建站', 'website', 'recommend', '/assets/img/qrcode.png', '', '', 'website', 1491635035, 1491635035, 6, 'normal');
INSERT INTO `fa_category` VALUES (7, 5, 'page', '企业管理软件', 'company', 'index', '/assets/img/qrcode.png', '', '', 'company', 1491635035, 1491635035, 7, 'normal');
INSERT INTO `fa_category` VALUES (8, 6, 'page', 'PC端', 'website-pc', 'recommend', '/assets/img/qrcode.png', '', '', 'website-pc', 1491635035, 1491635035, 8, 'normal');
INSERT INTO `fa_category` VALUES (9, 6, 'page', '移动端', 'website-mobile', 'recommend', '/assets/img/qrcode.png', '', '', 'website-mobile', 1491635035, 1491635035, 9, 'normal');
INSERT INTO `fa_category` VALUES (10, 7, 'page', 'CRM系统 ', 'company-crm', 'recommend', '/assets/img/qrcode.png', '', '', 'company-crm', 1491635035, 1491635035, 10, 'normal');
INSERT INTO `fa_category` VALUES (11, 7, 'page', 'SASS平台软件', 'company-sass', 'recommend', '/assets/img/qrcode.png', '', '', 'company-sass', 1491635035, 1491635035, 11, 'normal');
INSERT INTO `fa_category` VALUES (12, 0, 'test', '测试1', 'test1', 'recommend', '/assets/img/qrcode.png', '', '', 'test1', 1491635035, 1491635035, 12, 'normal');
INSERT INTO `fa_category` VALUES (13, 0, 'test', '测试2', 'test2', 'recommend', '/assets/img/qrcode.png', '', '', 'test2', 1491635035, 1491635035, 13, 'normal');

-- ----------------------------
-- Table structure for `fa_ceshi`
-- ----------------------------

DROP TABLE IF EXISTS `fa_ceshi`;

CREATE TABLE `fa_ceshi` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(10) NOT NULL DEFAULT '0',
  `money` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Table structure for `fa_command`
-- ----------------------------

DROP TABLE IF EXISTS `fa_command`;

CREATE TABLE `fa_command` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `type` varchar(30) NOT NULL DEFAULT '' COMMENT '类型',
  `params` varchar(1500) NOT NULL DEFAULT '' COMMENT '参数',
  `command` varchar(1500) NOT NULL DEFAULT '' COMMENT '命令',
  `content` text COMMENT '返回结果',
  `executetime` bigint(16) unsigned DEFAULT NULL COMMENT '执行时间',
  `createtime` bigint(16) unsigned DEFAULT NULL COMMENT '创建时间',
  `updatetime` bigint(16) unsigned DEFAULT NULL COMMENT '更新时间',
  `status` enum('successed','failured') NOT NULL DEFAULT 'failured' COMMENT '状态',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='在线命令表';

-- ----------------------------
-- Table structure for `fa_config`
-- ----------------------------

DROP TABLE IF EXISTS `fa_config`;

CREATE TABLE `fa_config` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(30) DEFAULT '' COMMENT '变量名',
  `group` varchar(30) DEFAULT '' COMMENT '分组',
  `title` varchar(100) DEFAULT '' COMMENT '变量标题',
  `tip` varchar(100) DEFAULT '' COMMENT '变量描述',
  `type` varchar(30) DEFAULT '' COMMENT '类型:string,text,int,bool,array,datetime,date,file',
  `visible` varchar(255) DEFAULT '' COMMENT '可见条件',
  `value` text COMMENT '变量值',
  `content` text COMMENT '变量字典数据',
  `rule` varchar(100) DEFAULT '' COMMENT '验证规则',
  `extend` varchar(255) DEFAULT '' COMMENT '扩展属性',
  `setting` varchar(255) DEFAULT '' COMMENT '配置',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COMMENT='系统配置';

-- ----------------------------
-- Data for the table `fa_config`
-- ----------------------------

INSERT INTO `fa_config` VALUES (1, 'name', 'basic', 'Site name', '请填写站点名称', 'string', '', '百变分销', NULL, 'required', '', '');
INSERT INTO `fa_config` VALUES (2, 'beian', 'basic', '底部信息', '粤ICP备15000000号-1', 'string', '', '闽ICP备xxxxxxx号-2', NULL, '', '', '');
INSERT INTO `fa_config` VALUES (3, 'cdnurl', 'basic', 'Cdn url', '如果全站静态资源使用第三方云储存请配置该值', 'string', '', NULL, NULL, '', '', '');
INSERT INTO `fa_config` VALUES (4, 'version', 'basic', 'Version', '如果静态资源有变动请重新配置该值', 'string', '', '1.0.1', NULL, 'required', '', '');
INSERT INTO `fa_config` VALUES (5, 'timezone', 'basic', 'Timezone', '', 'string', '', 'Asia/Shanghai', NULL, 'required', '', '');
INSERT INTO `fa_config` VALUES (6, 'forbiddenip', 'basic', 'Forbidden ip', '一行一条记录', 'text', '', NULL, NULL, '', '', '');
INSERT INTO `fa_config` VALUES (7, 'languages', 'basic', 'Languages', '', 'array', '', '{"backend":"zh-cn","frontend":"zh-cn"}', NULL, 'required', '', '');
INSERT INTO `fa_config` VALUES (8, 'fixedpage', 'basic', 'Fixed page', '请输入左侧菜单栏存在的链接', 'string', '', 'platform', NULL, 'required', '', '');
INSERT INTO `fa_config` VALUES (9, 'categorytype', 'dictionary', 'Category type', '', 'array', '', '{"default":"默认","page":"单页","article":"文章"}', NULL, '', '', '');
INSERT INTO `fa_config` VALUES (10, 'configgroup', 'dictionary', 'Config group', '', 'array', '', '{"basic":"基础配置","dictionary":"字典配置"}', NULL, '', '', '');
INSERT INTO `fa_config` VALUES (11, 'mail_type', 'email', 'Mail type', '选择邮件发送方式', 'select', '', '1', '["请选择","SMTP"]', '', '', '');
INSERT INTO `fa_config` VALUES (12, 'mail_smtp_host', 'email', 'Mail smtp host', '错误的配置发送邮件会导致服务器超时', 'string', '', 'smtp.qq.com', NULL, '', '', '');
INSERT INTO `fa_config` VALUES (13, 'mail_smtp_port', 'email', 'Mail smtp port', '(不加密默认25,SSL默认465,TLS默认587)', 'string', '', '465', NULL, '', '', '');
INSERT INTO `fa_config` VALUES (14, 'mail_smtp_user', 'email', 'Mail smtp user', '（填写完整用户名）', 'string', '', '10000', NULL, '', '', '');
INSERT INTO `fa_config` VALUES (15, 'mail_smtp_pass', 'email', 'Mail smtp password', '（填写您的密码或授权码）', 'string', '', 'password', NULL, '', '', '');
INSERT INTO `fa_config` VALUES (16, 'mail_verify_type', 'email', 'Mail vertify type', '（SMTP验证方式[推荐SSL]）', 'select', '', '2', '["无","TLS","SSL"]', '', '', '');
INSERT INTO `fa_config` VALUES (17, 'mail_from', 'email', 'Mail from', '', 'string', '', '10000@qq.com', NULL, '', '', '');
INSERT INTO `fa_config` VALUES (18, 'attachmentcategory', 'dictionary', 'Attachment category', '', 'array', '', '{"category1":"分类一","category2":"分类二","custom":"自定义"}', NULL, '', '', '');
INSERT INTO `fa_config` VALUES (19, 'logo', 'basic', 'LOGO', '', 'image', '', '/assets/images/logo.png', NULL, '', '', '{"table":"","conditions":"","key":"","value":""}');
INSERT INTO `fa_config` VALUES (20, 'login_bg', 'basic', '登录背景', '', 'image', '', '/assets/images/login-bg.jpg', NULL, '', '', '{"table":"","conditions":"","key":"","value":""}');

-- ----------------------------
-- Table structure for `fa_ems`
-- ----------------------------

DROP TABLE IF EXISTS `fa_ems`;

CREATE TABLE `fa_ems` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `event` varchar(30) DEFAULT '' COMMENT '事件',
  `email` varchar(100) DEFAULT '' COMMENT '邮箱',
  `code` varchar(10) DEFAULT '' COMMENT '验证码',
  `times` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '验证次数',
  `ip` varchar(30) DEFAULT '' COMMENT 'IP',
  `createtime` bigint(16) DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='邮箱验证码表';

-- ----------------------------
-- Table structure for `fa_platform`
-- ----------------------------

DROP TABLE IF EXISTS `fa_platform`;

CREATE TABLE `fa_platform` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `name` varchar(255) NOT NULL COMMENT '平台名称',
  `type` set('1','2','3','4') NOT NULL COMMENT '类型:1=公众号,2=小程序,3=H5,4=APP',
  `AppId` varchar(255) DEFAULT NULL COMMENT '公众号AppId',
  `AppSecret` varchar(255) DEFAULT NULL COMMENT '公众号AppSecret',
  `mch_id` varchar(100) DEFAULT NULL COMMENT '公众号商户号',
  `paykey` varchar(255) DEFAULT NULL COMMENT '公众号支付秘钥',
  `cert` varchar(255) DEFAULT NULL COMMENT '公众号支付证书',
  `certkey` varchar(255) DEFAULT NULL COMMENT '公众号支付证书秘钥',
  `publickeyId` varchar(255) DEFAULT NULL COMMENT '微信公众号支付公钥ID',
  `wxapp_AppId` varchar(255) DEFAULT NULL COMMENT '小程序AppId',
  `wxapp_AppSecret` varchar(255) DEFAULT NULL COMMENT '小程序AppSecret',
  `wxapp_mch_id` varchar(100) DEFAULT NULL COMMENT '小程序商户号',
  `wxapp_paykey` varchar(255) DEFAULT NULL COMMENT '小程序支付秘钥',
  `wxapp_cert` varchar(255) DEFAULT NULL COMMENT '小程序支付证书',
  `wxapp_certkey` varchar(255) DEFAULT NULL COMMENT '小程序支付证书秘钥',
  `wxapp_publickeyId` varchar(255) DEFAULT NULL COMMENT '微信小程序支付公钥ID',
  `wxapp_upload_privateKey` varchar(255) DEFAULT NULL COMMENT '小程序代码上传密钥',
  `service_provider_status` int(10) NOT NULL DEFAULT '0' COMMENT '服务商支付:1=开启,0=关闭',
  `service_provider_appid` varchar(100) DEFAULT NULL COMMENT '服务商APPID',
  `service_provider_mchid` varchar(100) DEFAULT NULL COMMENT '服务商商户号',
  `service_provider_paykey` varchar(255) DEFAULT NULL COMMENT '服务商支付秘钥',
  `service_provider_cert` varchar(255) DEFAULT NULL COMMENT '服务商支付证书',
  `service_provider_certkey` varchar(255) DEFAULT NULL COMMENT '服务商支付证书秘钥',
  `zfb_appid` varchar(100) DEFAULT NULL COMMENT '支付宝应用ID',
  `zfb_publickey_cert` varchar(255) DEFAULT NULL COMMENT '支付宝公钥证书',
  `zfb_root_cert` varchar(255) DEFAULT NULL COMMENT '支付宝根证书',
  `zfb_app_cert` varchar(255) DEFAULT NULL COMMENT '应用证书',
  `zfb_privateKey` text COMMENT '应用私钥',
  `wap_AppId` varchar(100) DEFAULT NULL COMMENT '微信H5支付AppId',
  `wap_AppSecret` varchar(255) DEFAULT NULL COMMENT '微信H5支付AppSecret',
  `wap_mch_id` varchar(100) DEFAULT NULL COMMENT '微信H5支付商户号',
  `wap_paykey` varchar(255) DEFAULT NULL COMMENT '微信H5支付秘钥',
  `wap_cert` varchar(255) DEFAULT NULL COMMENT '微信H5支付证书',
  `wap_certkey` varchar(255) DEFAULT NULL COMMENT '微信H5支付证书秘钥',
  `status` enum('1','0') NOT NULL DEFAULT '1' COMMENT '状态:1=正常,0=禁用',
  `access_token` varchar(500) DEFAULT NULL,
  `access_token_appid` varchar(100) DEFAULT NULL,
  `access_token_time` int(10) NOT NULL DEFAULT '0',
  `wxapp_access_token` varchar(500) DEFAULT NULL,
  `wxapp_access_token_appid` varchar(100) DEFAULT NULL,
  `wxapp_access_token_time` int(11) NOT NULL DEFAULT '0',
  `ticket` varchar(500) DEFAULT NULL,
  `ticket_appid` varchar(100) DEFAULT NULL,
  `ticket_expires_time` int(11) NOT NULL DEFAULT '0',
  `createtime` int(11) NOT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Data for the table `fa_platform`
-- ----------------------------

INSERT INTO `fa_platform` VALUES (1, '百变分销', '1,2,3,4', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '0', '', '', 1733757813, '', '', 1731645451, '', '', 1733757813, 1698910027);

-- ----------------------------
-- Table structure for `fa_renewlog`
-- ----------------------------

DROP TABLE IF EXISTS `fa_renewlog`;

CREATE TABLE `fa_renewlog` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `version_name` varchar(100) NOT NULL COMMENT '版本名称',
  `version` int(10) NOT NULL COMMENT '版本号',
  `content` text NOT NULL COMMENT '更新内容',
  `createtime` int(11) NOT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `fa_sms`
-- ----------------------------

DROP TABLE IF EXISTS `fa_sms`;

CREATE TABLE `fa_sms` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `event` varchar(30) DEFAULT '' COMMENT '事件',
  `mobile` varchar(20) DEFAULT '' COMMENT '手机号',
  `code` varchar(10) DEFAULT '' COMMENT '验证码',
  `times` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '验证次数',
  `ip` varchar(30) DEFAULT '' COMMENT 'IP',
  `createtime` bigint(16) unsigned DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='短信验证码表';

-- ----------------------------
-- Table structure for `fa_test`
-- ----------------------------

DROP TABLE IF EXISTS `fa_test`;

CREATE TABLE `fa_test` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `user_id` int(10) DEFAULT '0' COMMENT '会员ID',
  `admin_id` int(10) DEFAULT '0' COMMENT '管理员ID',
  `category_id` int(10) unsigned DEFAULT '0' COMMENT '分类ID(单选)',
  `category_ids` varchar(100) DEFAULT NULL COMMENT '分类ID(多选)',
  `tags` varchar(255) DEFAULT '' COMMENT '标签',
  `week` enum('monday','tuesday','wednesday') DEFAULT NULL COMMENT '星期(单选):monday=星期一,tuesday=星期二,wednesday=星期三',
  `flag` set('hot','index','recommend') DEFAULT '' COMMENT '标志(多选):hot=热门,index=首页,recommend=推荐',
  `genderdata` enum('male','female') DEFAULT 'male' COMMENT '性别(单选):male=男,female=女',
  `hobbydata` set('music','reading','swimming') DEFAULT NULL COMMENT '爱好(多选):music=音乐,reading=读书,swimming=游泳',
  `title` varchar(100) DEFAULT '' COMMENT '标题',
  `content` text COMMENT '内容',
  `image` varchar(100) DEFAULT '' COMMENT '图片',
  `images` varchar(1500) DEFAULT '' COMMENT '图片组',
  `attachfile` varchar(100) DEFAULT '' COMMENT '附件',
  `keywords` varchar(255) DEFAULT '' COMMENT '关键字',
  `description` varchar(255) DEFAULT '' COMMENT '描述',
  `city` varchar(100) DEFAULT '' COMMENT '省市',
  `json` varchar(255) DEFAULT NULL COMMENT '配置:key=名称,value=值',
  `multiplejson` varchar(1500) DEFAULT '' COMMENT '二维数组:title=标题,intro=介绍,author=作者,age=年龄',
  `price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '价格',
  `views` int(10) unsigned DEFAULT '0' COMMENT '点击',
  `workrange` varchar(100) DEFAULT '' COMMENT '时间区间',
  `startdate` date DEFAULT NULL COMMENT '开始日期',
  `activitytime` datetime DEFAULT NULL COMMENT '活动时间(datetime)',
  `year` year(4) DEFAULT NULL COMMENT '年',
  `times` time DEFAULT NULL COMMENT '时间',
  `refreshtime` bigint(16) DEFAULT NULL COMMENT '刷新时间',
  `createtime` bigint(16) DEFAULT NULL COMMENT '创建时间',
  `updatetime` bigint(16) DEFAULT NULL COMMENT '更新时间',
  `deletetime` bigint(16) DEFAULT NULL COMMENT '删除时间',
  `weigh` int(10) DEFAULT '0' COMMENT '权重',
  `switch` tinyint(1) DEFAULT '0' COMMENT '开关',
  `status` enum('normal','hidden') DEFAULT 'normal' COMMENT '状态',
  `state` enum('0','1','2') DEFAULT '1' COMMENT '状态值:0=禁用,1=正常,2=推荐',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COMMENT='测试表';

-- ----------------------------
-- Table structure for `fa_user`
-- ----------------------------

DROP TABLE IF EXISTS `fa_user`;

CREATE TABLE `fa_user` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `openid` varchar(100) NOT NULL,
  `group_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '组别ID',
  `username` varchar(32) DEFAULT '' COMMENT '用户名',
  `nickname` varchar(50) DEFAULT '' COMMENT '昵称',
  `password` varchar(32) DEFAULT '' COMMENT '密码',
  `salt` varchar(30) DEFAULT '' COMMENT '密码盐',
  `email` varchar(100) DEFAULT '' COMMENT '电子邮箱',
  `mobile` varchar(11) DEFAULT '' COMMENT '手机号',
  `avatar` varchar(255) DEFAULT '' COMMENT '头像',
  `level` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '等级',
  `gender` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '性别',
  `birthday` date DEFAULT NULL COMMENT '生日',
  `bio` varchar(100) DEFAULT '' COMMENT '格言',
  `money` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '余额',
  `score` int(10) NOT NULL DEFAULT '0' COMMENT '积分',
  `successions` int(10) unsigned NOT NULL DEFAULT '1' COMMENT '连续登录天数',
  `maxsuccessions` int(10) unsigned NOT NULL DEFAULT '1' COMMENT '最大连续登录天数',
  `prevtime` bigint(16) DEFAULT NULL COMMENT '上次登录时间',
  `logintime` bigint(16) DEFAULT NULL COMMENT '登录时间',
  `loginip` varchar(50) DEFAULT '' COMMENT '登录IP',
  `loginfailure` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '失败次数',
  `joinip` varchar(50) DEFAULT '' COMMENT '加入IP',
  `jointime` bigint(16) DEFAULT NULL COMMENT '加入时间',
  `createtime` bigint(16) DEFAULT NULL COMMENT '创建时间',
  `updatetime` bigint(16) DEFAULT NULL COMMENT '更新时间',
  `token` varchar(50) DEFAULT '' COMMENT 'Token',
  `status` varchar(30) DEFAULT '' COMMENT '状态',
  `verification` varchar(255) DEFAULT '' COMMENT '验证',
  PRIMARY KEY (`id`),
  KEY `username` (`username`),
  KEY `email` (`email`),
  KEY `mobile` (`mobile`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='会员表';

-- ----------------------------
-- Table structure for `fa_user_group`
-- ----------------------------

DROP TABLE IF EXISTS `fa_user_group`;

CREATE TABLE `fa_user_group` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT '' COMMENT '组名',
  `rules` text COMMENT '权限节点',
  `createtime` bigint(16) DEFAULT NULL COMMENT '添加时间',
  `updatetime` bigint(16) DEFAULT NULL COMMENT '更新时间',
  `status` enum('normal','hidden') DEFAULT NULL COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COMMENT='会员组表';

-- ----------------------------
-- Table structure for `fa_user_money_log`
-- ----------------------------

DROP TABLE IF EXISTS `fa_user_money_log`;

CREATE TABLE `fa_user_money_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `money` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '变更余额',
  `before` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '变更前余额',
  `after` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '变更后余额',
  `memo` varchar(255) DEFAULT '' COMMENT '备注',
  `createtime` bigint(16) DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='会员余额变动表';

-- ----------------------------
-- Table structure for `fa_user_rule`
-- ----------------------------

DROP TABLE IF EXISTS `fa_user_rule`;

CREATE TABLE `fa_user_rule` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pid` int(10) DEFAULT NULL COMMENT '父ID',
  `name` varchar(50) DEFAULT NULL COMMENT '名称',
  `title` varchar(50) DEFAULT '' COMMENT '标题',
  `remark` varchar(100) DEFAULT NULL COMMENT '备注',
  `ismenu` tinyint(1) DEFAULT NULL COMMENT '是否菜单',
  `createtime` bigint(16) DEFAULT NULL COMMENT '创建时间',
  `updatetime` bigint(16) DEFAULT NULL COMMENT '更新时间',
  `weigh` int(10) DEFAULT '0' COMMENT '权重',
  `status` enum('normal','hidden') DEFAULT NULL COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COMMENT='会员规则表';

-- ----------------------------
-- Table structure for `fa_user_score_log`
-- ----------------------------

DROP TABLE IF EXISTS `fa_user_score_log`;

CREATE TABLE `fa_user_score_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `score` int(10) NOT NULL DEFAULT '0' COMMENT '变更积分',
  `before` int(10) NOT NULL DEFAULT '0' COMMENT '变更前积分',
  `after` int(10) NOT NULL DEFAULT '0' COMMENT '变更后积分',
  `memo` varchar(255) DEFAULT '' COMMENT '备注',
  `createtime` bigint(16) DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='会员积分变动表';

-- ----------------------------
-- Table structure for `fa_user_token`
-- ----------------------------

DROP TABLE IF EXISTS `fa_user_token`;

CREATE TABLE `fa_user_token` (
  `token` varchar(50) NOT NULL COMMENT 'Token',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `createtime` bigint(16) DEFAULT NULL COMMENT '创建时间',
  `expiretime` bigint(16) DEFAULT NULL COMMENT '过期时间',
  PRIMARY KEY (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='会员Token表';

-- ----------------------------
-- Table structure for `fa_version`
-- ----------------------------

DROP TABLE IF EXISTS `fa_version`;

CREATE TABLE `fa_version` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `oldversion` varchar(30) DEFAULT '' COMMENT '旧版本号',
  `newversion` varchar(30) DEFAULT '' COMMENT '新版本号',
  `packagesize` varchar(30) DEFAULT '' COMMENT '包大小',
  `content` varchar(500) DEFAULT '' COMMENT '升级内容',
  `downloadurl` varchar(255) DEFAULT '' COMMENT '下载地址',
  `enforce` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '强制更新',
  `createtime` bigint(16) DEFAULT NULL COMMENT '创建时间',
  `updatetime` bigint(16) DEFAULT NULL COMMENT '更新时间',
  `weigh` int(10) NOT NULL DEFAULT '0' COMMENT '权重',
  `status` varchar(30) DEFAULT '' COMMENT '状态',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='版本表';

